/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.visualeditor.internal.widget.gen.engine;

import java.util.List;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.gen.ComposeGenNode;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.gen.GenNode;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.gen.engine.IGenVariableResolver;

public class ChildWidgetsResolver
implements IGenVariableResolver {
    @Override
    public void resolve(GenNode genNode) {
        if (genNode instanceof ComposeGenNode) {
            ComposeGenNode composeGenNode = (ComposeGenNode)genNode;
            String template = composeGenNode.getTemplate();
            StringBuffer sbChildWidgets = new StringBuffer();
            List<GenNode> children = composeGenNode.getChildren();
            int i = 0;
            while (i < children.size()) {
                GenNode child = children.get(i);
                if (!child.equals(genNode)) {
                    Object oErrorLabelName;
                    Object oNameLabelName = child.getContext().get("NAME_LABEL_NAME");
                    if (oNameLabelName != null) {
                        String labelName = (String)oNameLabelName;
                        sbChildWidgets.append(labelName).append(",");
                    }
                    String widgetName = child.getInsertDataNode().getWidgetName();
                    sbChildWidgets.append(widgetName).append(",");
                    if (child.getInsertDataNode().getModel().isAddErrorMessage() && child.getInsertDataNode().getDataTemplate().isGenController() && (oErrorLabelName = child.getContext().get("ERROR_LABEL_NAME")) != null) {
                        String errorLabelName = (String)oErrorLabelName;
                        sbChildWidgets.append(errorLabelName).append(",");
                    }
                }
                ++i;
            }
            String childWidgets = sbChildWidgets.toString();
            if (!childWidgets.isEmpty()) {
                childWidgets = childWidgets.substring(0, childWidgets.lastIndexOf(","));
            }
            String newTemplate = template.replace("${childWidgets}", childWidgets);
            genNode.setTemplate(newTemplate);
        }
    }
}

