/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.visualeditor.internal.util;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public abstract class TableCellEditor {
    protected int _iColumn = -1;
    protected int _iDoubleClickExpirationTime = 0;
    protected CellEditor _cellEditor = null;
    protected FocusListener _focusListener = null;
    protected ICellEditorListener _cellEditorListener = null;
    protected MouseListener _mouseListener = null;
    protected String[] _straOptions = null;
    protected Table _table = null;
    protected TableEditor _tableEditor = null;
    protected TableItem _tableItem = null;

    public void activate(Table table, TableEditor tableEditor, CellEditor cellEditor, int iColumn, TableItem tableItemSelected) {
        this._table = table;
        this._tableEditor = tableEditor;
        this._cellEditor = cellEditor;
        this._iColumn = iColumn;
        this._tableItem = tableItemSelected;
        this._cellEditor.create((Composite)this._table);
        this._cellEditorListener = new ICellEditorListener(){

            public void editorValueChanged(boolean oldValidState, boolean newValidState) {
            }

            public void cancelEditor() {
                TableCellEditor.this.cancelEditing();
            }

            public void applyEditorValue() {
                TableCellEditor.this.applyCellEditorValue(TableCellEditor.this._tableItem, TableCellEditor.this._cellEditor, TableCellEditor.this._iColumn);
            }
        };
        this._cellEditor.addListener(this._cellEditorListener);
        Control control = this._cellEditor.getControl();
        this._cellEditor.activate();
        if (control == null) {
            return;
        }
        CellEditor.LayoutData layoutData = this._cellEditor.getLayoutData();
        this._tableEditor.grabHorizontal = layoutData.grabHorizontal;
        this._tableEditor.horizontalAlignment = layoutData.horizontalAlignment;
        this._tableEditor.minimumWidth = layoutData.minimumWidth;
        this._tableEditor.setEditor(control, tableItemSelected, this._iColumn);
        this._cellEditor.setFocus();
    }

    public abstract void applyCellEditorValue(TableItem var1, CellEditor var2, int var3);

    public void cancelEditing() {
        if (this._cellEditor != null) {
            this._cellEditor.removeListener(this._cellEditorListener);
            this._cellEditor.deactivate();
            this._cellEditor = null;
        }
        if (this._tableEditor != null) {
            this._tableEditor.setEditor(null, null, this._iColumn);
            this._tableEditor = null;
        }
        this._iColumn = -1;
        this._tableItem = null;
    }
}

