/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.visualeditor.internal.editor;

import java.awt.Dimension;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.edt.ide.rui.utils.WorkingCopyGenerationResult;
import org.eclipse.edt.ide.rui.visualeditor.internal.editor.EvDesignBrowserManager;
import org.eclipse.edt.ide.rui.visualeditor.internal.editor.EvDesignCaptureInformation;
import org.eclipse.edt.ide.rui.visualeditor.internal.editor.EvDesignOutlinePage;
import org.eclipse.edt.ide.rui.visualeditor.internal.editor.EvDesignOverlay;
import org.eclipse.edt.ide.rui.visualeditor.internal.editor.EvDesignOverlayDropLocation;
import org.eclipse.edt.ide.rui.visualeditor.internal.editor.EvDesignToolbar;
import org.eclipse.edt.ide.rui.visualeditor.internal.editor.EvEditPartFactory;
import org.eclipse.edt.ide.rui.visualeditor.internal.editor.EvEditor;
import org.eclipse.edt.ide.rui.visualeditor.internal.editor.EvPaletteViewerProvider;
import org.eclipse.edt.ide.rui.visualeditor.internal.editor.EvSourceOperation;
import org.eclipse.edt.ide.rui.visualeditor.internal.nl.Tooltips;
import org.eclipse.edt.ide.rui.visualeditor.internal.palette.EvPaletteRoot;
import org.eclipse.edt.ide.rui.visualeditor.internal.preferences.EvPreferences;
import org.eclipse.edt.ide.rui.visualeditor.internal.util.AnimatedBusyPainter;
import org.eclipse.edt.ide.rui.visualeditor.internal.util.BidiFormat;
import org.eclipse.edt.ide.rui.visualeditor.internal.util.BidiUtils;
import org.eclipse.edt.ide.rui.visualeditor.internal.util.ScrolledCompositeScroller;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.WidgetDescriptor;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.WidgetDescriptorRegistry;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.WidgetManager;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.WidgetPart;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.WidgetPropertyValue;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.editparts.ScalableRootEditPart;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.ui.palette.PaletteViewerProvider;
import org.eclipse.gef.ui.parts.GraphicalEditorWithFlyoutPalette;
import org.eclipse.gef.ui.parts.GraphicalViewerImpl;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;

public class EvDesignPage
extends GraphicalEditorWithFlyoutPalette
implements ControlListener,
DisposeListener,
IPropertyChangeListener,
PaintListener,
ProgressListener,
SelectionListener {
    protected static boolean bALIGNMENT_DONE = false;
    protected static Point ptBROWSER_LOCATION = new Point(0, 0);
    protected static int SLIDER_PAGE = 10;
    protected static int SLIDER_THUMB = 100;
    protected boolean _bAlignmentInProgress = false;
    protected boolean _bBrowserSizeControlsVisible = false;
    protected boolean _bGraphicsTransparencyAvailable = false;
    protected BidiFormat _bidiFormat = null;
    protected AnimatedBusyPainter _animatedBusyPainter = null;
    protected Browser _browser = null;
    protected EvDesignBrowserManager _browserManager = null;
    protected boolean _bUpdateRequired = true;
    protected boolean _bFullRefresh = true;
    protected Button _buttonResetToDefaultSize = null;
    protected EvDesignCaptureInformation _captureInfo = null;
    protected Composite _compositeBrowser = null;
    protected Composite _compositeDesign = null;
    protected Composite _compositeDesignArea = null;
    protected Composite _compositeFocus = null;
    protected Composite _compositeLayout = null;
    protected EvDesignOutlinePage _contentOutline = null;
    protected Dimension _dimSize = null;
    protected EvEditor _editor = null;
    protected WorkingCopyGenerationResult _generationResult = null;
    protected Label _labelSeparatorHorz = null;
    protected Label _labelSeparatorVert = null;
    protected Label _labelSizeVertical = null;
    protected EvDesignOverlay _overlay = null;
    protected ScrolledComposite _scrolledComposite = null;
    protected ScrolledCompositeScroller _scroller = null;
    protected Slider _sliderHorizontal = null;
    protected Slider _sliderVertical = null;
    protected CTabFolder _tabFolder = null;
    protected EvDesignToolbar _toolbar = null;
    protected ScrollingGraphicalViewer _viewer = null;
    protected WidgetManager _widgetManager = new WidgetManager();

    public EvDesignPage(EvEditor editor) {
        this._editor = editor;
        String strOperatingSystem = Platform.getOS();
        this._bGraphicsTransparencyAvailable = strOperatingSystem.equals("win32");
        this._captureInfo = new EvDesignCaptureInformation();
        this.setEditDomain(new DefaultEditDomain((IEditorPart)this));
        this.getPalettePreferences().setPaletteState(4);
    }

    protected boolean alignBrowserAndOverlayBegin() {
        if (this._browserManager == null) {
            return false;
        }
        this._bAlignmentInProgress = true;
        this._browserManager.setAlignmentTestMode(true);
        this._browserManager.refreshBrowser(true);
        this.capture();
        return true;
    }

    protected void alignBrowserAndOverlayEnd() {
        this._browserManager.setAlignmentTestMode(false);
        this._bAlignmentInProgress = false;
        bALIGNMENT_DONE = true;
        Point ptPattern = new Point(-1, -1);
        ImageData imageData = this._captureInfo.imageBrowser.getImageData();
        int iPattern = 1282408448;
        int[] iaPixels = new int[32];
        int y = 0;
        while (y < 16) {
            imageData.getPixels(0, y, iaPixels.length, iaPixels, 0);
            int x = 0;
            while (x < iaPixels.length) {
                if (iaPixels[x] != 0) {
                    iaPixels[x] = 1;
                }
                ++x;
            }
            int iBits = 0;
            int x2 = 0;
            while (x2 < 32) {
                iBits <<= 1;
                if (iaPixels[x2] == 1) {
                    iBits |= 1;
                }
                ++x2;
            }
            boolean bFound = false;
            int x3 = 0;
            while (x3 < 16) {
                int iTest = iBits & 0xFFFF0000;
                if (iTest == iPattern) {
                    ptPattern.x = x3;
                    bFound = true;
                    break;
                }
                iBits <<= 1;
                ++x3;
            }
            if (bFound) {
                ptPattern.y = y;
                break;
            }
            ++y;
        }
        if (ptPattern.x > -1 && ptPattern.y > -1) {
            EvDesignPage.ptBROWSER_LOCATION.x = -ptPattern.x;
            EvDesignPage.ptBROWSER_LOCATION.y = -ptPattern.y;
        } else {
            EvDesignPage.ptBROWSER_LOCATION.x = 0;
            EvDesignPage.ptBROWSER_LOCATION.y = 0;
        }
        this._compositeBrowser.setLocation(ptBROWSER_LOCATION);
        if (this._bGraphicsTransparencyAvailable) {
            this._captureInfo.imageBrowser.dispose();
            this._captureInfo.imageBrowser = null;
        }
        this.updateBrowserFullPartB();
    }

    protected void capture() {
        if (this._browser == null) {
            return;
        }
        if (this._bAlignmentInProgress || !this._bGraphicsTransparencyAvailable) {
            this._captureInfo.controlFocusBeforeCapture = this._compositeDesignArea.getDisplay().getFocusControl();
            this._compositeDesignArea.getDisplay().asyncExec((Runnable)new CapturePartA());
        }
    }

    public void changed(ProgressEvent event) {
    }

    public void completed(ProgressEvent event) {
        this._animatedBusyPainter.animationStop();
    }

    protected void computeWidgetIDs() {
        Hashtable<String, String> hashPackageAndTypeToProject = new Hashtable<String, String>();
        List listWidgetParts = this._widgetManager.getWidgetList();
        Iterator iterWidgetParts = listWidgetParts.iterator();
        StringBuffer strb = new StringBuffer();
        while (iterWidgetParts.hasNext()) {
            WidgetPart widgetPart = (WidgetPart)iterWidgetParts.next();
            String strTypeName = widgetPart.getTypeName();
            String strPackageName = widgetPart.getPackageName();
            strb.setLength(0);
            strb.append(strPackageName);
            strb.append("@@");
            strb.append(strTypeName);
            String strPackageAndType = strb.toString();
            String strProjectName = null;
            if (hashPackageAndTypeToProject.containsKey(strPackageAndType)) {
                strProjectName = (String)hashPackageAndTypeToProject.get(strPackageAndType);
            } else {
                WidgetDescriptorRegistry registry = WidgetDescriptorRegistry.getInstance(this.getEditor().getProject());
                WidgetDescriptor widgetDescriptor = registry.getDescriptor(strPackageName, strTypeName);
                strProjectName = widgetDescriptor != null ? widgetDescriptor.getProjectName() : this._editor.getWidgetProjectName(strPackageName, strTypeName);
                if (strProjectName != null) {
                    hashPackageAndTypeToProject.put(strPackageAndType, strProjectName);
                }
            }
            strb.setLength(0);
            if (strProjectName != null && strProjectName.length() > 0) {
                strb.append(strProjectName);
                strb.append("@@");
            }
            strb.append(strPackageAndType);
            widgetPart.setTypeID(strb.toString());
        }
    }

    public void controlMoved(ControlEvent event) {
        if (event.widget == this._compositeDesignArea) {
            this.capture();
        }
    }

    public void controlResized(ControlEvent event) {
        if (event.widget == this._scrolledComposite || event.widget == this._compositeDesignArea) {
            this.capture();
        }
    }

    protected void createBrowser() {
        this._browser = this._editor.createBrowser(this._compositeBrowser);
        this._compositeBrowser.layout();
        if (this._browser == null) {
            return;
        }
        this._browser.removeProgressListener((ProgressListener)this);
        this._browser.addProgressListener((ProgressListener)this);
        if (this._browserManager == null) {
            this._browserManager = new EvDesignBrowserManager(this._browser, this._editor.getURL(), this, this._editor.getEditorProvider());
        }
    }

    protected Control createDesignControl(Composite compositeParent) {
        this._bBrowserSizeControlsVisible = EvPreferences.getBoolean("org.eclipse.edt.ide.rui.visualeditor.BrowserSizeControlsVisible");
        this._compositeDesign = Locale.getDefault().toString().toLowerCase().indexOf("ar") != -1 ? new Composite(compositeParent, 0x2000800) : new Composite(compositeParent, 2048);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.numColumns = 2;
        this._compositeDesign.setLayout((Layout)gridLayout);
        this._compositeDesign.addDisposeListener((DisposeListener)this);
        this._animatedBusyPainter = new AnimatedBusyPainter(this._compositeDesign);
        GridData gridData = new GridData();
        gridData.widthHint = 16;
        gridData.heightHint = 16;
        gridData.horizontalIndent = 4;
        this._animatedBusyPainter.setLayoutData(gridData);
        this._toolbar = new EvDesignToolbar(this._compositeDesign, 0, this);
        gridData = new GridData(768);
        this._toolbar.setLayoutData(gridData);
        this._compositeFocus = new Composite(this._compositeDesign, 0);
        gridLayout = new GridLayout();
        this._compositeFocus.setLayout((Layout)gridLayout);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        gridData.heightHint = 2;
        this._compositeFocus.setLayoutData((Object)gridData);
        this._compositeFocus.addPaintListener((PaintListener)this);
        this._compositeLayout = new Composite(this._compositeDesign, 0);
        this._compositeLayout.setLayout((Layout)new DesignAreaLayout());
        gridData = new GridData(1808);
        this._compositeLayout.setLayoutData((Object)gridData);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        this._compositeLayout.setLayoutData((Object)gridData);
        this._scrolledComposite = new ScrolledComposite(this._compositeLayout, 768);
        this._scrolledComposite.setAlwaysShowScrollBars(true);
        if (!this._bGraphicsTransparencyAvailable) {
            this._scrolledComposite.addControlListener((ControlListener)this);
        }
        ScrollBar scrollbar = this._scrolledComposite.getHorizontalBar();
        scrollbar.setPageIncrement(200);
        scrollbar.setIncrement(16);
        scrollbar = this._scrolledComposite.getVerticalBar();
        scrollbar.setPageIncrement(200);
        scrollbar.setIncrement(16);
        this._dimSize = new Dimension(EvPreferences.getInt("org.eclipse.edt.ide.rui.visualeditor.BrowserSizeDefaultWidth"), EvPreferences.getInt("org.eclipse.edt.ide.rui.visualeditor.BrowserSizeDefaultHeight"));
        this._compositeDesignArea = new Composite((Composite)this._scrolledComposite, 262144);
        this._compositeDesignArea.setBounds(new Rectangle(0, 0, this._dimSize.width, this._dimSize.height));
        if (!this._bGraphicsTransparencyAvailable) {
            this._compositeDesignArea.addControlListener((ControlListener)this);
        }
        this._overlay = new EvDesignOverlay(this._compositeDesignArea, this);
        this._overlay.setBounds(new Rectangle(0, 0, this._dimSize.width, this._dimSize.height));
        this._compositeBrowser = new Composite(this._compositeDesignArea, 0);
        this._compositeBrowser.setLayout((Layout)new FillLayout());
        this._compositeBrowser.setBounds(new Rectangle(0, 0, this._dimSize.width, this._dimSize.height));
        this._scrolledComposite.setContent((Control)this._compositeDesignArea);
        this._scroller = new ScrolledCompositeScroller(this._scrolledComposite, this._overlay);
        this._sliderVertical = new Slider(this._compositeLayout, 512);
        this._sliderVertical.setValues(EvPreferences.getInt("org.eclipse.edt.ide.rui.visualeditor.BrowserSizeDefaultHeight"), EvPreferences.getInt("org.eclipse.edt.ide.rui.visualeditor.BrowserSizeMinimumHeight"), EvPreferences.getInt("org.eclipse.edt.ide.rui.visualeditor.BrowserSizeMaximumHeight") + SLIDER_THUMB, SLIDER_THUMB, 1, SLIDER_PAGE);
        this._sliderVertical.addSelectionListener((SelectionListener)this);
        this._sliderHorizontal = new Slider(this._compositeLayout, 2304);
        this._sliderHorizontal.setValues(EvPreferences.getInt("org.eclipse.edt.ide.rui.visualeditor.BrowserSizeDefaultWidth"), EvPreferences.getInt("org.eclipse.edt.ide.rui.visualeditor.BrowserSizeMinimumWidth"), EvPreferences.getInt("org.eclipse.edt.ide.rui.visualeditor.BrowserSizeMaximumWidth") + SLIDER_THUMB, SLIDER_THUMB, 1, SLIDER_PAGE);
        this._sliderHorizontal.addSelectionListener((SelectionListener)this);
        this._labelSeparatorHorz = new Label(this._compositeLayout, 258);
        this._labelSeparatorVert = new Label(this._compositeLayout, 514);
        this._buttonResetToDefaultSize = new Button(this._compositeLayout, 8);
        this._buttonResetToDefaultSize.setToolTipText(Tooltips.NL_Reset_browser_to_default_size);
        this._buttonResetToDefaultSize.addSelectionListener((SelectionListener)this);
        this._contentOutline = new EvDesignOutlinePage(this);
        EvPreferences.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        this.initializeGraphicalViewer();
        this._editor.getPageFolder().addSelectionListener((SelectionListener)this);
        return this._compositeDesign;
    }

    protected void createGraphicalViewer(Composite compositeParent) {
        EvDesignGraphicalViewer viewer = new EvDesignGraphicalViewer();
        this.setGraphicalViewer((GraphicalViewer)viewer);
        this.createDesignControl(compositeParent);
    }

    protected PaletteViewerProvider createPaletteViewerProvider() {
        return new EvPaletteViewerProvider((EditDomain)this.getEditDomain(), this);
    }

    public void doOperationWidgetCreate(WidgetDescriptor descriptor, EvDesignOverlayDropLocation location) {
        this._editor.doSourceOperationWidgetCreate(descriptor, location);
    }

    public void doOperationWidgetDelete(WidgetPart widget) {
        this._editor.doSourceOperationWidgetDelete(widget);
    }

    public void doOperationWidgetMove(WidgetPart widget, EvDesignOverlayDropLocation location) {
        this._editor.doSourceOperationWidgetMove(widget, location);
    }

    public void doOperationWidgetPropertyValueChanges(List listPropertyChanges) {
        this._editor.doSourceOperationWidgetPropertyValueChanges(listPropertyChanges);
    }

    public void doOperationWidgetOnclick(WidgetPart widget, String property, String value) {
        this._editor.doSourceOperationWidgetPropertyValueChange(widget, property, null, null, new WidgetPropertyValue(value), 1);
    }

    public void doSourceOperation(EvSourceOperation operation) {
        this._editor.doSourceOperation(operation);
    }

    public void doSave(IProgressMonitor arg0) {
    }

    public void doSaveAs() {
    }

    public IAction getAction(String strActionId) {
        if (strActionId.equals(ActionFactory.DELETE.getId())) {
            return this._overlay.getAction(strActionId);
        }
        if (strActionId.equals(ActionFactory.PROPERTIES.getId())) {
            return this._overlay.getAction(strActionId);
        }
        return null;
    }

    public BidiFormat getBidiFormat() {
        if (this._bidiFormat == null) {
            return BidiUtils.getBidiFormatFromPreferences();
        }
        return this._bidiFormat;
    }

    public Browser getBrowser() {
        return this._browser;
    }

    public EvDesignCaptureInformation getCaptureInformation() {
        return this._captureInfo;
    }

    public EvDesignOutlinePage getContentOutline() {
        return this._contentOutline;
    }

    public EvEditor getEditor() {
        return this._editor;
    }

    public Control getGraphicalControl() {
        return this._compositeDesign;
    }

    protected PaletteRoot getPaletteRoot() {
        EvPaletteRoot paletteRoot = EvPaletteRoot.getInstance(this.getEditor().getProject());
        return paletteRoot;
    }

    public ScrolledCompositeScroller getScroller() {
        return this._scroller;
    }

    public Shell getShell() {
        return this._browser.getShell();
    }

    public WidgetPart getWidget(int iOffset, int iLength) {
        return this._widgetManager.getWidget(iOffset, iLength);
    }

    public WidgetManager getWidgetManager() {
        return this._widgetManager;
    }

    public WidgetPart getWidgetSelected() {
        return this._overlay.getWidgetSelected();
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.setSite((IWorkbenchPartSite)site);
        super.setInput(input);
    }

    public void inputChanged(IEditorInput input) {
        if (this._browserManager != null) {
            this._browserManager = new EvDesignBrowserManager(this._browser, this._editor.getURL(), this, this._editor.getEditorProvider());
        }
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isGraphicsTransparencyAvailable() {
        return this._bGraphicsTransparencyAvailable;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void overlayFocusChanged(boolean bOverlayHasFocus) {
        this._compositeFocus.redraw();
    }

    public void paletteItemSelected(String strWidgetTypeID) {
        if (strWidgetTypeID == null) {
            return;
        }
        boolean bAllowDrop = this._editor.isRuiHandler();
        if (!bAllowDrop) {
            return;
        }
        WidgetDescriptor descriptor = WidgetDescriptorRegistry.getInstance(this.getEditor().getProject()).getDescriptor(strWidgetTypeID);
        if (descriptor == null) {
            return;
        }
        EvDesignOverlayDropLocation location = new EvDesignOverlayDropLocation();
        location.widgetParent = this._widgetManager.getWidgetRoot();
        location.iIndex = this._widgetManager.getWidgetRoot().getChildren().size();
        this._overlay.rememberSelectionHierarchyForOperation(location.widgetParent, location.iIndex);
        this.doOperationWidgetCreate(descriptor, location);
    }

    public void propertyChange(PropertyChangeEvent event) {
        String strProperty = event.getProperty();
        try {
            if (strProperty.indexOf("BrowserSize") >= 0) {
                boolean bChanged = this.updateBrowserSizeControls();
                if (bChanged) {
                    this._compositeDesignArea.setBounds(new Rectangle(0, 0, this._dimSize.width, this._dimSize.height));
                    this._overlay.setBounds(new Rectangle(0, 0, this._dimSize.width, this._dimSize.height));
                    this._compositeBrowser.setBounds(new Rectangle(EvDesignPage.ptBROWSER_LOCATION.x, EvDesignPage.ptBROWSER_LOCATION.y, this._dimSize.width, this._dimSize.height));
                }
            } else if (strProperty.equals("org.eclipse.edt.ide.rui.visualeditor.ColorSelection") || strProperty.equals("org.eclipse.edt.ide.rui.visualeditor.ColorDropLocationPotential") || strProperty.equals("org.eclipse.edt.ide.rui.visualeditor.ColorDropLocationSelected") || strProperty.equals("org.eclipse.edt.ide.rui.visualeditor.PatternDropLocationSelected") || strProperty.equals("org.eclipse.edt.ide.rui.visualeditor.PatternSelection")) {
                this._overlay.updateColors();
            } else if (strProperty.equals("isBidi")) {
                this._toolbar._itemBidiPreferences.setEnabled(((Boolean)event.getNewValue()).booleanValue());
            }
        }
        catch (SWTException sWTException) {}
    }

    public void refreshPalette() {
        this.getEditor().getEditorProvider().eglpathUpdated();
        WidgetDescriptorRegistry.getInstance(this.getEditor().getProject()).reinitialize();
    }

    public void resetBrowserToNull() {
        this._browser = null;
    }

    public void selectWidget(WidgetPart widget) {
        this._overlay.selectWidget(widget);
        this._overlay.redraw();
    }

    public void setBidiFormat(BidiFormat bidiFormat) {
        this._bidiFormat = bidiFormat;
    }

    public void setDesignMode(boolean bDesign) {
        if (this._compositeBrowser == null || this._overlay == null || this._compositeBrowser.isDisposed() || this._overlay.isDisposed()) {
            return;
        }
        if (bDesign) {
            this._compositeBrowser.moveBelow((Control)this._overlay);
        } else {
            this._compositeBrowser.moveAbove((Control)this._overlay);
        }
    }

    public void setFocus() {
        this._overlay.setFocus();
    }

    public void setTransparency(int iTransparencyMode, int iTransparencyValue) {
        this._overlay.setTransparency(iTransparencyMode, iTransparencyValue);
    }

    public void terminate() {
        if (this._browserManager != null) {
            this._browserManager.terminate();
        }
    }

    protected void updateBrowser(WorkingCopyGenerationResult result) {
        this.updateBrowserFullPartA(result);
    }

    protected void updateBrowserFullPartA(WorkingCopyGenerationResult result) {
        this._generationResult = result;
        if (this.getEditor().getPageIndex() != 0) {
            this._bUpdateRequired = true;
            return;
        }
        if (this._browser == null) {
            this.createBrowser();
        }
        if (!bALIGNMENT_DONE) {
            boolean bStarted = this.alignBrowserAndOverlayBegin();
            if (!bStarted) {
                bALIGNMENT_DONE = true;
                this.updateBrowserFullPartB();
            }
        } else {
            if (result == null || result.hasError()) {
                this._bFullRefresh = true;
            }
            this.updateBrowserFullPartB();
        }
    }

    protected void updateBrowserFullPartB() {
        if (this._browser != null) {
            this._animatedBusyPainter.animationStart();
            this._widgetManager.removeAllWidgets();
            if (this._generationResult != null) {
                int iNumberOfGenerationErrors = this._generationResult.getNumGenErrors();
                this.setDesignMode(iNumberOfGenerationErrors == 0);
            }
            if (this._browserManager != null) {
                this._browserManager.refreshBrowser(this._bFullRefresh);
                this._bFullRefresh = false;
            }
        }
        this._bUpdateRequired = false;
    }

    protected void updateBrowserIncremental(WorkingCopyGenerationResult result) {
        this._generationResult = result;
        if (!this._editor.isRuiHandler()) {
            return;
        }
        if (this.getEditor().getPageIndex() != 0) {
            this._bUpdateRequired = true;
            return;
        }
        if (this._browser == null) {
            this.createBrowser();
        }
        this._widgetManager.removeAllWidgets();
        int iNumberOfGenerationErrors = result.getNumGenErrors();
        this.setDesignMode(iNumberOfGenerationErrors == 0);
        if (this._browserManager != null) {
            this._browserManager.refreshBrowserIncremental();
        }
        this._bUpdateRequired = false;
        if (result.hasError()) {
            this.updateBrowser(result);
            this.getEditor().showSourcePage();
        }
    }

    protected void changeProperty(WorkingCopyGenerationResult result, WidgetPart widget, String property, String value, int totalCharactersChanged) {
        this._generationResult = result;
        if (!this._editor.isRuiHandler()) {
            return;
        }
        if (this.getEditor().getPageIndex() != 0) {
            this._bUpdateRequired = true;
            return;
        }
        if (this._browser == null) {
            this.createBrowser();
        }
        this._widgetManager.removeAllWidgets();
        int iNumberOfGenerationErrors = result.getNumGenErrors();
        this.setDesignMode(iNumberOfGenerationErrors == 0);
        if (this._browserManager != null) {
            this._browserManager.changeProperty(widget, property, value, totalCharactersChanged);
        }
        this._bUpdateRequired = false;
    }

    protected void moveWidget(WorkingCopyGenerationResult result, WidgetPart widget, WidgetPart targetParent, int oldIndex, int newIndex, int[] charactersChanged) {
        this._generationResult = result;
        if (!this._editor.isRuiHandler()) {
            return;
        }
        if (this.getEditor().getPageIndex() != 0) {
            return;
        }
        if (this._browser == null) {
            this.createBrowser();
        }
        this._widgetManager.removeAllWidgets();
        int iNumberOfGenerationErrors = result.getNumGenErrors();
        this.setDesignMode(iNumberOfGenerationErrors == 0);
        if (this._browserManager != null) {
            this._browserManager.moveWidget(widget, targetParent, oldIndex, newIndex, charactersChanged);
        }
        this._bUpdateRequired = false;
    }

    protected void deleteWidget(WorkingCopyGenerationResult result, WidgetPart widget, int totalCharactersRemoved) {
        this._generationResult = result;
        if (!this._editor.isRuiHandler()) {
            return;
        }
        if (this.getEditor().getPageIndex() != 0) {
            this._bUpdateRequired = true;
            return;
        }
        if (this._browser == null) {
            this.createBrowser();
        }
        this._widgetManager.removeAllWidgets();
        int iNumberOfGenerationErrors = result.getNumGenErrors();
        this.setDesignMode(iNumberOfGenerationErrors == 0);
        if (this._browserManager != null) {
            this._browserManager.deleteWidget(widget, totalCharactersRemoved);
        }
        this._bUpdateRequired = false;
    }

    protected boolean updateBrowserSizeControls() {
        boolean bYMax;
        int iXMin = EvPreferences.getInt("org.eclipse.edt.ide.rui.visualeditor.BrowserSizeMinimumWidth");
        boolean bXMin = iXMin == this._sliderHorizontal.getMinimum();
        int iXDef = EvPreferences.getInt("org.eclipse.edt.ide.rui.visualeditor.BrowserSizeDefaultWidth");
        boolean bXDef = iXDef == this._sliderHorizontal.getSelection();
        int iXMax = EvPreferences.getInt("org.eclipse.edt.ide.rui.visualeditor.BrowserSizeMaximumWidth");
        boolean bXMax = iXMax == this._sliderHorizontal.getMaximum() - SLIDER_THUMB;
        int iYMin = EvPreferences.getInt("org.eclipse.edt.ide.rui.visualeditor.BrowserSizeMinimumHeight");
        boolean bYMin = iYMin == this._sliderVertical.getMinimum();
        int iYDef = EvPreferences.getInt("org.eclipse.edt.ide.rui.visualeditor.BrowserSizeDefaultHeight");
        boolean bYDef = iYDef == this._sliderVertical.getSelection();
        int iYMax = EvPreferences.getInt("org.eclipse.edt.ide.rui.visualeditor.BrowserSizeMaximumHeight");
        boolean bl = bYMax = iYMax == this._sliderVertical.getMaximum() - SLIDER_THUMB;
        if (bXMin && bXDef && bXMax && bYMin && bYDef && bYMax) {
            return false;
        }
        this._dimSize.width = EvPreferences.getInt("org.eclipse.edt.ide.rui.visualeditor.BrowserSizeDefaultWidth");
        this._dimSize.height = EvPreferences.getInt("org.eclipse.edt.ide.rui.visualeditor.BrowserSizeDefaultHeight");
        this._sliderHorizontal.setValues(this._dimSize.width, EvPreferences.getInt("org.eclipse.edt.ide.rui.visualeditor.BrowserSizeMinimumWidth"), EvPreferences.getInt("org.eclipse.edt.ide.rui.visualeditor.BrowserSizeMaximumWidth") + SLIDER_THUMB, SLIDER_THUMB, 1, SLIDER_PAGE);
        this._sliderVertical.setValues(this._dimSize.height, EvPreferences.getInt("org.eclipse.edt.ide.rui.visualeditor.BrowserSizeMinimumHeight"), EvPreferences.getInt("org.eclipse.edt.ide.rui.visualeditor.BrowserSizeMaximumHeight") + SLIDER_THUMB, SLIDER_THUMB, 1, SLIDER_PAGE);
        this._buttonResetToDefaultSize.setEnabled(false);
        this.updateBrowserSizeControlsTooltips();
        return true;
    }

    protected void updateBrowserSizeControlsDefaultButton() {
        boolean bNotDefaultX = this._dimSize.width != EvPreferences.getInt("org.eclipse.edt.ide.rui.visualeditor.BrowserSizeDefaultWidth");
        boolean bNotDefaultY = this._dimSize.height != EvPreferences.getInt("org.eclipse.edt.ide.rui.visualeditor.BrowserSizeDefaultHeight");
        this._buttonResetToDefaultSize.setEnabled(bNotDefaultX || bNotDefaultY);
    }

    protected void updateBrowserSizeControlsTooltips() {
        if (Locale.getDefault().toString().toLowerCase().indexOf("ar") != -1) {
            this._sliderHorizontal.setToolTipText(String.valueOf(Tooltips.NL_Browser_width) + " " + Integer.toString(this._dimSize.width));
            this._sliderVertical.setToolTipText(String.valueOf(Tooltips.NL_Browser_height) + " " + Integer.toString(this._dimSize.height));
        } else {
            this._sliderHorizontal.setToolTipText(String.valueOf(Tooltips.NL_Browser_width) + "\n" + Integer.toString(this._dimSize.width));
            this._sliderVertical.setToolTipText(String.valueOf(Tooltips.NL_Browser_height) + "\n" + Integer.toString(this._dimSize.height));
        }
    }

    protected void updateBrowserSizeControlsVisible(boolean bVisible) {
        this._bBrowserSizeControlsVisible = bVisible;
        this._compositeLayout.layout();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetDisposed(DisposeEvent e) {
        if (this._captureInfo != null && this._captureInfo.imageBrowser != null && !this._captureInfo.imageBrowser.isDisposed()) {
            this._captureInfo.imageBrowser.dispose();
            this._captureInfo.imageBrowser = null;
        }
    }

    public void widgetsChanged() {
        this.computeWidgetIDs();
        this._animatedBusyPainter.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                EvDesignPage.this._animatedBusyPainter.animationStop();
                EvDesignPage.this._overlay.widgetsChanged();
                EvDesignPage.this._contentOutline.update();
            }
        });
    }

    public void widgetSelected(SelectionEvent event) {
        if (event.widget == this._sliderHorizontal) {
            this._dimSize.width = this._sliderHorizontal.getSelection();
            this._compositeDesignArea.setBounds(new Rectangle(0, 0, this._dimSize.width, this._dimSize.height));
            this._overlay.setBounds(new Rectangle(0, 0, this._dimSize.width, this._dimSize.height));
            this._compositeBrowser.setBounds(new Rectangle(EvDesignPage.ptBROWSER_LOCATION.x, EvDesignPage.ptBROWSER_LOCATION.y, this._dimSize.width, this._dimSize.height));
            this.updateBrowserSizeControlsDefaultButton();
            this.updateBrowserSizeControlsTooltips();
        } else if (event.widget == this._sliderVertical) {
            this._dimSize.height = this._sliderVertical.getSelection();
            this._compositeDesignArea.setBounds(new Rectangle(0, 0, this._dimSize.width, this._dimSize.height));
            this._overlay.setBounds(new Rectangle(0, 0, this._dimSize.width, this._dimSize.height));
            this._compositeBrowser.setBounds(new Rectangle(EvDesignPage.ptBROWSER_LOCATION.x, EvDesignPage.ptBROWSER_LOCATION.y, this._dimSize.width, this._dimSize.height));
            this.updateBrowserSizeControlsDefaultButton();
            this.updateBrowserSizeControlsTooltips();
        } else if (event.widget == this._buttonResetToDefaultSize) {
            this._dimSize.width = EvPreferences.getInt("org.eclipse.edt.ide.rui.visualeditor.BrowserSizeDefaultWidth");
            this._dimSize.height = EvPreferences.getInt("org.eclipse.edt.ide.rui.visualeditor.BrowserSizeDefaultHeight");
            this._sliderHorizontal.setSelection(this._dimSize.width);
            this._sliderVertical.setSelection(this._dimSize.height);
            this._buttonResetToDefaultSize.setEnabled(false);
            this.updateBrowserSizeControlsTooltips();
            this._compositeDesignArea.setBounds(new Rectangle(0, 0, this._dimSize.width, this._dimSize.height));
            this._overlay.setBounds(new Rectangle(0, 0, this._dimSize.width, this._dimSize.height));
            this._compositeBrowser.setBounds(new Rectangle(EvDesignPage.ptBROWSER_LOCATION.x, EvDesignPage.ptBROWSER_LOCATION.y, this._dimSize.width, this._dimSize.height));
        } else if (event.widget instanceof CTabFolder) {
            CTabFolder tabFolder = (CTabFolder)event.widget;
            if (tabFolder.getSelectionIndex() != 0 || !this._editor.isRuiHandler()) {
                return;
            }
            if (this._browser == null || this._bUpdateRequired) {
                this.updateBrowser(this._generationResult);
            }
        }
    }

    public void widgetSelectedFromDesignCanvas(WidgetPart widget) {
        this._editor.widgetSelectedFromDesignPage(widget);
    }

    public void paintControl(PaintEvent e) {
        Rectangle rectBounds = this._compositeFocus.getBounds();
        e.gc.fillRectangle(rectBounds);
        if (this._overlay.isFocusControl()) {
            Point ptSize = this._compositeFocus.getSize();
            e.gc.setLineWidth(1);
            e.gc.setForeground(this._compositeFocus.getDisplay().getSystemColor(16));
            e.gc.drawLine(0, 0, ptSize.x, 0);
        }
    }

    protected class CapturePartA
    implements Runnable {
        protected CapturePartA() {
        }

        @Override
        public void run() {
            if (EvDesignPage.this._captureInfo.bCaptureRunning) {
                return;
            }
            EvDesignPage.this._captureInfo.bCaptureRunning = true;
            if (!EvDesignPage.this._bGraphicsTransparencyAvailable) {
                EvDesignPage.this._compositeBrowser.setLocation(EvDesignPage.ptBROWSER_LOCATION.x, EvDesignPage.ptBROWSER_LOCATION.y);
            }
            EvDesignPage.this.setDesignMode(false);
            Rectangle rectB = EvDesignPage.this._compositeDesignArea.getBounds();
            EvDesignPage.this._compositeDesignArea.redraw(0, 0, rectB.width, rectB.height, true);
            EvDesignPage.this._compositeDesignArea.getDisplay().asyncExec((Runnable)new CapturePartB());
        }
    }

    protected class CapturePartB
    implements Runnable {
        protected CapturePartB() {
        }

        @Override
        public void run() {
            Rectangle rectBrowser = EvDesignPage.this._compositeDesignArea.getBounds();
            if (EvDesignPage.this._captureInfo.imageBrowser != null) {
                Rectangle rectBrowserImage = EvDesignPage.this._captureInfo.imageBrowser.getBounds();
                if (rectBrowser.width != rectBrowserImage.width || rectBrowser.height != rectBrowserImage.height) {
                    EvDesignPage.this._captureInfo.imageBrowser.dispose();
                    EvDesignPage.this._captureInfo.imageBrowser = null;
                }
            }
            if (EvDesignPage.this._captureInfo.imageBrowser == null) {
                EvDesignPage.this._captureInfo.imageBrowser = new Image((Device)EvDesignPage.this._compositeDesignArea.getDisplay(), rectBrowser.width, rectBrowser.height);
            }
            GC gcBrowserWidget = new GC((Drawable)EvDesignPage.this._browser);
            gcBrowserWidget.copyArea(EvDesignPage.this._captureInfo.imageBrowser, 0, 0);
            Point ptOrigin = EvDesignPage.this._scrolledComposite.getOrigin();
            Rectangle rectClient = EvDesignPage.this._scrolledComposite.getClientArea();
            EvDesignPage.this._captureInfo.rectCapture.x = ptOrigin.x;
            EvDesignPage.this._captureInfo.rectCapture.y = ptOrigin.y;
            EvDesignPage.this._captureInfo.rectCapture.width = rectClient.width;
            EvDesignPage.this._captureInfo.rectCapture.height = rectClient.height;
            gcBrowserWidget.dispose();
            if (!EvDesignPage.this._bGraphicsTransparencyAvailable) {
                Rectangle rectBounds = EvDesignPage.this._compositeBrowser.getBounds();
                EvDesignPage.this._compositeBrowser.setLocation(rectBounds.x, -rectBounds.height);
            }
            EvDesignPage.this.setDesignMode(true);
            EvDesignPage.this._captureInfo.bCaptureRunning = false;
            if (EvDesignPage.this._captureInfo.controlFocusBeforeCapture != null && !EvDesignPage.this._captureInfo.controlFocusBeforeCapture.isDisposed()) {
                EvDesignPage.this._captureInfo.controlFocusBeforeCapture.setFocus();
            }
            if (EvDesignPage.this._bAlignmentInProgress) {
                EvDesignPage.this.alignBrowserAndOverlayEnd();
            }
        }
    }

    protected class DesignAreaLayout
    extends Layout {
        protected DesignAreaLayout() {
        }

        protected Point computeSize(Composite composite, int hint, int hint2, boolean flushCache) {
            return new Point(0, 0);
        }

        protected void layout(Composite composite, boolean flushCache) {
            if (EvDesignPage.this._sliderHorizontal == null) {
                return;
            }
            EvDesignPage.this._sliderHorizontal.pack();
            EvDesignPage.this._sliderVertical.pack();
            EvDesignPage.this._labelSeparatorHorz.pack();
            EvDesignPage.this._labelSeparatorVert.pack();
            Point ptSliderHorz = null;
            Point ptSliderVert = null;
            Point ptSeparatorHorz = null;
            Point ptSeparatorVert = null;
            if (EvDesignPage.this._bBrowserSizeControlsVisible) {
                ptSliderHorz = EvDesignPage.this._sliderHorizontal.getSize();
                ptSliderVert = EvDesignPage.this._sliderVertical.getSize();
                ptSeparatorHorz = EvDesignPage.this._labelSeparatorHorz.getSize();
                ptSeparatorVert = EvDesignPage.this._labelSeparatorVert.getSize();
            } else {
                ptSeparatorHorz = ptSeparatorVert = new Point(0, 0);
                ptSliderVert = ptSeparatorVert;
                ptSliderHorz = ptSeparatorVert;
            }
            EvDesignPage.this._sliderHorizontal.setVisible(EvDesignPage.this._bBrowserSizeControlsVisible);
            EvDesignPage.this._sliderVertical.setVisible(EvDesignPage.this._bBrowserSizeControlsVisible);
            EvDesignPage.this._labelSeparatorHorz.setVisible(EvDesignPage.this._bBrowserSizeControlsVisible);
            EvDesignPage.this._labelSeparatorVert.setVisible(EvDesignPage.this._bBrowserSizeControlsVisible);
            EvDesignPage.this._buttonResetToDefaultSize.setVisible(EvDesignPage.this._bBrowserSizeControlsVisible);
            Rectangle rectBounds = composite.getBounds();
            Rectangle rect = new Rectangle(0, 0, rectBounds.width - ptSliderVert.x - ptSeparatorVert.x, rectBounds.height - ptSliderHorz.y - ptSeparatorHorz.y);
            EvDesignPage.this._scrolledComposite.setBounds(rect);
            if (EvDesignPage.this._bBrowserSizeControlsVisible) {
                rect = new Rectangle(0, rectBounds.height - ptSliderHorz.y, rectBounds.width - ptSliderVert.x - ptSeparatorVert.x, ptSliderHorz.y);
                EvDesignPage.this._sliderHorizontal.setBounds(rect);
                rect = new Rectangle(rectBounds.width - ptSliderVert.x, 0, ptSliderVert.x, rectBounds.height - ptSliderHorz.y - ptSeparatorHorz.y);
                EvDesignPage.this._sliderVertical.setBounds(rect);
                rect = new Rectangle(0, rectBounds.height - ptSliderHorz.y - ptSeparatorHorz.y, rectBounds.width - ptSliderVert.x - ptSeparatorVert.x, ptSeparatorHorz.y);
                EvDesignPage.this._labelSeparatorHorz.setBounds(rect);
                rect = new Rectangle(rectBounds.width - ptSliderVert.x - ptSeparatorVert.x, 0, ptSeparatorVert.x, rectBounds.height - ptSliderHorz.y - ptSeparatorHorz.y);
                EvDesignPage.this._labelSeparatorVert.setBounds(rect);
                rect = new Rectangle(rectBounds.width - ptSliderVert.x, rectBounds.height - ptSliderHorz.y, ptSliderVert.x, ptSliderHorz.y);
                EvDesignPage.this._buttonResetToDefaultSize.setBounds(rect);
            }
        }
    }

    protected class EvDesignGraphicalViewer
    extends GraphicalViewerImpl {
        public EvDesignGraphicalViewer() {
            this.setRootEditPart((RootEditPart)new ScalableRootEditPart());
            this.setEditDomain(this.getEditDomain());
            this.setEditPartFactory(new EvEditPartFactory());
            this.setContents(new String());
        }
    }
}

