/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.visualeditor.internal.editor;

import org.eclipse.edt.ide.rui.server.AbstractPreviewContext;
import org.eclipse.edt.ide.rui.server.DesignContext;
import org.eclipse.edt.ide.rui.server.DesignPaneContentProvider;
import org.eclipse.edt.ide.rui.server.EvEditorProvider;
import org.eclipse.edt.ide.rui.server.IServerContentProvider;
import org.eclipse.edt.ide.rui.server.IServerListener;
import org.eclipse.edt.ide.rui.visualeditor.internal.editor.EvDesignPage;
import org.eclipse.edt.ide.rui.visualeditor.internal.editor.EvPreviewBrowserManager;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.WidgetManager;
import org.eclipse.edt.ide.rui.visualeditor.plugin.Activator;
import org.eclipse.swt.browser.Browser;

public class EvDesignBrowserManager
extends EvPreviewBrowserManager
implements IServerListener {
    protected boolean _bAlignmentTestMode = false;
    protected EvDesignPage _pageDesign = null;
    protected String _strNonAlignmentTestURL = null;

    public EvDesignBrowserManager(Browser browser, String strURL, EvDesignPage pageDesign, EvEditorProvider editorProvider) {
        super(browser, strURL, editorProvider);
        this._pageDesign = pageDesign;
    }

    @Override
    public void acceptWidgetPositions(String strJson) {
        WidgetManager widgetManager = this._pageDesign.getWidgetManager();
        widgetManager.setWidgetsFromJsonString(strJson);
        this._pageDesign.widgetsChanged();
    }

    @Override
    protected AbstractPreviewContext createContext(EvEditorProvider editorProvider) {
        return new DesignContext(this._strURL, this._intKey, (IServerContentProvider)new DesignPaneContentProvider(editorProvider), (IServerListener)this);
    }

    @Override
    public synchronized void refreshBrowser(boolean fullRefresh) {
        if (!this._bAlignmentTestMode) {
            super.refreshBrowser(fullRefresh);
            return;
        }
        if (this._browser == null) {
            return;
        }
        String strURL = Activator.getStateResourceURL("alignmenttest.html");
        if (strURL != null) {
            this._browser.setUrl(strURL);
        }
    }

    @Override
    public void selectTextInEditor(int offset, int length) {
        if (this._pageDesign == null) {
            return;
        }
        this._pageDesign.getEditor().getPageSource().selectAndReveal(offset, length);
        this._pageDesign.getEditor().showPage(1);
    }

    public void setAlignmentTestMode(boolean bAlignmentTestMode) {
        this._bAlignmentTestMode = bAlignmentTestMode;
        if (bAlignmentTestMode) {
            this._strNonAlignmentTestURL = this._strURL;
        }
    }
}

