/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.wizards;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.edt.compiler.core.ast.ExternalType;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.ui.wizards.ExtractInterfaceConfiguration;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbench;

public class ExtractInterfaceFrExternalTypeConfiguration
extends ExtractInterfaceConfiguration {
    private ExternalType[] fBoundExternalTypes;
    private List fExtraInterfaceConfigs = new ArrayList();

    public void init(String ETPkgName, String ETFileName, Part[] astParts) {
        this.setFPackage(ETPkgName);
        String namePrefix = "I";
        this.setFileName(String.valueOf(namePrefix) + ETFileName);
        this.fExtraInterfaceConfigs = new ArrayList();
        int len = astParts.length;
        this.fBoundExternalTypes = new ExternalType[len];
        int i = 0;
        while (i < len) {
            if (astParts[i] instanceof ExternalType) {
                this.fBoundExternalTypes[i] = (ExternalType)astParts[i];
                this.initExtractInterfaceConfigs(astParts[i], namePrefix);
            }
            ++i;
        }
    }

    @Override
    public void init(IWorkbench workbench, IStructuredSelection selection) {
        super.init(workbench, selection);
        IEGLFile eglFile = this.getSelectedIEGLFile(selection);
        if (eglFile != null) {
            List boundParts = ExtractInterfaceFrExternalTypeConfiguration.getBoundParts(eglFile);
            for (Part boundPart : boundParts) {
                this.initExtractInterfaceConfigs(boundPart, "");
            }
        }
    }

    private void initExtractInterfaceConfigs(Part boundPart, String namePrefix) {
        if (boundPart instanceof ExternalType) {
            ExtractInterfaceConfiguration configElem = new ExtractInterfaceConfiguration();
            configElem.setInterfaceName(String.valueOf(namePrefix) + boundPart.getName().getCaseSensitiveIdentifier());
            configElem.initBoundPart_FunctionList(boundPart);
            this.fExtraInterfaceConfigs.add(configElem);
        }
    }

    public List getExtractInterfaceConfigurations() {
        return this.fExtraInterfaceConfigs;
    }

    public void setBoundParts(Part[] boundParts) {
        int len = boundParts.length;
        int boundIdx = 0;
        int i = 0;
        while (i < len) {
            if (boundParts[i] instanceof ExternalType) {
                this.fBoundExternalTypes[boundIdx] = (ExternalType)boundParts[i];
                ((ExtractInterfaceConfiguration)this.getExtractInterfaceConfigurations().get(boundIdx++)).setTheBoundPart(boundParts[i]);
            }
            ++i;
        }
    }
}

