/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.preferences;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.edt.ide.core.EDTCoreIDEPlugin;
import org.eclipse.edt.ide.core.IGenerator;
import org.eclipse.edt.ide.core.IIDECompiler;
import org.eclipse.edt.ide.core.utils.ProjectSettingsUtility;
import org.eclipse.edt.ide.ui.internal.UINlsStrings;
import org.eclipse.edt.ide.ui.internal.util.PixelConverter;
import org.eclipse.edt.ide.ui.internal.wizards.NewWizardMessages;
import org.eclipse.edt.ide.ui.preferences.CompilerPropertyAndPreferencePage;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.part.PageBook;

public class CompilerAndGeneratorControls {
    protected CompilerPropertyAndPreferencePage parentPage;
    private CompilerComponent compilerComponent;
    protected PixelConverter fPixelConverter;

    public CompilerAndGeneratorControls(CompilerPropertyAndPreferencePage parentPage) {
        this.parentPage = parentPage;
        this.compilerComponent = new CompilerComponent();
    }

    public void createCompilersComposite(Composite parent) {
        IIDECompiler[] compilers = this.getCompilersToDisplay();
        String[] displayItems = new String[compilers.length];
        int i = 0;
        while (i < compilers.length) {
            displayItems[i] = compilers[i].getName();
            ++i;
        }
        String compilerLabel = this.parentPage.getResource() == null ? UINlsStrings.CompilerPreferencePage_defaultCompilerLabel : UINlsStrings.CompilerPreferencePage_selectedCompilerLabel;
        ComboPreference comboPref = new ComboPreference(parent, 2, compilerLabel, displayItems);
        this.compilerComponent.fCompilerCombo = (Combo)comboPref.getControl();
        this.compilerComponent.fCompilerCombo.addSelectionListener((SelectionListener)this.compilerComponent);
        if (this.parentPage.getResource() != null && this.parentPage.getResource().getType() != 4) {
            this.compilerComponent.fCompilerCombo.setEnabled(false);
        }
    }

    protected IIDECompiler[] getCompilersToDisplay() {
        IIDECompiler[] availableCompilers = EDTCoreIDEPlugin.getPlugin().getCompilers();
        if (this.parentPage.getResource() == null || this.parentPage.getResource() instanceof IProject) {
            return availableCompilers;
        }
        IIDECompiler comp = ProjectSettingsUtility.getCompiler((IProject)this.parentPage.getResource().getProject());
        if (comp == null) {
            String wsComp = EDTCoreIDEPlugin.getPlugin().getPreferenceStore().getString("compilerId");
            IIDECompiler[] iIDECompilerArray = availableCompilers;
            int n = availableCompilers.length;
            int n2 = 0;
            while (n2 < n) {
                IIDECompiler currCompiler = iIDECompilerArray[n2];
                if (currCompiler.getId().equalsIgnoreCase(wsComp)) {
                    comp = currCompiler;
                    break;
                }
                ++n2;
            }
        }
        return new IIDECompiler[]{comp};
    }

    public void createGeneratorsComposite(Composite parent) {
        if (this.fPixelConverter == null) {
            this.fPixelConverter = new PixelConverter((Control)parent);
        }
        Composite settingsPane = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.verticalSpacing = (int)(1.5 * (double)this.fPixelConverter.convertVerticalDLUsToPixels(4));
        layout.horizontalSpacing = this.fPixelConverter.convertHorizontalDLUsToPixels(4);
        layout.marginHeight = 0;
        layout.marginWidth = this.fPixelConverter.convertHorizontalDLUsToPixels(7);
        settingsPane.setLayout((Layout)layout);
        settingsPane.setLayoutData((Object)new GridData(1808));
        this.createPageBookAndTree(settingsPane);
        this.initializePage();
    }

    protected void createPageBookAndTree(Composite composite) {
        this.compilerComponent.createPageBookContents(2, composite);
        this.createTreePref();
    }

    protected void createTreePref() {
        this.compilerComponent.populatePreferenceMapData();
    }

    protected void initializePage() {
        this.compilerComponent.initialize();
    }

    protected static Label createLabel(int numColumns, Composite parent, String text) {
        return CompilerAndGeneratorControls.createLabel(numColumns, parent, text, 768);
    }

    protected static Label createLabel(int numColumns, Composite parent, String text, int gridDataStyle) {
        Label label = new Label(parent, 64);
        label.setFont(parent.getFont());
        label.setText(text);
        label.setLayoutData((Object)CompilerAndGeneratorControls.createGridData(numColumns, gridDataStyle, -1));
        return label;
    }

    protected GridLayout createGridLayout(int numColumns, boolean margins) {
        GridLayout layout = new GridLayout(numColumns, false);
        layout.verticalSpacing = this.fPixelConverter.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.fPixelConverter.convertHorizontalDLUsToPixels(4);
        if (margins) {
            layout.marginHeight = this.fPixelConverter.convertVerticalDLUsToPixels(7);
            layout.marginWidth = this.fPixelConverter.convertHorizontalDLUsToPixels(7);
        } else {
            layout.marginHeight = 0;
            layout.marginWidth = 0;
        }
        return layout;
    }

    protected static GridData createGridData(int numColumns, int style, int widthHint) {
        GridData gd = new GridData(style);
        gd.horizontalSpan = numColumns;
        gd.widthHint = widthHint;
        return gd;
    }

    protected boolean isSelectedGenerator(String genName) {
        return this.parentPage.getSelectedGenerators().contains(genName);
    }

    protected List<org.eclipse.edt.compiler.IGenerator> getChildren(org.eclipse.edt.compiler.IGenerator generator) {
        IGenerator[] availableGens;
        ArrayList<org.eclipse.edt.compiler.IGenerator> children = new ArrayList<org.eclipse.edt.compiler.IGenerator>();
        IGenerator[] iGeneratorArray = availableGens = EDTCoreIDEPlugin.getPlugin().getGenerators();
        int n = availableGens.length;
        int n2 = 0;
        while (n2 < n) {
            IGenerator availableGen = iGeneratorArray[n2];
            if (availableGen.getParentGeneratorId() != null && availableGen.getParentGeneratorId().equalsIgnoreCase(generator.getId())) {
                children.add((org.eclipse.edt.compiler.IGenerator)availableGen);
            }
            ++n2;
        }
        return children;
    }

    protected CompilerComponent getCompilerComponent() {
        return this.compilerComponent;
    }

    protected class ComboPreference {
        private Label fLabel;
        private Combo fCombo;

        public ComboPreference(Composite composite, int numColumns, String labelText, String[] displayItems) {
            if (displayItems == null || labelText == null) {
                throw new IllegalArgumentException(NewWizardMessages.ArgsNotAssigned);
            }
            this.fLabel = CompilerAndGeneratorControls.createLabel(numColumns, composite, labelText);
            this.fCombo = new Combo(composite, 12);
            this.fCombo.setFont(composite.getFont());
            this.fCombo.setItems(displayItems);
            this.fCombo.setLayoutData((Object)CompilerAndGeneratorControls.createGridData(1, 256, this.fCombo.computeSize((int)-1, (int)-1).x));
            this.updateWidget();
        }

        protected void updateWidget() {
            int selIndex = this.fCombo.indexOf(CompilerAndGeneratorControls.this.parentPage.getSelectedCompiler());
            if (selIndex < 0) {
                selIndex = 0;
            }
            this.fCombo.select(selIndex);
        }

        public Control getControl() {
            return this.fCombo;
        }

        public Label getLabel() {
            return this.fLabel;
        }
    }

    protected class CompilerComponent
    extends SelectionAdapter {
        private Combo fCompilerCombo;
        private PageBook fPageBook;
        private List<WSOptionNodeComponent> compilerNodeComponents = new ArrayList<WSOptionNodeComponent>();
        protected Map<org.eclipse.edt.compiler.IGenerator, List<org.eclipse.edt.compiler.IGenerator>> genMap = new HashMap<org.eclipse.edt.compiler.IGenerator, List<org.eclipse.edt.compiler.IGenerator>>();

        public CompilerComponent() {
            IIDECompiler[] compilers;
            IIDECompiler[] iIDECompilerArray = compilers = CompilerAndGeneratorControls.this.getCompilersToDisplay();
            int n = compilers.length;
            int n2 = 0;
            while (n2 < n) {
                IIDECompiler compiler = iIDECompilerArray[n2];
                WSOptionNodeComponent node = new WSOptionNodeComponent(compiler);
                this.compilerNodeComponents.add(node);
                ++n2;
            }
        }

        public void widgetSelected(SelectionEvent e) {
            int index = this.fCompilerCombo.getSelectionIndex();
            String compilerName = this.fCompilerCombo.getItem(index);
            if (!compilerName.equalsIgnoreCase(CompilerAndGeneratorControls.this.parentPage.getSelectedCompiler())) {
                Control control;
                CompilerAndGeneratorControls.this.parentPage.updateGeneratorControlEnablement(true);
                CompilerAndGeneratorControls.this.parentPage.setSelectedCompiler(compilerName);
                if (CompilerAndGeneratorControls.this.parentPage.getResource() instanceof IProject && (control = this.compilerNodeComponents.get(index).getControl()) != null) {
                    this.compilerNodeComponents.get(index).refreshState();
                    this.fPageBook.showPage(control);
                    CompilerAndGeneratorControls.this.parentPage.removeCurrentCompilerTabs();
                    CompilerAndGeneratorControls.this.parentPage.addCompilerTabs(compilerName);
                }
                CompilerAndGeneratorControls.this.parentPage.setGeneratorOverrideCheckboxState(false);
            }
        }

        public void createPageBookContents(int numColumns, Composite parent) {
            if (CompilerAndGeneratorControls.this.parentPage.getResource() == null) {
                CompilerAndGeneratorControls.createLabel(1, parent, UINlsStrings.CompilerPreferencePage_defaultGeneratorsLabel);
            } else {
                CompilerAndGeneratorControls.createLabel(1, parent, UINlsStrings.CompilerPreferencePage_selectedGeneratorsLabel);
            }
            this.fPageBook = new PageBook(parent, 0);
            this.fPageBook.setLayoutData((Object)CompilerAndGeneratorControls.createGridData(numColumns, 1808, -1));
            for (WSOptionNodeComponent node : this.compilerNodeComponents) {
                node.createContents(numColumns, (Composite)this.fPageBook);
            }
        }

        public void initialize() {
            if (CompilerAndGeneratorControls.this.parentPage.getResource() == null) {
                this.showCompilerPreferencePageBookPage();
            } else {
                this.showCompilerPropertyPageBookPage(CompilerAndGeneratorControls.this.parentPage.getSelectedCompiler());
            }
            for (WSOptionNodeComponent node : this.compilerNodeComponents) {
                node.initialize();
            }
        }

        public void showCompilerPreferencePageBookPage() {
            String id = CompilerAndGeneratorControls.this.parentPage.getPreferencePageCompilerId();
            for (WSOptionNodeComponent node : this.compilerNodeComponents) {
                if (!node.fCompiler.getId().equalsIgnoreCase(id)) continue;
                node.refreshState();
                this.fPageBook.showPage(node.getControl());
            }
        }

        protected void showCompilerPropertyPageBookPage(String compilerName) {
            int selectWSPos = this.fCompilerCombo.indexOf(compilerName);
            this.fCompilerCombo.select(selectWSPos);
            this.compilerNodeComponents.get(selectWSPos).refreshState();
            this.fPageBook.showPage(this.compilerNodeComponents.get(selectWSPos).getControl());
        }

        protected void selectCompiler(String compilerName) {
            int selectWSPos = this.fCompilerCombo.indexOf(compilerName);
            this.fCompilerCombo.select(selectWSPos);
        }

        public void populatePreferenceMapData() {
            for (WSOptionNodeComponent node : this.compilerNodeComponents) {
                this.createParentGeneratorMap(node);
                node.populatePreferenceMapData(this.genMap);
                this.genMap.clear();
            }
        }

        private void createParentGeneratorMap(WSOptionNodeComponent node) {
            List availableGens = node.fCompiler.getGenerators();
            for (org.eclipse.edt.compiler.IGenerator gen : availableGens) {
                if (gen.getParentGeneratorId() != null && gen.getParentGeneratorId().length() != 0 || gen.getEnabledWith() != null && gen.getEnabledWith().length() != 0) continue;
                this.addGeneratorToMap(gen);
            }
        }

        private void addGeneratorToMap(org.eclipse.edt.compiler.IGenerator gen) {
            List<org.eclipse.edt.compiler.IGenerator> children = CompilerAndGeneratorControls.this.getChildren(gen);
            this.genMap.put(gen, children);
            for (org.eclipse.edt.compiler.IGenerator child : children) {
                if (CompilerAndGeneratorControls.this.getChildren(child).size() <= 0) continue;
                this.addGeneratorToMap(child);
            }
        }

        protected IIDECompiler getCompilerFromName(String name) {
            if (name != null && name.length() > 0) {
                IIDECompiler[] compilers;
                IIDECompiler[] iIDECompilerArray = compilers = EDTCoreIDEPlugin.getPlugin().getCompilers();
                int n = compilers.length;
                int n2 = 0;
                while (n2 < n) {
                    IIDECompiler currentCompiler = iIDECompilerArray[n2];
                    if (currentCompiler.getName().equalsIgnoreCase(name)) {
                        return currentCompiler;
                    }
                    ++n2;
                }
            }
            return null;
        }

        protected List<WSOptionNodeComponent> getCompilerNodeComponents() {
            return this.compilerNodeComponents;
        }
    }

    protected static class OptionTreeContentProvider
    implements ITreeContentProvider {
        protected OptionTreeContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            ArrayList<OptionTreeNode> children = new ArrayList<OptionTreeNode>();
            if (parentElement instanceof Collection) {
                children.addAll((Collection)parentElement);
            } else if (parentElement instanceof OptionTreeNode) {
                OptionTreeNode wsnode = (OptionTreeNode)parentElement;
                children.addAll(wsnode.getChildren().values());
            }
            return children.toArray();
        }

        public Object getParent(Object element) {
            return ((OptionTreeNode)element).getParent();
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    protected static class OptionTreeLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        protected OptionTreeLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return ((OptionTreeNode)element).getDisplay();
                }
                case 1: {
                    return ((OptionTreeNode)element).getLanguage();
                }
                case 2: {
                    return ((OptionTreeNode)element).getVersion();
                }
                case 3: {
                    return ((OptionTreeNode)element).getProvider();
                }
            }
            return "";
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }

    protected static class OptionTreeNode {
        private String fDisplay;
        private String fVersion;
        private String fProvider;
        private String fLanguage;
        private SortedMap<String, OptionTreeNode> fChildren = new TreeMap<String, OptionTreeNode>();
        private OptionTreeNode fParent;

        public OptionTreeNode(String display, OptionTreeNode parent, String version, String provider, String language) {
            this.fDisplay = display;
            this.fParent = parent;
            this.fVersion = version;
            this.fProvider = provider;
            this.fLanguage = language;
        }

        public String getDisplay() {
            return this.fDisplay;
        }

        public OptionTreeNode getParent() {
            return this.fParent;
        }

        public String getVersion() {
            return this.fVersion;
        }

        public String getProvider() {
            return this.fProvider;
        }

        public String getLanguage() {
            return this.fLanguage;
        }

        public Map<String, OptionTreeNode> getChildren() {
            return this.fChildren;
        }

        public boolean hasChildren() {
            return !this.fChildren.isEmpty();
        }

        public OptionTreeNode addChild(String display, String version, String provider, String language) {
            OptionTreeNode addedChild = null;
            Object obj = this.fChildren.get(display);
            if (obj == null) {
                OptionTreeNode newWSNode = new OptionTreeNode(display, this, version, provider, language);
                this.fChildren.put(display, newWSNode);
                addedChild = newWSNode;
            } else if (obj instanceof OptionTreeNode) {
                addedChild = (OptionTreeNode)obj;
            }
            return addedChild;
        }
    }

    protected abstract class TreeControlPreference {
        protected TreeViewer fTreeViewer;
        protected IIDECompiler fCompiler;
        protected SortedMap<String, OptionTreeNode> fOptionNodePreferenceTreeMap;

        protected TreeControlPreference(IIDECompiler compiler) {
            this.fCompiler = compiler;
            this.fOptionNodePreferenceTreeMap = new TreeMap<String, OptionTreeNode>();
        }

        protected abstract TreeViewer createTreeViewer(Composite var1, int var2);

        public void initialize() {
            this.fTreeViewer.setInput(this.fOptionNodePreferenceTreeMap.values());
            this.fTreeViewer.expandAll();
        }

        protected void createContents(int numColumns, Composite parent) {
            this.fTreeViewer = this.createTreeViewer(parent, numColumns);
            this.fTreeViewer.setContentProvider((IContentProvider)new OptionTreeContentProvider());
            this.fTreeViewer.setLabelProvider((IBaseLabelProvider)new OptionTreeLabelProvider());
            this.fTreeViewer.getControl().setLayoutData((Object)CompilerAndGeneratorControls.createGridData(numColumns, 1808, -1));
            Tree tree = this.fTreeViewer.getTree();
            tree.setHeaderVisible(true);
            tree.setLinesVisible(true);
            TreeColumn nameColumn = new TreeColumn(tree, 16384);
            TreeColumn languageColumn = new TreeColumn(tree, 16384);
            TreeColumn versionColumn = new TreeColumn(tree, 16384);
            TreeColumn providerColumn = new TreeColumn(tree, 16384);
            nameColumn.setWidth(200);
            nameColumn.setText(UINlsStrings.CompilerPreferencePage_nameLabel);
            languageColumn.setWidth(150);
            languageColumn.setText(UINlsStrings.CompilerPreferencePage_languageLabel);
            versionColumn.setWidth(100);
            versionColumn.setText(UINlsStrings.CompilerPreferencePage_versionLabel);
            providerColumn.setWidth(200);
            providerColumn.setText(UINlsStrings.CompilerPreferencePage_ProviderLabel);
        }

        protected void populatePreferenceMapData(Map<org.eclipse.edt.compiler.IGenerator, List<org.eclipse.edt.compiler.IGenerator>> genMap) {
            for (org.eclipse.edt.compiler.IGenerator genMapKey : genMap.keySet()) {
                if (genMapKey.getParentGeneratorId() != null && genMapKey.getParentGeneratorId().length() != 0) continue;
                List<org.eclipse.edt.compiler.IGenerator> genList = genMap.get(genMapKey);
                Object obj = this.fOptionNodePreferenceTreeMap.get(genMapKey.getName());
                OptionTreeNode wsnode = null;
                if (obj == null) {
                    wsnode = new OptionTreeNode(genMapKey.getName(), null, genMapKey.getVersion(), genMapKey.getProvider(), genMapKey.getLanguage());
                    this.fOptionNodePreferenceTreeMap.put(genMapKey.getName(), wsnode);
                } else {
                    wsnode = (OptionTreeNode)obj;
                }
                int i = 0;
                while (i < genList.size()) {
                    this.processChild(genMap, wsnode, genList.get(i));
                    ++i;
                }
            }
        }

        protected void processChild(Map<org.eclipse.edt.compiler.IGenerator, List<org.eclipse.edt.compiler.IGenerator>> genMap, OptionTreeNode wsnode, org.eclipse.edt.compiler.IGenerator child) {
            if (genMap.keySet().contains(child)) {
                wsnode = wsnode.addChild(child.getName(), child.getVersion(), child.getProvider(), child.getLanguage());
                List<org.eclipse.edt.compiler.IGenerator> genList = genMap.get(child);
                int i = 0;
                while (i < genList.size()) {
                    this.processChild(genMap, wsnode, genList.get(i));
                    ++i;
                }
            } else {
                wsnode.addChild(child.getName(), child.getVersion(), child.getProvider(), child.getLanguage());
            }
        }
    }

    protected class WSOptionNodeComponent
    extends TreeControlPreference
    implements ICheckStateListener {
        private Composite fComposite;

        public WSOptionNodeComponent(IIDECompiler compiler) {
            super(compiler);
        }

        @Override
        public void createContents(int numColumns, Composite parent) {
            this.fComposite = new Composite(parent, 0);
            this.fComposite.setLayoutData((Object)CompilerAndGeneratorControls.createGridData(numColumns, 256, -1));
            this.fComposite.setLayout((Layout)CompilerAndGeneratorControls.this.createGridLayout(numColumns, false));
            super.createContents(numColumns, this.fComposite);
        }

        @Override
        protected TreeViewer createTreeViewer(Composite composite, int numColumns) {
            return new CheckboxTreeViewer(this.fComposite, 2564);
        }

        @Override
        public void initialize() {
            ((CheckboxTreeViewer)this.fTreeViewer).addCheckStateListener((ICheckStateListener)this);
            super.initialize();
            this.refreshState();
        }

        public void refreshState() {
            CheckboxTreeViewer checkedTreeViewer = (CheckboxTreeViewer)this.fTreeViewer;
            if (checkedTreeViewer != null) {
                List<OptionTreeNode> checked = this.getCheckElements(this.fOptionNodePreferenceTreeMap);
                checkedTreeViewer.setCheckedElements(checked.toArray());
            }
        }

        private List<OptionTreeNode> getCheckElements(Map<String, OptionTreeNode> map) {
            ArrayList<OptionTreeNode> checked = new ArrayList<OptionTreeNode>(100);
            Iterator<OptionTreeNode> it = map.values().iterator();
            while (it.hasNext()) {
                OptionTreeNode val;
                OptionTreeNode wsnode = val = it.next();
                checked.addAll(this.getCheckElements(wsnode.getChildren()));
                if (!CompilerAndGeneratorControls.this.isSelectedGenerator(wsnode.getDisplay())) continue;
                checked.add(wsnode);
            }
            return checked;
        }

        public void checkStateChanged(CheckStateChangedEvent event) {
            Object obj = event.getElement();
            String currValue = Boolean.toString(event.getChecked());
            this.changeCheckState(obj, currValue);
        }

        private void changeCheckState(Object obj, String currStateValue) {
            if (obj instanceof OptionTreeNode) {
                OptionTreeNode wsnode = (OptionTreeNode)obj;
                if (currStateValue.equalsIgnoreCase("true")) {
                    if (CompilerAndGeneratorControls.this.parentPage.getResource() == null) {
                        org.eclipse.edt.compiler.IGenerator gen = CompilerAndGeneratorControls.this.parentPage.getGeneratorFromId(CompilerAndGeneratorControls.this.parentPage.convertGeneratorNameToId(wsnode.getDisplay()));
                        if (gen.getCompiler().getId().equalsIgnoreCase(CompilerAndGeneratorControls.this.parentPage.getPreferencePageCompilerId())) {
                            CompilerAndGeneratorControls.this.parentPage.addSelectedGenerator(wsnode.getDisplay());
                            CompilerAndGeneratorControls.this.parentPage.addGeneratorTab(wsnode.getDisplay());
                        }
                    } else {
                        CompilerAndGeneratorControls.this.parentPage.addSelectedGenerator(wsnode.getDisplay());
                        CompilerAndGeneratorControls.this.parentPage.addGeneratorTab(wsnode.getDisplay());
                    }
                } else {
                    CompilerAndGeneratorControls.this.parentPage.removeSelectedGenerator(wsnode.getDisplay());
                    CompilerAndGeneratorControls.this.parentPage.removeGeneratorTab(wsnode.getDisplay());
                }
            }
        }

        public Control getControl() {
            return this.fComposite;
        }
    }
}

