/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.wizards;

import java.util.ArrayList;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.edt.ide.core.internal.search.PartDeclarationInfo;
import org.eclipse.edt.ide.ui.internal.IUIHelpConstants;
import org.eclipse.edt.ide.ui.internal.PluginImages;
import org.eclipse.edt.ide.ui.internal.dialogs.StatusInfo;
import org.eclipse.edt.ide.ui.internal.util.PatternConstructor;
import org.eclipse.edt.ide.ui.internal.util.SWTUtil;
import org.eclipse.edt.ide.ui.internal.wizards.EGLElementWizardPage;
import org.eclipse.edt.ide.ui.internal.wizards.NewWizardMessages;
import org.eclipse.edt.ide.ui.internal.wizards.WebServicesWizard;
import org.eclipse.edt.ide.ui.wizards.WebServicesConfiguration;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class WebServicesWizardPage
extends EGLElementWizardPage {
    public static final String WIZPAGENAME_WebServicesWizardPage = "WIZPAGENAME_WebServicesWizardPage";
    private int nColumns = 3;
    private Text fFilterText;
    private TableViewer fAvailableListViewer;
    private Label fCountLabel;
    private TableViewer fWSListViewer;
    private StatusInfo fWSGenTypeStatus;

    public WebServicesWizardPage(String pageName) {
        super(pageName);
        this.setTitle(NewWizardMessages.WebServicesWizPageTitle);
        this.setDescription(NewWizardMessages.WebServicesWizPageDescription);
        this.fWSGenTypeStatus = new StatusInfo();
    }

    protected void validatePage() {
        this.fWSGenTypeStatus.setOK();
        if (!this.getConfiguration().isGenAsSOAP() && !this.getConfiguration().isGenAsRest()) {
            this.fWSGenTypeStatus.setError(NewWizardMessages.errMustSelectOneTypeWS2Gen);
        } else if (this.fWSListViewer.getTable().getItemCount() < 1) {
            this.fWSGenTypeStatus.setError(NewWizardMessages.errMustSelectOneTypeWS2Gen);
        }
        this.updateStatus(new IStatus[]{this.fWSGenTypeStatus});
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = this.createCompositeControl(parent);
        this.createFilterControl(composite);
        this.createWebServicesTypeControl(composite);
        this.createAvailableListControl(composite).setLayoutData((Object)new GridData(1808));
        this.createButtonArea(composite);
        this.createGenerateList(composite);
        this.updateCount();
        this.addViewerListeners();
        this.setControl((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, IUIHelpConstants.EGLDDWIZ_ADDWS);
        this.validatePage();
        Dialog.applyDialogFont((Control)parent);
    }

    private void addViewerListeners() {
        this.fAvailableListViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                WebServicesWizardPage.this.handleAdd();
            }
        });
        this.fWSListViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                WebServicesWizardPage.this.handleRemove();
            }
        });
    }

    private WebServicesConfiguration getConfiguration() {
        return (WebServicesConfiguration)((WebServicesWizard)this.getWizard()).getConfiguration(this.getName());
    }

    private Composite createGenerateList(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(1808));
        Label label = new Label(container, 0);
        label.setText(NewWizardMessages.EGLServicePartsListLabel);
        Table table = new Table(container, 2562);
        GridData gd = new GridData(1808);
        gd.widthHint = 225;
        table.setLayoutData((Object)gd);
        this.fWSListViewer = new TableViewer(table);
        this.fWSListViewer.setContentProvider((IContentProvider)new WebServicesContentProvider());
        this.fWSListViewer.setLabelProvider((IBaseLabelProvider)new WebServicesLabelProvider());
        this.fWSListViewer.setInput((Object)"");
        this.fWSListViewer.setSorter(new ViewerSorter());
        return container;
    }

    private Composite createButtonArea(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        comp.setLayout((Layout)layout);
        comp.setLayoutData((Object)new GridData(1040));
        Composite container = new Composite(comp, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        container.setLayout((Layout)layout);
        GridData gd = new GridData(1040);
        gd.verticalIndent = 15;
        container.setLayoutData((Object)gd);
        Button button = new Button(container, 8);
        button.setText(NewWizardMessages.AddWSLabel);
        button.setLayoutData((Object)new GridData(768));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WebServicesWizardPage.this.handleAdd();
            }
        });
        SWTUtil.setButtonDimensionHint(button);
        button = new Button(container, 8);
        button.setText(NewWizardMessages.AddAllWSLabel);
        button.setLayoutData((Object)new GridData(768));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WebServicesWizardPage.this.handleAddAll();
            }
        });
        SWTUtil.setButtonDimensionHint(button);
        button = new Button(container, 8);
        button.setText(NewWizardMessages.RemoveWSLabel);
        button.setLayoutData((Object)new GridData(768));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WebServicesWizardPage.this.handleRemove();
            }
        });
        SWTUtil.setButtonDimensionHint(button);
        button = new Button(container, 8);
        button.setText(NewWizardMessages.RemoveAllWSLabel);
        button.setLayoutData((Object)new GridData(768));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WebServicesWizardPage.this.handleRemoveAll();
            }
        });
        SWTUtil.setButtonDimensionHint(button);
        this.fCountLabel = new Label(comp, 0);
        this.fCountLabel.setLayoutData((Object)new GridData(64));
        return container;
    }

    protected void handleRemoveAll() {
        this.getConfiguration().moveAllServicesNot2BeWS();
        this.updateControls();
    }

    protected void handleRemove() {
        IStructuredSelection ssel = (IStructuredSelection)this.fWSListViewer.getSelection();
        if (ssel.size() > 0) {
            this.getConfiguration().moveServicesNot2BeWS(ssel.toList());
            this.updateControls();
        }
    }

    protected void handleAddAll() {
        this.getConfiguration().moveAllServices2BeWS();
        this.updateControls();
    }

    protected void handleAdd() {
        IStructuredSelection ssel = (IStructuredSelection)this.fAvailableListViewer.getSelection();
        if (ssel.size() > 0) {
            this.getConfiguration().moveServices2BeWS(ssel.toList());
            this.updateControls();
        }
    }

    private void updateControls() {
        this.fAvailableListViewer.refresh();
        this.fWSListViewer.refresh();
        this.updateCount();
        this.validatePage();
    }

    private Composite createAvailableListControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData());
        Label label = new Label(container, 0);
        label.setText(NewWizardMessages.EGLServicePartsFoundLabel);
        Table table = new Table(container, 2562);
        GridData gd = new GridData(1808);
        gd.widthHint = 225;
        table.setLayoutData((Object)gd);
        this.fAvailableListViewer = new TableViewer(table);
        this.fAvailableListViewer.setContentProvider((IContentProvider)new WebServicesAvailableContentProvider());
        this.fAvailableListViewer.setLabelProvider((IBaseLabelProvider)new WebServicesLabelProvider());
        this.fAvailableListViewer.setInput((Object)"");
        this.fAvailableListViewer.setSorter(new ViewerSorter());
        return container;
    }

    protected Composite createCompositeControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, IUIHelpConstants.EGL_EXTERNALSERVICE);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = this.nColumns;
        composite.setLayout((Layout)layout);
        return composite;
    }

    private void createFilterControl(Composite parent) {
        Group grp = new Group(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 6;
        layout.marginWidth = 6;
        grp.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 3;
        grp.setLayoutData((Object)gd);
        grp.setText(NewWizardMessages.LocateEGLServicePartGrpLabel);
        Label filterLabel = new Label((Composite)grp, 0);
        filterLabel.setText(NewWizardMessages.FilterLabel);
        this.fFilterText = new Text((Composite)grp, 2048);
        this.fFilterText.setText("");
        gd = new GridData(768);
        this.fFilterText.setLayoutData((Object)gd);
        this.fFilterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WebServicesWizardPage.this.handleFilter();
            }
        });
    }

    private void createWebServicesTypeControl(Composite parent) {
        Group grp = new Group(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 6;
        layout.marginWidth = 6;
        grp.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 3;
        grp.setLayoutData((Object)gd);
        grp.setText(NewWizardMessages.WSGenAs);
        final Button btnRest = new Button((Composite)grp, 32);
        btnRest.setText(NewWizardMessages.RestService);
        btnRest.setSelection(this.getConfiguration().isGenAsRest());
        btnRest.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WebServicesWizardPage.this.getConfiguration().setGenAsRest(btnRest.getSelection());
                WebServicesWizardPage.this.validatePage();
            }
        });
        btnRest.setEnabled(false);
    }

    protected void handleFilter() {
        if (this.fFilterText == null || this.fFilterText.getText().trim().length() == 0) {
            return;
        }
        String text = this.fFilterText.getText().trim();
        if (!text.endsWith("*")) {
            text = String.valueOf(text) + "*";
        }
        Pattern pattern = PatternConstructor.createPattern(text, true);
        TableItem[] tableItems = this.fAvailableListViewer.getTable().getItems();
        ArrayList<TableItem> results = new ArrayList<TableItem>();
        int i = 0;
        while (i < tableItems.length) {
            Object data = tableItems[i].getData();
            if (data instanceof PartDeclarationInfo) {
                PartDeclarationInfo partInfo = (PartDeclarationInfo)data;
                String dispalyText = ((LabelProvider)this.fAvailableListViewer.getLabelProvider()).getText((Object)partInfo);
                if (pattern.matcher(dispalyText).matches()) {
                    results.add(tableItems[i]);
                }
            }
            ++i;
        }
        if (results.size() > 0) {
            TableItem[] selectionList = results.toArray(new TableItem[results.size()]);
            this.fAvailableListViewer.getTable().setSelection(selectionList);
        } else {
            this.fAvailableListViewer.setSelection(null);
        }
    }

    private void updateCount() {
        this.fCountLabel.setText(NewWizardMessages.bind((String)NewWizardMessages.EGLServicePartCount, (Object[])new String[]{new Integer(this.fWSListViewer.getTable().getItemCount()).toString(), new Integer(this.getConfiguration().getInitialAvailableServicesCount()).toString()}));
        this.fCountLabel.getParent().layout();
    }

    private class WebServicesAvailableContentProvider
    implements IStructuredContentProvider {
        private WebServicesAvailableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return WebServicesWizardPage.this.getConfiguration().getServicesNeed2BeWS().toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class WebServicesContentProvider
    implements IStructuredContentProvider {
        private WebServicesContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return WebServicesWizardPage.this.getConfiguration().getSelectedServices2BeWS().toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class WebServicesLabelProvider
    extends LabelProvider {
        private WebServicesLabelProvider() {
        }

        public Image getImage(Object element) {
            PartDeclarationInfo partinfo;
            if (element instanceof PartDeclarationInfo && ((partinfo = (PartDeclarationInfo)element).getPartType() & 0x2000) != 0) {
                return PluginImages.get("org.eclipse.edt.ide.ui.exttyp_obj.gif");
            }
            return PluginImages.get("org.eclipse.edt.ide.ui.svc_obj.gif");
        }

        public String getText(Object element) {
            String text = "";
            if (element instanceof PartDeclarationInfo) {
                PartDeclarationInfo partinfo = (PartDeclarationInfo)element;
                text = partinfo.getFullyQualifiedName();
                text = String.valueOf(text) + " (";
                text = String.valueOf(text) + partinfo.getProject();
                text = String.valueOf(text) + ")";
            }
            return text;
        }
    }
}

