/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.wizards;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.ui.internal.IUIHelpConstants;
import org.eclipse.edt.ide.ui.internal.dialogs.InterfaceSelectionDialog;
import org.eclipse.edt.ide.ui.internal.dialogs.StatusInfo;
import org.eclipse.edt.ide.ui.internal.wizards.InterfaceSelectionListWizardPage;
import org.eclipse.edt.ide.ui.internal.wizards.InterfaceWizard;
import org.eclipse.edt.ide.ui.internal.wizards.NewWizardMessages;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.DialogField;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.LayoutUtil;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.StringDialogField;
import org.eclipse.edt.ide.ui.wizards.InterfaceConfiguration;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class InterfaceWizardPage
extends InterfaceSelectionListWizardPage {
    private int nColumns = 5;
    private StringDialogField fInterfaceDialogField;
    private InterfaceFieldAdapter adapter = new InterfaceFieldAdapter();
    private StatusInfo fInterfaceStatus;

    protected InterfaceWizardPage(String pageName) {
        super(pageName);
        this.setTitle(NewWizardMessages.NewEGLInterfaceWizardPageTitle);
        this.setDescription(NewWizardMessages.NewEGLInterfaceWizardPageDescription);
        this.fInterfaceStatus = new StatusInfo();
        this.initSuperInterfacesControl(this.adapter);
    }

    private InterfaceConfiguration getConfiguration() {
        return (InterfaceConfiguration)((InterfaceWizard)this.getWizard()).getConfiguration();
    }

    @Override
    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, IUIHelpConstants.EGL_INTERFACE_DEFINITION);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = this.nColumns;
        composite.setLayout((Layout)layout);
        this.createContainerControls(composite, this.nColumns);
        this.createPackageControls(composite);
        this.createSeparator(composite, this.nColumns);
        this.createEGLFileControls(composite);
        this.createInterfaceControls(composite);
        this.modifyFileListeners();
        this.setControl((Control)composite);
        this.validatePage();
        Dialog.applyDialogFont((Control)parent);
    }

    private void createInterfaceControls(Composite parent) {
        this.fInterfaceDialogField = new StringDialogField();
        this.fInterfaceDialogField.setDialogFieldListener(this.adapter);
        this.fInterfaceDialogField.setLabelText(NewWizardMessages.NewEGLInterfaceWizardPagePartlabel);
        this.fInterfaceDialogField.setText(this.getConfiguration().getInterfaceName());
        this.fInterfaceDialogField.setEnabled(false);
        this.fInterfaceDialogField.doFillIntoGrid(parent, this.nColumns - 1);
        DialogField.createEmptySpace(parent);
        LayoutUtil.setWidthHint((Control)this.fInterfaceDialogField.getTextControl(null), this.getMaxFieldWidth());
        LayoutUtil.setHorizontalGrabbing((Control)this.fInterfaceDialogField.getTextControl(null));
    }

    @Override
    protected InterfaceSelectionDialog getInterfaceSelectionDialog(IEGLProject project) {
        String interfaceSubType = null;
        if (this.getConfiguration().getInterfaceType() == 0) {
            interfaceSubType = "BasicInterface";
        } else if (this.getConfiguration().getInterfaceType() == 1) {
            interfaceSubType = "JavaObject";
        }
        InterfaceSelectionDialog dialog = new InterfaceSelectionDialog(this.getShell(), (IRunnableContext)this.getWizard().getContainer(), this.fSuperInterfacesDialogField, 2048, interfaceSubType, this.getConfiguration(), project);
        dialog.setTitle(NewWizardMessages.NewTypeWizardPageInterfacesDialogInterfaceTitle);
        return dialog;
    }

    private void modifyFileListeners() {
        this.fEGLFileDialogField.getTextControl(null).addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InterfaceWizardPage.this.fInterfaceDialogField.setText(InterfaceWizardPage.this.fEGLFileDialogField.getText());
            }
        });
    }

    private void handleInterfaceDialogFieldChanged() {
        this.getConfiguration().setInterfaceName(this.fInterfaceDialogField.getText());
        this.validatePage();
    }

    @Override
    protected boolean validatePage() {
        if (super.validatePage()) {
            this.fInterfaceStatus.setOK();
            String partName = this.getConfiguration().getInterfaceName();
            if (partName.length() == 0) {
                this.fInterfaceStatus.setError(NewWizardMessages.NewTypeWizardPageErrorEnterPartName);
            } else if (partName.indexOf(46) != -1) {
                this.fInterfaceStatus.setError(NewWizardMessages.NewTypeWizardPageErrorQualifiedName);
            } else {
                this.validateEGLName(partName, 22, this.fInterfaceStatus);
            }
            this.updateStatus(new IStatus[]{this.fInterfaceStatus});
            return this.fInterfaceStatus.getSeverity() != 4;
        }
        return false;
    }

    private class InterfaceFieldAdapter
    extends InterfaceSelectionListWizardPage.InterfaceListFieldAdapter
    implements IStringButtonAdapter,
    IDialogFieldListener {
        private InterfaceFieldAdapter() {
        }

        @Override
        public void changeControlPressed(DialogField field) {
        }

        @Override
        public void dialogFieldChanged(DialogField field) {
            InterfaceWizardPage.this.handleInterfaceDialogFieldChanged();
        }
    }
}

