/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.record.conversion.xml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.edt.ide.ui.internal.record.conversion.IMessageHandler;
import org.eclipse.edt.ide.ui.internal.record.conversion.PartsUtil;
import org.eclipse.edt.ide.ui.templates.parts.Annotation;
import org.eclipse.edt.ide.ui.templates.parts.ArrayType;
import org.eclipse.edt.ide.ui.templates.parts.Field;
import org.eclipse.edt.ide.ui.templates.parts.Part;
import org.eclipse.edt.ide.ui.templates.parts.Record;
import org.eclipse.edt.ide.ui.templates.parts.RecordType;
import org.eclipse.edt.ide.ui.templates.parts.SimpleType;
import org.eclipse.edt.ide.ui.templates.parts.Type;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PartsFromXMLUtil
extends PartsUtil {
    static Map<String, String> reservedXSINames = new HashMap<String, String>();

    static {
        reservedXSINames.put("type", "type");
        reservedXSINames.put("nil", "nil");
        reservedXSINames.put("schemaLocation", "schemaLocation");
        reservedXSINames.put("noNamespaceSchemaLocation", "noNamespaceSchemaLocation");
    }

    public PartsFromXMLUtil(IMessageHandler msgHandler) {
        super(msgHandler);
    }

    @Override
    public Part[] process(Object node, Record wrapRec) {
        XMLNode xmlNode = new XMLNode((Node)node);
        String xmlName = this.getTypeName(xmlNode.getQName().getLocalPart());
        wrapRec.setName(xmlName);
        if (!xmlName.equals(xmlNode.getQName().getLocalPart()) || xmlNode.getQName().getNamespaceURI() != null && xmlNode.getQName().getNamespaceURI().length() > 0 || xmlNode.isNillable()) {
            Annotation annotation = new Annotation();
            annotation.setName("XMLRootElement");
            annotation.addField("name", "\"" + xmlNode.getQName().getLocalPart() + "\"");
            if (xmlNode.getQName().getNamespaceURI() != null && xmlNode.getQName().getNamespaceURI().length() > 0) {
                annotation.addField("namespace", "\"" + xmlNode.getQName().getNamespaceURI() + "\"");
            }
            if (xmlNode.isNillable()) {
                annotation.addField("nillable", "true");
            }
            wrapRec.addAnnotation(annotation);
        }
        LinkedHashMap<String, Record> map = new LinkedHashMap<String, Record>();
        map.put(wrapRec.getName().toUpperCase().toLowerCase(), wrapRec);
        Part[] parts = this.process(xmlNode, wrapRec, map);
        if (parts != null && parts.length == 1) {
            Field[] fields;
            boolean hasChildElement = false;
            Field[] fieldArray = fields = wrapRec.getFields();
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                String annoName = null;
                annoName = field.getAnnotationString();
                if (annoName == null) {
                    hasChildElement = true;
                } else if (!annoName.contains("XMLAttribute")) {
                    hasChildElement = true;
                }
                ++n2;
            }
            if (!hasChildElement) {
                String fieldName = "simValue";
                Field field = new Field();
                field.setName(fieldName);
                SimpleType type = new SimpleType();
                type.setName("string?");
                field.setType(type);
                wrapRec.addField(field);
            }
        }
        return parts;
    }

    public Part[] process(XMLNode node, Record wrapRec, LinkedHashMap<String, Record> recs) {
        HashMap<String, String> fieldNames = this.getFieldNames(node);
        this.processChildAttributes(node, wrapRec, recs, fieldNames);
        this.processChildElements(node, wrapRec, recs, fieldNames);
        return recs.values().toArray(new Part[recs.values().size()]);
    }

    private HashMap<String, String> getFieldNames(XMLNode node) {
        HashMap<String, String> fieldNames = new HashMap<String, String>();
        for (ArrayList<XMLNode> child : node.getChildAttributes()) {
            XMLNode xmlNode = child.get(0);
            String originalName = xmlNode.getQName().getLocalPart();
            fieldNames.put(originalName.toLowerCase(), originalName);
        }
        for (ArrayList<XMLNode> child : node.getChildElements()) {
            XMLNode xmlNode = child.get(0);
            String originalName = xmlNode.getQName().getLocalPart();
            fieldNames.put(originalName.toLowerCase(), originalName);
        }
        return fieldNames;
    }

    public void processChildAttributes(XMLNode node, Record wrapRec, LinkedHashMap<String, Record> recs, HashMap<String, String> fieldNames) {
        for (ArrayList<XMLNode> child : node.getChildAttributes()) {
            String fieldName;
            XMLNode xmlNode = child.get(0);
            String originalName = xmlNode.getQName().getLocalPart();
            String xmlName = originalName.equals(fieldName = this.getFieldName(originalName, wrapRec.getName(), fieldNames)) ? null : originalName;
            Field field = new Field();
            field.setName(fieldName);
            field.setType(this.getType(child, recs, fieldName));
            Annotation annotation = new Annotation();
            annotation.setName("XMLAttribute");
            if (xmlName != null) {
                annotation.addField("name", "\"" + xmlName + "\"");
            }
            if (xmlNode.getQName().getNamespaceURI() != null && xmlNode.getQName().getNamespaceURI().length() > 0) {
                annotation.addField("namespace", "\"" + xmlNode.getQName().getNamespaceURI() + "\"");
            }
            field.addAnnotation(annotation);
            wrapRec.addField(field);
        }
    }

    public void processChildElements(XMLNode node, Record wrapRec, LinkedHashMap<String, Record> recs, HashMap<String, String> fieldNames) {
        for (ArrayList<XMLNode> child : node.getChildElements()) {
            String fieldName;
            XMLNode xmlNode = child.get(0);
            String originalName = xmlNode.getQName().getLocalPart();
            String xmlName = originalName.equals(fieldName = this.getFieldName(originalName, wrapRec.getName(), fieldNames)) ? null : originalName;
            Field field = new Field();
            field.setName(fieldName);
            field.setType(this.getType(child, recs, originalName.equals(originalName.toUpperCase()) ? fieldName.toUpperCase() : fieldName));
            if (xmlName != null || xmlNode.getQName().getNamespaceURI() != null && xmlNode.getQName().getNamespaceURI().length() > 0 || xmlNode.isNillable()) {
                Annotation annotation = new Annotation();
                annotation.setName("XMLElement");
                if (xmlName != null) {
                    annotation.addField("name", "\"" + xmlName + "\"");
                }
                if (xmlNode.getQName().getNamespaceURI() != null && xmlNode.getQName().getNamespaceURI().length() > 0) {
                    annotation.addField("namespace", "\"" + xmlNode.getQName().getNamespaceURI() + "\"");
                }
                if (xmlNode.isNillable()) {
                    annotation.addField("nillable", "true");
                }
                field.addAnnotation(annotation);
            }
            wrapRec.addField(field);
        }
    }

    private Type getType(ArrayList<XMLNode> nodelist, LinkedHashMap<String, Record> recs, String fieldName) {
        Type[] type = new Type[1];
        if (nodelist.size() > 1) {
            type[0] = this.processArrayType(nodelist, recs, fieldName);
        } else if (nodelist.get(0).getChildElements().size() > 0) {
            type[0] = this.processRecordType(nodelist.get(0), recs, fieldName);
        } else if (nodelist.get(0).getChildAttributes().size() > 0) {
            type[0] = this.processSimpleRecordType(nodelist.get(0), recs, fieldName);
        } else {
            SimpleType t = new SimpleType();
            t.setName("string");
            type[0] = t;
        }
        return type[0];
    }

    private Type processArrayType(ArrayList<XMLNode> nodelist, LinkedHashMap<String, Record> recs, String fieldName) {
        ArrayType type = new ArrayType();
        Iterator<XMLNode> i = nodelist.iterator();
        while (i.hasNext()) {
            Record rec;
            String fn;
            String typeName;
            ArrayList<XMLNode> list = new ArrayList<XMLNode>();
            list.add(i.next());
            Type elementType = this.getType(list, recs, fieldName);
            if (type.getElementType() == null) {
                type.setElementType(elementType);
                continue;
            }
            if (elementType instanceof RecordType && type.getElementType() instanceof SimpleType) {
                typeName = elementType.getName();
                fn = typeName.toUpperCase().toLowerCase();
                rec = recs.get(fn);
                this.mergeRecords(new Record(), rec);
                type.setElementType(elementType);
                continue;
            }
            if (!(elementType instanceof SimpleType) || !(type.getElementType() instanceof RecordType)) continue;
            typeName = type.getElementType().getName();
            fn = typeName.toUpperCase().toLowerCase();
            rec = recs.get(fn);
            this.mergeRecords(new Record(), rec);
        }
        return type;
    }

    private Type processRecordType(XMLNode node, LinkedHashMap<String, Record> recs, String fieldName) {
        String typeName = this.getTypeName(fieldName);
        RecordType type = new RecordType();
        type.setName(typeName);
        String fn = typeName.toUpperCase().toLowerCase();
        Record oldrec = recs.get(fn);
        Record rec = new Record();
        rec.setName(typeName);
        recs.put(fn, rec);
        new PartsFromXMLUtil(this._msgHandler).process(node, rec, recs);
        if (oldrec != null) {
            this.mergeRecords(oldrec, rec);
        }
        return type;
    }

    private Type processSimpleRecordType(XMLNode node, LinkedHashMap<String, Record> recs, String fieldName) {
        String typeName = this.getTypeName(fieldName);
        RecordType type = new RecordType();
        type.setName(typeName);
        String fn = typeName.toUpperCase().toLowerCase();
        Record oldrec = recs.get(fn);
        Record rec = new Record();
        rec.setName(typeName);
        recs.put(fn, rec);
        Annotation annotation = new Annotation();
        annotation.setName("XMLValue");
        annotation.addField("kind", "XMLStructureKind.simpleContent");
        rec.addAnnotation(annotation);
        new PartsFromXMLUtil(this._msgHandler).process(node, rec, recs);
        Field field = new Field();
        field.setName("egl_value");
        SimpleType t = new SimpleType();
        t.setName("string");
        t.setNullable(true);
        field.setType(t);
        rec.addField(field);
        if (oldrec != null) {
            this.mergeRecords(oldrec, rec);
        }
        return type;
    }

    class XMLAttr
    extends XMLNode {
        public XMLAttr(Node node) {
            super(node);
        }

        @Override
        public QName getQName() {
            if (this.qname == null) {
                String localpart = this.node.getNodeName();
                String prefix = "";
                String namespace = null;
                int ndx = localpart.indexOf(58);
                if (ndx != -1) {
                    prefix = localpart.substring(0, ndx);
                    localpart = localpart.substring(ndx + 1);
                    if (prefix.length() > 0) {
                        namespace = this.lookupNamespace(this.node, prefix);
                    }
                }
                this.qname = new QName(namespace, localpart, prefix);
            }
            return this.qname;
        }
    }

    class XMLNode {
        protected Node node = null;
        protected QName qname = null;
        protected List<ArrayList<XMLNode>> children = null;
        protected List<ArrayList<XMLNode>> attributes = null;
        protected Boolean isNillable = null;

        public XMLNode(Node node) {
            this.node = node;
        }

        public List<ArrayList<XMLNode>> getChildElements() {
            if (this.children == null) {
                LinkedHashMap<String, ArrayList> map = new LinkedHashMap<String, ArrayList>();
                NodeList children = this.node.getChildNodes();
                int i = 0;
                while (i < children.getLength()) {
                    Node child = children.item(i);
                    if (child.getNodeType() == 1) {
                        ArrayList list;
                        XMLNode xmlNode = new XMLNode(child);
                        if (map.containsKey(xmlNode.getQName().toString())) {
                            list = (ArrayList)map.get(xmlNode.getQName().toString());
                            list.add(xmlNode);
                        } else {
                            list = new ArrayList();
                            list.add(xmlNode);
                            map.put(xmlNode.getQName().toString(), list);
                        }
                    }
                    ++i;
                }
                this.children = new ArrayList(map.values());
            }
            return this.children;
        }

        public List<ArrayList<XMLNode>> getChildAttributes() {
            if (this.attributes == null) {
                LinkedHashMap map = new LinkedHashMap();
                NamedNodeMap children = this.node.getAttributes();
                if (children != null) {
                    int i = 0;
                    while (i < children.getLength()) {
                        Node child = children.item(i);
                        XMLAttr xmlAttr = new XMLAttr(child);
                        if (!this.isSpecialAttribute(xmlAttr)) {
                            ArrayList<XMLAttr> list = new ArrayList<XMLAttr>();
                            list.add(xmlAttr);
                            map.put(xmlAttr.getQName().toString(), list);
                        }
                        ++i;
                    }
                }
                this.attributes = new ArrayList(map.values());
            }
            return this.attributes;
        }

        private boolean isSpecialAttribute(XMLAttr xmlAttr) {
            if (xmlAttr.getQName().getPrefix().equals("xmlns") || xmlAttr.getQName().getLocalPart().equals("xmlns")) {
                return true;
            }
            return reservedXSINames.containsKey(xmlAttr.getQName().getLocalPart()) && (xmlAttr.getQName().getNamespaceURI().equalsIgnoreCase("http://www.w3.org/2001/XMLSchema-instance") || xmlAttr.getQName().getPrefix().equals("xsi"));
        }

        public boolean isNillable() {
            if (this.isNillable == null) {
                this.isNillable = new Boolean(false);
                NamedNodeMap attributes = this.node.getAttributes();
                if (attributes != null) {
                    int i = 0;
                    while (i < attributes.getLength()) {
                        Node attribute = attributes.item(i);
                        XMLAttr xmlAttr = new XMLAttr(attribute);
                        if (xmlAttr.getQName().getLocalPart().equals("nil") && (xmlAttr.getQName().getNamespaceURI().equalsIgnoreCase("http://www.w3.org/2001/XMLSchema-instance") || xmlAttr.getQName().getPrefix().equals("xsi"))) {
                            String value = this.getElementText(attribute);
                            this.isNillable = new Boolean(value != null && value.equals("true"));
                        }
                        ++i;
                    }
                }
            }
            return this.isNillable;
        }

        private String getElementText(Node node) {
            NodeList children = node.getChildNodes();
            StringBuffer value = new StringBuffer();
            int j = 0;
            while (j < children.getLength()) {
                Node childnode = children.item(j);
                if (childnode.getNodeType() == 3) {
                    value.append(childnode.getNodeValue());
                }
                ++j;
            }
            return value.toString().trim().length() == 0 ? null : value.toString().trim();
        }

        public QName getQName() {
            if (this.qname == null) {
                String localpart = this.node.getNodeName();
                String prefix = "";
                String namespace = null;
                int ndx = localpart.indexOf(58);
                if (ndx != -1) {
                    prefix = localpart.substring(0, ndx);
                    localpart = localpart.substring(ndx + 1);
                }
                namespace = this.lookupNamespace(this.node, prefix);
                this.qname = new QName(namespace, localpart, prefix);
            }
            return this.qname;
        }

        protected String lookupNamespace(Node node, String prefix) {
            String namespace = null;
            short type = node.getNodeType();
            switch (type) {
                case 1: {
                    NamedNodeMap map = node.getAttributes();
                    boolean bFound = false;
                    if (map != null) {
                        int i = 0;
                        while (i < map.getLength()) {
                            Attr attribute = (Attr)map.item(i);
                            if (attribute.getNodeName().startsWith("xmlns")) {
                                String nsPrefix = "";
                                int ndx = attribute.getNodeName().indexOf(58);
                                if (ndx != -1) {
                                    nsPrefix = attribute.getNodeName().substring(ndx + 1);
                                }
                                if (prefix.equals(nsPrefix)) {
                                    namespace = attribute.getNodeValue();
                                    bFound = true;
                                    break;
                                }
                            }
                            ++i;
                        }
                    }
                    if (bFound) break;
                    namespace = this.lookupNamespace(node.getParentNode(), prefix);
                    break;
                }
                case 6: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    break;
                }
                case 2: {
                    namespace = this.lookupNamespace(((Attr)node).getOwnerElement(), prefix);
                    break;
                }
                default: {
                    System.out.println("We are here!!, type=" + node.getNodeType());
                }
            }
            return namespace;
        }
    }
}

