/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.record.conversion;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.edt.ide.ui.internal.record.conversion.IMessageHandler;
import org.eclipse.edt.ide.ui.internal.record.conversion.PartsWrapper;
import org.eclipse.edt.ide.ui.internal.record.conversion.RecordSource;
import org.eclipse.edt.ide.ui.templates.parts.Part;

public abstract class RecordConversion
implements IMessageHandler {
    private boolean _isOK = false;
    private List<String> _errors = new ArrayList<String>();
    private List<String> _messages = new ArrayList<String>();
    private String _result = "";
    private Part[] _resultParts = null;

    protected void ok(boolean isOK) {
        this._isOK = isOK;
    }

    public boolean isOK() {
        return this._isOK;
    }

    protected void error(String error) {
        this._errors.add(error);
    }

    public List<String> getErrors() {
        return this._errors;
    }

    public String getResult() {
        return this._result;
    }

    public Part[] getResultParts() {
        return this._resultParts;
    }

    protected abstract Part[] doConvert(RecordSource var1);

    public boolean convert(RecordSource input) {
        this._isOK = false;
        this._result = "";
        this._resultParts = null;
        Part[] parts = this.doConvert(input);
        if (this._isOK) {
            this._resultParts = parts;
            this._result = new PartsWrapper(parts).toString();
        }
        return this._isOK;
    }

    public IMessageHandler getMessageHandler() {
        return this;
    }

    @Override
    public void addMessage(String message) {
        if (!this._messages.contains(message)) {
            this._messages.add(message);
        }
    }

    @Override
    public List<String> getMessages() {
        return this._messages;
    }
}

