/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.quickfix;

import org.eclipse.edt.compiler.core.ast.File;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.ide.core.internal.model.EGLFile;
import org.eclipse.edt.ide.core.internal.model.document.EGLDocument;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.document.IEGLDocument;
import org.eclipse.edt.ide.ui.internal.editor.EGLEditor;
import org.eclipse.edt.ide.ui.internal.quickfix.IInvocationContext;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.TextInvocationContext;
import org.eclipse.ui.IEditorPart;

public class AssistContext
extends TextInvocationContext
implements IInvocationContext {
    private final IEGLFile fEGLFile;
    private final IEditorPart fEditor;
    private EGLDocument document;
    private File fileAST;
    private EGLFile fASTRoot;
    private Part part;

    public AssistContext(IEGLFile cu, ISourceViewer sourceViewer, IEditorPart editor, int offset, int length) {
        super(sourceViewer, offset, length);
        this.fEGLFile = cu;
        this.fEditor = editor;
        IDocument doc = ((EGLEditor)this.fEditor).getDocumentProvider().getDocument((Object)this.fEditor.getEditorInput());
        this.document = (EGLDocument)doc;
        this.fileAST = this.document.getNewModelEGLFile();
        this.part = this.document.getNewModelPartAtOffset(this.getSelectionOffset());
    }

    @Override
    public IEGLFile getEGLFile() {
        return this.fEGLFile;
    }

    public IEditorPart getEditor() {
        return this.fEditor;
    }

    @Override
    public int getSelectionLength() {
        return Math.max(this.getLength(), 0);
    }

    @Override
    public int getSelectionOffset() {
        return this.getOffset();
    }

    public EGLFile getASTRoot() {
        return this.fASTRoot;
    }

    @Override
    public File getFileAST() {
        return this.fileAST;
    }

    @Override
    public Part getPart() {
        return this.part;
    }

    @Override
    public IEGLDocument getDocument() {
        return this.document;
    }

    @Override
    public Node getCoveringNode() {
        if (this.document != null) {
            return this.document.getNewModelNodeAtOffset(this.getOffset());
        }
        return null;
    }
}

