/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.property.pages;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.edt.ide.core.model.EGLConventions;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.EGLSystemPathContaierInitializer;
import org.eclipse.edt.ide.core.model.IEGLModelStatus;
import org.eclipse.edt.ide.core.model.IEGLPathEntry;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.model.PPListElement;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.EGLLogger;
import org.eclipse.edt.ide.ui.internal.IUIHelpConstants;
import org.eclipse.edt.ide.ui.internal.PluginImages;
import org.eclipse.edt.ide.ui.internal.dialogs.StatusInfo;
import org.eclipse.edt.ide.ui.internal.util.TabFolderLayout;
import org.eclipse.edt.ide.ui.internal.wizards.NewWizardMessages;
import org.eclipse.edt.ide.ui.internal.wizards.buildpaths.EGLPathOrderingWorkbookPage;
import org.eclipse.edt.ide.ui.internal.wizards.buildpaths.PPListLabelProvider;
import org.eclipse.edt.ide.ui.internal.wizards.buildpaths.ProjectsWorkbookPage;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.CheckedListDialogField;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.DialogField;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.edt.ide.ui.wizards.EGLProjectUtility;
import org.eclipse.edt.ide.ui.wizards.ProjectConfiguration;
import org.eclipse.edt.ide.ui.wizards.ProjectConfigurationOperation;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;

public class EGLProjectBuildPathPropertyPage
extends PropertyPage {
    private IProject project;
    private IEGLPathEntry[] entries = null;
    private IPath outputLocation = null;
    private IResource thisResource = null;
    private StatusInfo fEGLPathStatus;
    private StatusInfo fBuildPathStatus;
    private ProjectConfiguration configuration;
    private ProjectConfigurationOperation operation;
    private IPath fOutputLocationPath;
    protected IProject fCurrProject;
    private CheckedListDialogField fClassPathList;
    private StringButtonDialogField fBuildPathDialogField;
    private ProjectsWorkbookPage fProjectsPage;
    private EGLPathOrderingWorkbookPage fOrderPage;

    protected Control createContents(Composite parent) {
        this.fCurrProject = null;
        if (this.getSelectedResource() instanceof IProject) {
            this.project = (IProject)this.getSelectedResource();
        }
        this.initialize();
        this.createDescriptionLabel(parent);
        this.setLayout(parent);
        this.createCapabilityControls(parent);
        this.initFields(EGLCore.create((IProject)this.project), this.outputLocation, this.entries, false);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, IUIHelpConstants.BUILD_PATH_CONTEXT);
        Dialog.applyDialogFont((Control)parent);
        return parent;
    }

    private IResource getSelectedResource() {
        IResource resource = null;
        IAdaptable adaptable = this.getElement();
        if (adaptable != null) {
            resource = (IResource)adaptable.getAdapter(IResource.class);
        }
        return resource;
    }

    private void initialize() {
        this.fBuildPathStatus = new StatusInfo();
        this.fEGLPathStatus = new StatusInfo();
        this.thisResource = this.getSelectedResource();
        this.noDefaultAndApplyButton();
        this.createProjectConfiguration();
    }

    public boolean performOk() {
        if (this.thisResource != null) {
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    EGLProjectBuildPathPropertyPage.this.operation = new ProjectConfigurationOperation(EGLProjectBuildPathPropertyPage.this.configuration);
                    try {
                        EGLProjectBuildPathPropertyPage.this.operation.run(monitor);
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                }
            };
            try {
                new ProgressMonitorDialog(this.getControl().getShell()).run(true, true, runnable);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException e) {
                this.handle(e);
            }
        }
        return true;
    }

    protected void handle(InvocationTargetException e) {
        IStatus error;
        Throwable target = e.getTargetException();
        if (target instanceof CoreException) {
            error = ((CoreException)target).getStatus();
        } else {
            String msg = target.getMessage();
            if (msg == null) {
                msg = "Internal error";
            }
            error = new Status(4, "org.eclipse.edt.ide.ui", 1, msg, target);
        }
        ErrorDialog.openError((Shell)this.getControl().getShell(), (String)"Problems Occurred", null, (IStatus)error);
    }

    private void createProjectConfiguration() {
        this.configuration = new ProjectConfiguration();
        this.project = this.getSelectedResource() instanceof IProject ? (IProject)this.getSelectedResource() : this.getSelectedResource().getProject();
        this.configuration.setProjectName(this.project.getName());
        this.configuration.setConfigureEGLPathOnly(true);
        try {
            this.entries = EGLCore.create((IProject)this.project).getRawEGLPath();
            ArrayList<PPListElement> entriesList = new ArrayList<PPListElement>();
            int j = 0;
            while (j < this.entries.length) {
                entriesList.add((PPListElement)this.entries[j]);
                ++j;
            }
            this.configuration.setRequiredProjects(entriesList);
        }
        catch (EGLModelException e) {
            this.entries = null;
            EGLLogger.log((Object)this, e.toString());
        }
    }

    private void setLayout(Composite composite) {
        GridLayout layout = new GridLayout();
        GridData gd = new GridData(1808);
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)gd);
    }

    private void createCapabilityControls(Composite composite) {
        BuildPathAdapter adapter = new BuildPathAdapter();
        String[] stringArray = new String[5];
        stringArray[0] = NewWizardMessages.BuildPathsBlockClasspathUpButton;
        stringArray[1] = NewWizardMessages.BuildPathsBlockClasspathDownButton;
        stringArray[3] = NewWizardMessages.BuildPathsBlockClasspathCheckallButton;
        stringArray[4] = NewWizardMessages.BuildPathsBlockClasspathUncheckallButton;
        String[] buttonLabels = stringArray;
        this.fClassPathList = new CheckedListDialogField(null, buttonLabels, (ILabelProvider)new PPListLabelProvider());
        this.fClassPathList.setDialogFieldListener(adapter);
        this.fClassPathList.setLabelText(NewWizardMessages.BuildPathsBlockClasspathLabel);
        this.fClassPathList.setUpButtonIndex(0);
        this.fClassPathList.setDownButtonIndex(1);
        this.fClassPathList.setCheckAllButtonIndex(3);
        this.fClassPathList.setUncheckAllButtonIndex(4);
        this.fBuildPathDialogField = new StringButtonDialogField(adapter);
        this.fBuildPathDialogField.setButtonLabel(NewWizardMessages.BuildPathsBlockBuildpathButton);
        this.fBuildPathDialogField.setDialogFieldListener(adapter);
        this.fBuildPathDialogField.setLabelText(NewWizardMessages.BuildPathsBlockBuildpathLabel);
        Composite tabComposite = new Composite(composite, 0);
        GridLayout tabLayout = new GridLayout();
        tabLayout.marginWidth = 0;
        tabLayout.numColumns = 1;
        tabComposite.setLayout((Layout)tabLayout);
        tabComposite.setLayoutData((Object)new GridData(1808));
        TabFolder folder = new TabFolder(tabComposite, 0);
        folder.setLayout((Layout)new TabFolderLayout());
        folder.setLayoutData((Object)new GridData(1808));
        this.fProjectsPage = new ProjectsWorkbookPage(this.fClassPathList);
        IWorkbench workbench = EDTUIPlugin.getDefault().getWorkbench();
        Image projectImage = workbench.getSharedImages().getImage("IMG_OBJ_PROJECT");
        TabItem item = new TabItem(folder, 0);
        item.setText(NewWizardMessages.BuildPathsBlockTabProjects);
        item.setImage(projectImage);
        item.setData((Object)this.fProjectsPage);
        item.setControl(this.fProjectsPage.getControl((Composite)folder));
        Image cpoImage = PluginImages.DESC_OBJS_EGLBUILDPATH_ORDER.createImage();
        this.fOrderPage = new EGLPathOrderingWorkbookPage(this.fClassPathList);
        item = new TabItem(folder, 0);
        item.setText(NewWizardMessages.BuildPathsBlockTabOrder);
        item.setImage(cpoImage);
        item.setData((Object)this.fOrderPage);
        item.setControl(this.fOrderPage.getControl((Composite)folder));
        if (this.fCurrProject != null) {
            this.fProjectsPage.init(EGLCore.create((IProject)this.fCurrProject));
            this.fOrderPage.init(EGLCore.create((IProject)this.fCurrProject));
        }
    }

    private void handleBuildPathDialogFieldChanged(DialogField field) {
        this.configuration.setRequiredProjects(this.fClassPathList.getElements());
        if (field == this.fClassPathList) {
            this.updateEGLPathStatus();
        }
    }

    private void initFields(IEGLProject eproject, IPath defaultOutputLocation, IEGLPathEntry[] defaultEntries, boolean defaultsOverrideExistingEGLPath) {
        PPListElement currEGL;
        if (!defaultsOverrideExistingEGLPath && eproject.exists() && eproject.getProject().getFile(".classpath").exists()) {
            defaultOutputLocation = null;
            defaultEntries = null;
        }
        IEGLProject fCurrEProject = eproject;
        IEGLPathEntry[] eglPathEntries = defaultEntries;
        IPath outputLocation = defaultOutputLocation;
        boolean projectExists = false;
        List<PPListElement> newEGLPath = null;
        try {
            IProject project = fCurrEProject.getProject();
            boolean bl = projectExists = project.exists() && project.getFile(".eglPath").exists();
            if (projectExists) {
                if (outputLocation == null) {
                    outputLocation = fCurrEProject.getOutputLocation();
                }
                if (eglPathEntries == null) {
                    eglPathEntries = fCurrEProject.getRawEGLPath();
                }
            }
            if (outputLocation == null) {
                outputLocation = EGLProjectUtility.getDefaultEGLOutputPath(eproject);
            }
            if (eglPathEntries != null) {
                newEGLPath = EGLProjectUtility.getExistingEntries(eglPathEntries, eproject);
            }
        }
        catch (CoreException e) {
            EGLLogger.log((Object)this, e);
        }
        if (newEGLPath == null) {
            newEGLPath = EGLProjectUtility.getDefaultClassPath(eproject);
        }
        ArrayList<PPListElement> exportedEntries = new ArrayList<PPListElement>();
        int i = 0;
        while (i < newEGLPath.size()) {
            currEGL = newEGLPath.get(i);
            if (currEGL.isExported() || currEGL.getEntryKind() == 3) {
                exportedEntries.add(currEGL);
            }
            ++i;
        }
        this.fBuildPathDialogField.setText(outputLocation.makeRelative().toString());
        this.fBuildPathDialogField.enableButton(projectExists);
        this.fClassPathList.setElements(newEGLPath);
        this.fClassPathList.setCheckedElements(exportedEntries);
        i = 0;
        while (i < newEGLPath.size()) {
            currEGL = newEGLPath.get(i);
            if (EGLSystemPathContaierInitializer.isValidEGLSystemPathContainerPath((IPath)currEGL.getEGLPathEntry().getPath())) {
                this.fClassPathList.setGrayedWithoutUpdate(currEGL, true);
                break;
            }
            ++i;
        }
        if (this.fProjectsPage != null) {
            this.fProjectsPage.init(fCurrEProject);
        }
        if (this.fOrderPage != null) {
            this.fOrderPage.init(fCurrEProject);
        }
        this.fOutputLocationPath = outputLocation;
    }

    public void updateEGLPathStatus() {
        this.fEGLPathStatus.setOK();
        List elements = this.fClassPathList.getElements();
        PPListElement entryMissing = null;
        int nEntriesMissing = 0;
        IEGLPathEntry[] entries = new IEGLPathEntry[elements.size()];
        int i = elements.size() - 1;
        while (i >= 0) {
            PPListElement currElement = (PPListElement)elements.get(i);
            boolean isChecked = this.fClassPathList.isChecked(currElement);
            if (currElement.getEntryKind() == 3) {
                if (!isChecked) {
                    this.fClassPathList.setCheckedWithoutUpdate(currElement, true);
                }
            } else if (EGLSystemPathContaierInitializer.isValidEGLSystemPathContainerPath((IPath)currElement.getEGLPathEntry().getPath())) {
                if (isChecked) {
                    this.fClassPathList.setCheckedWithoutUpdate(currElement, false);
                }
            } else {
                currElement.setExported(isChecked);
            }
            entries[i] = currElement.getEGLPathEntry();
            if (currElement.isMissing()) {
                ++nEntriesMissing;
                if (entryMissing == null) {
                    entryMissing = currElement;
                }
            }
            --i;
        }
        if (nEntriesMissing > 0) {
            if (nEntriesMissing == 1) {
                this.fEGLPathStatus.setWarning(NewWizardMessages.bind((String)NewWizardMessages.BuildPathsBlockWarningEntryMissing, (Object)entryMissing.getPath().toString()));
            } else {
                this.fEGLPathStatus.setWarning(NewWizardMessages.bind((String)NewWizardMessages.BuildPathsBlockWarningEntriesMissing, (Object)String.valueOf(nEntriesMissing)));
            }
        }
        if (nEntriesMissing > 0) {
            if (nEntriesMissing == 1) {
                this.fEGLPathStatus.setWarning(NewWizardMessages.bind((String)NewWizardMessages.BuildPathsBlockWarningEntryMissing, (Object)entryMissing.getPath().toString()));
                this.setMessage(NewWizardMessages.bind((String)NewWizardMessages.BuildPathsBlockWarningEntryMissing, (Object)entryMissing.getPath().toString()), 2);
            } else {
                this.fEGLPathStatus.setWarning(NewWizardMessages.bind((String)NewWizardMessages.BuildPathsBlockWarningEntriesMissing, (Object)String.valueOf(nEntriesMissing)));
                this.setMessage(NewWizardMessages.bind((String)NewWizardMessages.BuildPathsBlockWarningEntryMissing, (Object)String.valueOf(nEntriesMissing)), 2);
            }
            this.setErrorMessage(null);
        }
        this.updateBuildPathStatus();
    }

    private void updateBuildPathStatus() {
        List elements = this.fClassPathList.getElements();
        IEGLPathEntry[] entries = new IEGLPathEntry[elements.size()];
        int i = elements.size() - 1;
        while (i >= 0) {
            PPListElement currElement = (PPListElement)elements.get(i);
            entries[i] = currElement.getEGLPathEntry();
            --i;
        }
        IEGLModelStatus status = EGLConventions.validateEGLPath((IEGLProject)EGLCore.create((IProject)this.project), (IEGLPathEntry[])entries, (IPath)this.fOutputLocationPath);
        if (!status.isOK()) {
            this.fBuildPathStatus.setError(status.getMessage());
            return;
        }
        this.fBuildPathStatus.setOK();
    }

    private class BuildPathAdapter
    implements IStringButtonAdapter,
    IDialogFieldListener {
        private BuildPathAdapter() {
        }

        @Override
        public void changeControlPressed(DialogField field) {
        }

        @Override
        public void dialogFieldChanged(DialogField field) {
            EGLProjectBuildPathPropertyPage.this.handleBuildPathDialogFieldChanged(field);
        }
    }
}

