/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.property.pages;

import java.util.ArrayList;
import org.eclipse.core.runtime.IPath;
import org.eclipse.edt.ide.ui.internal.PluginImages;
import org.eclipse.edt.ide.ui.internal.property.pages.BasicElementLabels;
import org.eclipse.edt.ide.ui.internal.property.pages.CPVariableElement;
import org.eclipse.edt.ide.ui.internal.property.pages.Messages;
import org.eclipse.edt.ide.ui.internal.wizards.NewWizardMessages;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class CPVariableElementLabelProvider
extends LabelProvider
implements IColorProvider {
    private Image fJARImage = PluginImages.get("org.eclipse.edt.ide.ui.jar_obj.gif");
    private Image fFolderImage = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
    private Color fResolvedBackground;
    private Image fDeprecatedJARImage = this.fJARImage;
    private Image fDeprecatedFolderImage = this.fFolderImage;
    private boolean fHighlightReadOnly;

    public CPVariableElementLabelProvider(boolean highlightReadOnly) {
        this.fHighlightReadOnly = highlightReadOnly;
        this.fResolvedBackground = null;
    }

    public Image getImage(Object element) {
        if (element instanceof CPVariableElement) {
            CPVariableElement curr = (CPVariableElement)element;
            IPath path = curr.getPath();
            if (path.toFile().isFile()) {
                return curr.isDeprecated() ? this.fDeprecatedJARImage : this.fJARImage;
            }
            return curr.isDeprecated() ? this.fDeprecatedFolderImage : this.fFolderImage;
        }
        return super.getImage(element);
    }

    public String getText(Object element) {
        if (element instanceof CPVariableElement) {
            CPVariableElement curr = (CPVariableElement)element;
            String name = curr.getName();
            IPath path = curr.getPath();
            String result = name;
            new ArrayList(2);
            if (path != null) {
                String appendix = !path.isEmpty() ? BasicElementLabels.getPathLabel(path, true) : NewWizardMessages.CPVariableElementLabelProvider_empty;
                result = Messages.format(NewWizardMessages.CPVariableElementLabelProvider_appendix, new Object[]{result, appendix});
            }
            return result;
        }
        return super.getText(element);
    }

    public Color getForeground(Object element) {
        return null;
    }

    public Color getBackground(Object element) {
        if (element instanceof CPVariableElement) {
            CPVariableElement curr = (CPVariableElement)element;
            if (this.fHighlightReadOnly && curr.isReadOnly()) {
                if (this.fResolvedBackground == null) {
                    Display display = Display.getCurrent();
                    this.fResolvedBackground = display.getSystemColor(29);
                }
                return this.fResolvedBackground;
            }
        }
        return null;
    }

    public void dispose() {
        super.dispose();
        this.fDeprecatedFolderImage.dispose();
        this.fDeprecatedJARImage.dispose();
    }
}

