/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.preferences;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.editor.IFoldingPreferenceBlock;
import org.eclipse.edt.ide.ui.internal.UINlsStrings;
import org.eclipse.edt.ide.ui.internal.editor.folding.FoldingStructureProviderDescriptor;
import org.eclipse.edt.ide.ui.internal.editor.folding.FoldingStructureProviderRegistry;
import org.eclipse.edt.ide.ui.internal.preferences.OverlayPreferenceStore;
import org.eclipse.edt.ide.ui.internal.util.PixelConverter;
import org.eclipse.jdt.internal.ui.preferences.IPreferenceConfigurationBlock;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class FoldingConfigurationBlock
implements IPreferenceConfigurationBlock {
    private final OverlayPreferenceStore fStore;
    private Combo fProviderCombo;
    private Button fFoldingCheckbox;
    private ComboViewer fProviderViewer;
    private Composite fGroup;
    private StackLayout fStackLayout;
    private final Map fProviderDescriptors;
    private final Map fProviderPreferences;
    private final Map fProviderControls;

    public FoldingConfigurationBlock(OverlayPreferenceStore store) {
        Assert.isNotNull((Object)store);
        this.fStore = store;
        this.fStore.addKeys(this.createOverlayStoreKeys());
        this.fProviderDescriptors = this.createListModel();
        this.fProviderPreferences = new HashMap();
        this.fProviderControls = new HashMap();
    }

    private Map createListModel() {
        FoldingStructureProviderRegistry reg = EDTUIPlugin.getDefault().getFoldingStructureProviderRegistry();
        reg.reloadExtensions();
        FoldingStructureProviderDescriptor[] descs = reg.getFoldingProviderDescriptors();
        HashMap<String, FoldingStructureProviderDescriptor> map = new HashMap<String, FoldingStructureProviderDescriptor>();
        int i = 0;
        while (i < descs.length) {
            map.put(descs[i].getId(), descs[i]);
            ++i;
        }
        return map;
    }

    private OverlayPreferenceStore.OverlayKey[] createOverlayStoreKeys() {
        ArrayList<OverlayPreferenceStore.OverlayKey> overlayKeys = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "editor_folding_enabled"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "editor_folding_provider"));
        OverlayPreferenceStore.OverlayKey[] keys = new OverlayPreferenceStore.OverlayKey[overlayKeys.size()];
        overlayKeys.toArray(keys);
        return keys;
    }

    public Control createControl(Composite parent) {
        GridLayout gridLayout;
        Composite composite = new Composite(parent, 0);
        GridData gd = new GridData(80);
        composite.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        PixelConverter pc = new PixelConverter((Control)composite);
        layout.verticalSpacing = pc.convertHeightInCharsToPixels(1) / 2;
        composite.setLayout((Layout)layout);
        this.fFoldingCheckbox = new Button(composite, 32);
        this.fFoldingCheckbox.setText(UINlsStrings.EditorFoldingPreferencePageEnable);
        gd = new GridData(34);
        this.fFoldingCheckbox.setLayoutData((Object)gd);
        this.fFoldingCheckbox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean enabled = FoldingConfigurationBlock.this.fFoldingCheckbox.getSelection();
                FoldingConfigurationBlock.this.fStore.setValue("editor_folding_enabled", enabled);
                FoldingConfigurationBlock.this.updateCheckboxDependencies();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label label = new Label(composite, 0x1000000);
        gd = new GridData(770);
        label.setLayoutData((Object)gd);
        if (this.fProviderDescriptors.size() > 1) {
            Composite comboComp = new Composite(composite, 0);
            gd = new GridData(770);
            gridLayout = new GridLayout(2, false);
            gridLayout.marginWidth = 0;
            comboComp.setLayout((Layout)gridLayout);
            Label comboLabel = new Label(comboComp, 0x1000000);
            gd = new GridData(36);
            comboLabel.setLayoutData((Object)gd);
            comboLabel.setText(UINlsStrings.EditorFoldingPreferencePageCombo_caption);
            label = new Label(composite, 0x1000000);
            gd = new GridData(770);
            label.setLayoutData((Object)gd);
            this.fProviderCombo = new Combo(comboComp, 12);
            gd = new GridData(132);
            this.fProviderCombo.setLayoutData((Object)gd);
            this.fProviderViewer = this.createProviderViewer();
        }
        Composite groupComp = new Composite(composite, 0);
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        groupComp.setLayoutData((Object)gd);
        gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        groupComp.setLayout((Layout)gridLayout);
        this.fGroup = new Composite(groupComp, 0);
        gd = new GridData(34);
        this.fGroup.setLayoutData((Object)gd);
        this.fStackLayout = new StackLayout();
        this.fGroup.setLayout((Layout)this.fStackLayout);
        return composite;
    }

    private ComboViewer createProviderViewer() {
        ComboViewer viewer = new ComboViewer(this.fProviderCombo);
        viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer v, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object inputElement) {
                return FoldingConfigurationBlock.this.fProviderDescriptors.values().toArray();
            }
        });
        viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                return null;
            }

            public String getText(Object element) {
                return ((FoldingStructureProviderDescriptor)element).getName();
            }
        });
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                if (!sel.isEmpty()) {
                    FoldingConfigurationBlock.this.fStore.setValue("editor_folding_provider", ((FoldingStructureProviderDescriptor)sel.getFirstElement()).getId());
                    FoldingConfigurationBlock.this.updateListDependencies();
                }
            }
        });
        viewer.setInput((Object)this.fProviderDescriptors);
        viewer.refresh();
        return viewer;
    }

    private void updateCheckboxDependencies() {
    }

    void updateListDependencies() {
        IFoldingPreferenceBlock prefs;
        String id = this.fStore.getString("editor_folding_provider");
        FoldingStructureProviderDescriptor desc = (FoldingStructureProviderDescriptor)this.fProviderDescriptors.get(id);
        if (desc == null) {
            String message = UINlsStrings.EditorFoldingPreferenceError_not_exist;
            EDTUIPlugin.log((IStatus)new Status(2, EDTUIPlugin.getPluginId(), 0, message, null));
            prefs = new ErrorPreferences(message);
        } else {
            prefs = (IFoldingPreferenceBlock)this.fProviderPreferences.get(id);
            if (prefs == null) {
                try {
                    prefs = desc.createPreferences();
                    this.fProviderPreferences.put(id, prefs);
                }
                catch (CoreException e) {
                    EDTUIPlugin.log(e);
                    prefs = new ErrorPreferences(e.getLocalizedMessage());
                }
            }
        }
        Control control = (Control)this.fProviderControls.get(id);
        if (control == null) {
            control = prefs.createControl(this.fGroup);
            if (control == null) {
                String message = UINlsStrings.EditorFoldingPreferencePageInfo_no_preferences;
                control = new ErrorPreferences(message).createControl(this.fGroup);
            } else {
                this.fProviderControls.put(id, control);
            }
        }
        Dialog.applyDialogFont((Control)control);
        this.fStackLayout.topControl = control;
        control.pack();
        this.fGroup.layout();
        this.fGroup.getParent().layout();
        prefs.initialize();
    }

    public void initialize() {
        this.restoreFromPreferences();
    }

    public void performOk() {
        for (IFoldingPreferenceBlock prefs : this.fProviderPreferences.values()) {
            prefs.performOk();
        }
    }

    public void performDefaults() {
        this.restoreFromPreferences();
        for (IFoldingPreferenceBlock prefs : this.fProviderPreferences.values()) {
            prefs.performDefaults();
        }
    }

    public void dispose() {
        for (IFoldingPreferenceBlock prefs : this.fProviderPreferences.values()) {
            prefs.dispose();
        }
    }

    private void restoreFromPreferences() {
        boolean enabled = this.fStore.getBoolean("editor_folding_enabled");
        this.fFoldingCheckbox.setSelection(enabled);
        this.updateCheckboxDependencies();
        String id = this.fStore.getString("editor_folding_provider");
        Object provider = this.fProviderDescriptors.get(id);
        if (provider != null) {
            if (this.fProviderViewer == null) {
                this.updateListDependencies();
            } else {
                this.fProviderViewer.setSelection((ISelection)new StructuredSelection(provider), true);
            }
        }
    }

    private static class ErrorPreferences
    implements IFoldingPreferenceBlock {
        private String fMessage;

        protected ErrorPreferences(String message) {
            this.fMessage = message;
        }

        @Override
        public Control createControl(Composite composite) {
            Composite inner = new Composite(composite, 0);
            inner.setLayout((Layout)new FillLayout(512));
            Label label = new Label(inner, 0x1000000);
            label.setText(this.fMessage);
            return inner;
        }

        @Override
        public void initialize() {
        }

        @Override
        public void performOk() {
        }

        @Override
        public void performDefaults() {
        }

        @Override
        public void dispose() {
        }
    }
}

