/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.packageexplorer;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.Platform;
import org.eclipse.edt.ide.core.internal.model.EGLProject;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.ElementChangedEvent;
import org.eclipse.edt.ide.core.model.IClassFile;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLElementDelta;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.model.IElementChangedListener;
import org.eclipse.edt.ide.core.model.IPackageFragment;
import org.eclipse.edt.ide.core.model.IPackageFragmentRoot;
import org.eclipse.edt.ide.core.model.IWorkingCopy;
import org.eclipse.edt.ide.ui.internal.EGLElementAdapterFactory;
import org.eclipse.edt.ide.ui.internal.EGLLogger;
import org.eclipse.edt.ide.ui.internal.StandardEGLElementContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;

public class EGLElementContentProvider
extends StandardEGLElementContentProvider
implements IElementChangedListener {
    protected static final Object[] NO_CHILDREN = new Object[0];
    protected TreeViewer fViewer;
    protected Object fInput;
    protected boolean fProvideMembers = false;
    private EGLElementAdapterFactory fEGLElementAdapterFactory;

    public EGLElementContentProvider() {
        this.registerAdapters();
    }

    @Override
    public void dispose() {
    }

    @Override
    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.fViewer = (TreeViewer)viewer;
        if (oldInput == null && newInput != null) {
            EGLCore.addElementChangedListener((IElementChangedListener)this);
        } else if (oldInput != null && newInput == null) {
            EGLCore.removeElementChangedListener((IElementChangedListener)this);
        }
        this.fInput = newInput;
    }

    protected static Object[] concatenate(Object[] a1, Object[] a2) {
        int a1Len = a1.length;
        int a2Len = a2.length;
        Object[] res = new Object[a1Len + a2Len];
        System.arraycopy(a1, 0, res, 0, a1Len);
        System.arraycopy(a2, 0, res, a1Len, a2Len);
        return res;
    }

    public void elementChanged(ElementChangedEvent event) {
        try {
            this.processDelta(event.getDelta());
        }
        catch (EGLModelException eGLModelException) {}
    }

    protected void processDelta(IEGLElementDelta delta) throws EGLModelException {
        IEGLElementDelta[] affectedChildren;
        int kind = delta.getKind();
        int flags = delta.getFlags();
        IEGLElement element = delta.getElement();
        if (element != null && element.getElementType() == 6 && !element.getEGLProject().isOnEGLPath(element)) {
            return;
        }
        if ((flags & 0x400) != 0 || (flags & 0x200) != 0) {
            this.postRefresh(element);
            return;
        }
        if (kind == 2) {
            if (this.isWorkingCopy(element)) {
                this.refreshWorkingCopy((IWorkingCopy)element);
                return;
            }
            Object parent = this.internalGetParent(element);
            this.postRemove(element);
            if (element instanceof IEGLProject) {
                this.postRemove(((IEGLProject)element).getProject());
            }
            if (parent instanceof IPackageFragment) {
                this.updatePackageIcon((IEGLElement)((IPackageFragment)parent));
            }
            if (this.isPackageFragmentEmpty(element.getParent()) && this.fViewer.testFindItem(parent) != null) {
                this.postRefresh(this.internalGetParent(parent));
            }
            return;
        }
        if (kind == 1) {
            if (this.isWorkingCopy(element)) {
                this.refreshWorkingCopy((IWorkingCopy)element);
                return;
            }
            Object parent = this.internalGetParent(element);
            if (parent instanceof IPackageFragment) {
                Object grandparent = this.internalGetParent(parent);
                if (parent.equals(this.fInput)) {
                    this.postRefresh(parent);
                } else if (this.fViewer.testFindItem(parent) == null) {
                    this.postRefresh(grandparent);
                } else {
                    this.postRefresh(parent);
                }
            } else {
                this.postAdd(parent, element);
            }
        }
        if (element instanceof IEGLFile && kind == 4) {
            this.postRefresh(element);
            return;
        }
        if (element instanceof IEGLFile || element instanceof IClassFile) {
            return;
        }
        if (this.isClassPathChange(delta)) {
            this.postRefresh(element.getEGLProject());
        }
        if (delta.getResourceDeltas() != null) {
            IResourceDelta[] rd = delta.getResourceDeltas();
            int i = 0;
            while (i < rd.length) {
                this.processResourceDelta(rd[i], element);
                ++i;
            }
        }
        if ((affectedChildren = delta.getAffectedChildren()).length > 1) {
            if (element instanceof IPackageFragment) {
                IEGLElement parent = (IEGLElement)this.internalGetParent(element);
                if (element.equals(this.fInput)) {
                    this.postRefresh(element);
                } else {
                    this.postRefresh(parent);
                }
                return;
            }
            if (element instanceof IPackageFragmentRoot) {
                this.postRefresh(this.skipProjectPackageFragmentRoot((IPackageFragmentRoot)element));
            } else {
                this.postRefresh(element);
            }
            return;
        }
        int i = 0;
        while (i < affectedChildren.length) {
            this.processDelta(affectedChildren[i]);
            ++i;
        }
    }

    private void postRefresh(final Object root) {
        this.postRunnable(new Runnable(){

            @Override
            public void run() {
                Control ctrl = EGLElementContentProvider.this.fViewer.getControl();
                if (ctrl != null && !ctrl.isDisposed() && root instanceof IEGLElement) {
                    IEGLElement parentElement = ((IEGLElement)root).getAncestor(3);
                    if (parentElement != null) {
                        EGLElementContentProvider.this.fViewer.refresh((Object)parentElement);
                    } else if (root instanceof EGLProject) {
                        IProject project = ((EGLProject)root).getProject();
                        EGLElementContentProvider.this.fViewer.refresh((Object)project);
                    } else {
                        EGLElementContentProvider.this.fViewer.refresh(root);
                    }
                }
            }
        });
    }

    private void postAdd(final Object parent, final Object element) {
        this.postRunnable(new Runnable(){

            @Override
            public void run() {
                Control ctrl = EGLElementContentProvider.this.fViewer.getControl();
                if (ctrl != null && !ctrl.isDisposed()) {
                    EGLElementContentProvider.this.fViewer.add(parent, element);
                }
            }
        });
    }

    private void postRemove(final Object element) {
        this.postRunnable(new Runnable(){

            @Override
            public void run() {
                Control ctrl = EGLElementContentProvider.this.fViewer.getControl();
                if (ctrl != null && !ctrl.isDisposed()) {
                    EGLElementContentProvider.this.fViewer.setSelection(null);
                    EGLElementContentProvider.this.fViewer.remove(element);
                }
            }
        });
    }

    private void postRunnable(Runnable r) {
        Control ctrl = this.fViewer.getControl();
        if (ctrl != null && !ctrl.isDisposed()) {
            ctrl.getDisplay().asyncExec(r);
        }
    }

    private void refreshWorkingCopy(IWorkingCopy workingCopy) {
        IEGLElement original = workingCopy.getOriginalElement();
        if (original != null) {
            this.postRefresh(original);
        }
    }

    private boolean isWorkingCopy(IEGLElement element) {
        return element instanceof IWorkingCopy && ((IWorkingCopy)element).isWorkingCopy();
    }

    private void updatePackageIcon(final IEGLElement element) {
        this.postRunnable(new Runnable(){

            @Override
            public void run() {
                Control ctrl = EGLElementContentProvider.this.fViewer.getControl();
                if (ctrl != null && !ctrl.isDisposed()) {
                    EGLElementContentProvider.this.fViewer.update((Object)element, new String[]{"org.eclipse.jface.image"});
                }
            }
        });
    }

    private void processResourceDelta(IResourceDelta delta, Object parent) {
        IResourceDelta[] affectedChildren;
        int status = delta.getKind();
        IResource resource = delta.getResource();
        if (resource == null) {
            return;
        }
        if ((status & 2) != 0) {
            if (parent instanceof IPackageFragment) {
                this.postRefresh(this.internalGetParent(parent));
            } else {
                this.postRemove(resource);
            }
        }
        if ((status & 1) != 0) {
            if (parent instanceof IPackageFragment) {
                this.postRefresh(this.internalGetParent(parent));
            } else {
                this.postAdd(parent, resource);
            }
        }
        if ((affectedChildren = delta.getAffectedChildren()).length > 1) {
            this.postRefresh(resource);
            return;
        }
        int i = 0;
        while (i < affectedChildren.length) {
            this.processResourceDelta(affectedChildren[i], resource);
            ++i;
        }
    }

    private void registerAdapters() {
        this.fEGLElementAdapterFactory = new EGLElementAdapterFactory();
        IAdapterManager manager = Platform.getAdapterManager();
        manager.registerAdapters((IAdapterFactory)this.fEGLElementAdapterFactory, IEGLElement.class);
    }

    private Object convertElement(Object element) {
        if (element instanceof IEGLProject) {
            IProject project = ((IEGLProject)element).getProject();
            try {
                if (project.hasNature(EGLCore.NATURE_ID)) {
                    return project;
                }
                return element;
            }
            catch (CoreException e) {
                EGLLogger.log((Object)this, e);
            }
        }
        return element;
    }

    @Override
    protected Object internalGetParent(Object element) {
        return this.convertElement(super.internalGetParent(element));
    }

    @Override
    protected Object[] getResources(IFolder folder) {
        return NO_CHILDREN;
    }
}

