/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.outline;

import java.util.ArrayList;
import org.eclipse.edt.compiler.core.ast.File;
import org.eclipse.edt.ide.core.model.document.IEGLDocument;
import org.eclipse.edt.ide.ui.internal.editor.EGLEditor;
import org.eclipse.edt.ide.ui.internal.outline.AbstractOutlineAdapter;
import org.eclipse.edt.ide.ui.internal.outline.ImportGroup;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;

public class FileOutlineAdapter
extends AbstractOutlineAdapter {
    private ImportGroup importGroup;

    public FileOutlineAdapter(IEGLDocument document, EGLEditor editor) {
        super(editor);
        this.importGroup = new ImportGroup(document);
    }

    @Override
    public Object[] getChildren(Object parentElement) {
        File file = (File)parentElement;
        ArrayList<Object> result = new ArrayList<Object>();
        if (file.hasPackageDeclaration()) {
            result.add(file.getPackageDeclaration());
        }
        if (file.getImportDeclarations().size() > 0) {
            result.add(this.importGroup);
        }
        result.addAll(file.getParts());
        return result.toArray();
    }

    @Override
    public String getText(Object element) {
        IEditorInput editorInput = this.editor.getEditorInput();
        if (editorInput instanceof IFileEditorInput) {
            return ((IFileEditorInput)editorInput).getFile().getFullPath().toString();
        }
        return "";
    }
}

