/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.eglarpackager;

import org.eclipse.edt.ide.ui.internal.IUIHelpConstants;
import org.eclipse.edt.ide.ui.internal.eglarpackager.EglarPackageData;
import org.eclipse.edt.ide.ui.internal.eglarpackager.EglarPackagerMessages;
import org.eclipse.edt.ide.ui.internal.eglarpackager.IEglarPackageWizardPage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class EglarOptionsPage
extends WizardPage
implements IEglarPackageWizardPage {
    private EglarPackageData fEglarPackage;
    private Composite fTheGroup;
    private Label fVendorLabel;
    private Text fVendorText;
    private Label fVersionLabel;
    private Text fVersionText;
    private static final String PAGE_NAME = "EglarOptionsWizardPage";
    private static final String STORE_EXPORT_ARE_EXPORT_EGL_SRC = "EglarOptionsWizardPage.STORE_EXPORT_ARE_EXPORT_EGL_SRC";
    private static final String STORE_EXPORT_IS_EGLAR_GENERATABLE = "EglarOptionsWizardPage.EXPORT_IS_EGLAR_GENERATABLE";
    private static final String STORE_EXPORT_VENDOR = "EglarOptionsWizardPage.EXPORT_VENDOR";
    private static final String STORE_EXPORT_VERSION = "EglarOptionsWizardPage.EXPORT_VERSION";

    public EglarOptionsPage(EglarPackageData eglarPackage) {
        super(PAGE_NAME);
        this.setTitle(EglarPackagerMessages.EglarOptionsPage_title);
        this.setDescription(EglarPackagerMessages.EglarOptionsPage_description);
        this.fEglarPackage = eglarPackage;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(272));
        this.createOptionsGroup(composite);
        this.restoreWidgetValues();
        this.setControl((Control)composite);
        this.update();
        Dialog.applyDialogFont((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, IUIHelpConstants.EGLAR_OPTIONS_WIZARD_PAGE);
    }

    protected void createOptionsGroup(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite optionsGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        optionsGroup.setLayout((Layout)layout);
        this.createSpacer(optionsGroup);
        this.createDescriptionFileGroup(parent);
    }

    public final void saveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            settings.put(STORE_EXPORT_ARE_EXPORT_EGL_SRC, this.fEglarPackage.areEGLSrcFilesExported());
            settings.put(STORE_EXPORT_IS_EGLAR_GENERATABLE, this.fEglarPackage.isEglarGeneratable());
            settings.put(STORE_EXPORT_VENDOR, this.fEglarPackage.getVendorName());
            settings.put(STORE_EXPORT_VERSION, this.fEglarPackage.getVersionName());
        }
    }

    protected void restoreWidgetValues() {
        this.initializeJarPackage();
        this.fVendorText.setText(this.fEglarPackage.getVendorName());
        this.fVersionText.setText(this.fEglarPackage.getVersionName());
    }

    protected void initializeJarPackage() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            this.fEglarPackage.setExportEGLSrcFiles(settings.getBoolean(STORE_EXPORT_ARE_EXPORT_EGL_SRC));
            this.fEglarPackage.setEglarGeneratable(settings.getBoolean(STORE_EXPORT_IS_EGLAR_GENERATABLE));
            this.fEglarPackage.setVendorName(settings.get(STORE_EXPORT_VENDOR));
            this.fEglarPackage.setVersionName(settings.get(STORE_EXPORT_VERSION));
        }
    }

    private void update() {
        this.updateModel();
    }

    protected void updateModel() {
        if (this.getControl() == null) {
            return;
        }
        this.fEglarPackage.setExportEGLSrcFiles(false);
        this.fEglarPackage.setEglarGeneratable(true);
        this.fEglarPackage.setVendorName(this.fVendorText.getText());
        this.fEglarPackage.setVersionName(this.fVersionText.getText());
    }

    public boolean isPageComplete() {
        return true;
    }

    public boolean canFlipToNextPage() {
        return this.fEglarPackage.areGeneratedFilesExported() && super.canFlipToNextPage();
    }

    protected void createDescriptionFileGroup(Composite parent) {
        this.fTheGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this.fTheGroup.setLayout((Layout)layout);
        this.fTheGroup.setLayoutData((Object)new GridData(784));
        this.fVendorLabel = new Label(this.fTheGroup, 0);
        this.fVendorLabel.setText(EglarPackagerMessages.EglarOptionsPage_vendor_label);
        this.fVendorText = new Text(this.fTheGroup, 2052);
        this.fVendorText.addListener(24, (Listener)new UntypedListener());
        GridData data = new GridData(768);
        data.widthHint = this.convertWidthInCharsToPixels(40);
        this.fVendorText.setLayoutData((Object)data);
        this.fVersionLabel = new Label(this.fTheGroup, 0);
        this.fVersionLabel.setText(EglarPackagerMessages.EglarOptionsPage_version_label);
        this.fVersionText = new Text(this.fTheGroup, 2052);
        this.fVersionText.addListener(24, (Listener)new UntypedListener());
        data = new GridData(768);
        data.widthHint = this.convertWidthInCharsToPixels(20);
        this.fVersionText.setText("1.0");
        this.fVersionText.setLayoutData((Object)data);
    }

    @Override
    public void finish() {
        this.saveWidgetValues();
    }

    protected void createSpacer(Composite parent) {
        Label spacer = new Label(parent, 0);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        spacer.setLayoutData((Object)data);
    }

    private class UntypedListener
    implements Listener {
        private UntypedListener() {
        }

        public void handleEvent(Event e) {
            if (EglarOptionsPage.this.getControl() == null) {
                return;
            }
            EglarOptionsPage.this.update();
        }
    }
}

