/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.dialogs;

import java.util.List;
import org.eclipse.edt.ide.core.internal.search.PartInfo;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.model.IPart;
import org.eclipse.edt.ide.core.search.IEGLSearchScope;
import org.eclipse.edt.ide.core.search.SearchEngine;
import org.eclipse.edt.ide.ui.internal.IUIHelpConstants;
import org.eclipse.edt.ide.ui.internal.dialogs.PartSelectionDialog;
import org.eclipse.edt.ide.ui.internal.dialogs.StatusInfo;
import org.eclipse.edt.ide.ui.internal.wizards.NewWizardMessages;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.ListDialogField;
import org.eclipse.edt.ide.ui.wizards.InterfaceListConfiguration;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class InterfaceSelectionDialog
extends PartSelectionDialog {
    private static final int ADD_ID = 1025;
    protected ListDialogField fList;
    protected List fOldContent;
    private InterfaceListConfiguration fConfig;

    public InterfaceSelectionDialog(Shell parent, IRunnableContext context, ListDialogField list, int elemKind, String InterfaceSubType, InterfaceListConfiguration config, IEGLProject project) {
        super(parent, context, elemKind, InterfaceSubType, InterfaceSelectionDialog.createSearchScope(project));
        this.fList = list;
        this.fOldContent = this.fList.getElements();
        this.fConfig = config;
        this.setStatusLineAboveButtons(true);
        this.setFilter("*");
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1025, NewWizardMessages.EGLInterfaceSelectionDialogAddButtonLabel, true);
        super.createButtonsForButtonBar(parent);
    }

    protected void handleShellCloseEvent() {
        super.handleShellCloseEvent();
        this.reset2Original();
    }

    protected void cancelPressed() {
        this.reset2Original();
        super.cancelPressed();
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1025) {
            this.addSelectedPart();
        }
        super.buttonPressed(buttonId);
    }

    protected void okPressed() {
        this.addSelectedPart();
        super.okPressed();
    }

    protected void addSelectedPart() {
        Object ref = this.getLowerSelectedElement();
        if (ref instanceof PartInfo) {
            PartInfo partinfo = (PartInfo)ref;
            String qualifiedName = partinfo.getFullyQualifiedName();
            if (this.fList.getElements().contains(qualifiedName)) {
                String message = NewWizardMessages.bind((String)NewWizardMessages.EGLInterfaceSelectionDialogInterfaceDuplicateaddedInfo, (Object)qualifiedName);
                this.updateStatus(new StatusInfo(2, message));
            } else {
                this.fList.addElement(qualifiedName);
                IPart part = this.getPartFromPartInfo(partinfo);
                if (part != null) {
                    this.fConfig.addInterface(qualifiedName, part);
                }
                String message = NewWizardMessages.bind((String)NewWizardMessages.EGLInterfaceSelectionDialogInterfaceaddedInfo, (Object)qualifiedName);
                this.updateStatus(new StatusInfo(1, message));
            }
        }
    }

    protected void handleDefaultSelected() {
        if (this.validateCurrentSelection()) {
            this.buttonPressed(1025);
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newShell, IUIHelpConstants.PARTS_INTERFACE_SELECTION_DIALOG);
    }

    private static IEGLSearchScope createSearchScope(IEGLProject project) {
        return SearchEngine.createEGLSearchScope((IEGLElement[])new IEGLProject[]{project});
    }

    private void reset2Original() {
        this.fList.setElements(this.fOldContent);
    }
}

