/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.dataaccess.conversion.sqldb;

import java.io.File;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class DataToolsObjectsToEGLUtils {
    public static String getReplacedString(String value, Hashtable<String, String> variables) {
        StringBuffer res = new StringBuffer();
        StringTokenizer st = new StringTokenizer(value, "\\$", true);
        Pattern p = Pattern.compile("\\{.*\\}.*", 32);
        while (st.hasMoreTokens()) {
            String t = st.nextToken();
            if (t.equals("$")) {
                if (!st.hasMoreTokens()) continue;
                t = st.nextToken();
                if (p.matcher(t).matches()) {
                    String varName = t.substring(1, t.indexOf("}"));
                    String rep = variables.get(varName);
                    res.append(rep);
                    res.append(t.substring(t.indexOf("}") + 1));
                    continue;
                }
                res.append(t);
                continue;
            }
            res.append(t);
        }
        return res.toString();
    }

    public static void cleanTableVariable(Hashtable<String, String> variables) {
        variables.remove("searchMethodParamDef");
        variables.remove("searchMethodParam");
        variables.remove("searchRecordKeyAssign");
    }

    public static String getEGLFilePath(String packageName, String fileName) {
        String path = packageName.replace(".", File.separator);
        return String.valueOf(path) + File.separator + fileName + ".egl";
    }

    public static String getPackageName(String fullQualifiedFileName) {
        int lastIndex;
        if (fullQualifiedFileName.startsWith(File.separator)) {
            fullQualifiedFileName = fullQualifiedFileName.substring(1);
        }
        if ((lastIndex = fullQualifiedFileName.lastIndexOf(File.separator)) < 0) {
            return "";
        }
        return fullQualifiedFileName.substring(0, lastIndex).replace(File.separator, ".");
    }

    public static String getEGLFileName(String fullQualifiedFileName) {
        if (fullQualifiedFileName.startsWith(File.separator)) {
            fullQualifiedFileName = fullQualifiedFileName.substring(1);
        }
        int startIndex = fullQualifiedFileName.lastIndexOf(File.separator);
        int lastIndex = fullQualifiedFileName.lastIndexOf(".egl");
        if (startIndex < 0) {
            return fullQualifiedFileName.substring(0, lastIndex);
        }
        return fullQualifiedFileName.substring(startIndex + 1, lastIndex);
    }
}

