/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.contentassist.referencecompletion;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.edt.compiler.core.ast.AnnotationExpression;
import org.eclipse.edt.compiler.core.ast.Assignment;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.compiler.core.ast.SetValuesExpression;
import org.eclipse.edt.compiler.core.ast.SettingsBlock;
import org.eclipse.edt.ide.core.internal.errors.ParseStack;
import org.eclipse.edt.ide.ui.internal.contentassist.proposalhandlers.EGLFieldsFromAnnotationProposalHandler;
import org.eclipse.edt.ide.ui.internal.contentassist.referencecompletion.EGLAbstractReferenceCompletion;
import org.eclipse.edt.mof.egl.Annotation;
import org.eclipse.edt.mof.egl.AnnotationType;
import org.eclipse.edt.mof.egl.StereotypeType;
import org.eclipse.jface.text.ITextViewer;

public class EGLAnnotationFieldReferenceCompletion
extends EGLAbstractReferenceCompletion {
    @Override
    protected void precompileContexts() {
        this.addContext("package a; handler a {@a{");
        this.addContext("package a; handler a {@a{a=a,");
    }

    @Override
    protected List returnCompletionProposals(ParseStack parseStack, final String prefix, final ITextViewer viewer, final int documentOffset) {
        final ArrayList proposals = new ArrayList();
        this.getBoundASTNode(viewer, documentOffset, new String[]{"", "a};", "=a}", "=a};", ";", "};"}, new EGLAbstractReferenceCompletion.CompletedNodeVerifier(){

            @Override
            public boolean nodeIsValid(Node astNode) {
                return EGLAnnotationFieldReferenceCompletion.this.getAnnotation(astNode) != null;
            }
        }, new EGLAbstractReferenceCompletion.IBoundNodeProcessor(){

            @Override
            public void processBoundNode(Node boundNode) {
                AnnotationType annotationType;
                Annotation ann = EGLAnnotationFieldReferenceCompletion.this.getAnnotation(boundNode);
                if (ann != null && ((annotationType = (AnnotationType)ann.getEClass()) instanceof StereotypeType || annotationType.getEFields().size() > 1)) {
                    proposals.addAll(new EGLFieldsFromAnnotationProposalHandler(viewer, documentOffset, prefix, EGLAnnotationFieldReferenceCompletion.this.editor, this.getAnnotationFieldsAlreadySpecified(boundNode)).getProposals((AnnotationType)ann.getEClass()));
                }
            }

            private List<String> getAnnotationFieldsAlreadySpecified(Node node) {
                final ArrayList<String> list = new ArrayList<String>();
                while (node != null && !(node instanceof SettingsBlock)) {
                    node = node.getParent();
                }
                if (node != null) {
                    node.accept((IASTVisitor)new DefaultASTVisitor(){

                        public boolean visit(SettingsBlock settingsBlock) {
                            return true;
                        }

                        public boolean visit(Assignment assignment) {
                            if (assignment.resolveBinding() != null) {
                                list.add(assignment.getLeftHandSide().toString().toUpperCase().toLowerCase());
                            }
                            return false;
                        }
                    });
                }
                return list;
            }
        });
        return proposals;
    }

    public Annotation getAnnotation(Node node) {
        Part part;
        if (node == null) {
            return null;
        }
        if (node instanceof SetValuesExpression) {
            SetValuesExpression sve = (SetValuesExpression)node;
            if (sve.getExpression() instanceof AnnotationExpression) {
                return ((AnnotationExpression)sve.getExpression()).resolveAnnotation();
            }
            return null;
        }
        if (node instanceof SettingsBlock && node.getParent() instanceof Part && (part = (Part)node.getParent()).hasSubType()) {
            return (Annotation)part.getSubType().resolveElement();
        }
        return this.getAnnotation(node.getParent());
    }
}

