/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.contentassist.proposalhandlers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.internal.util.BindingUtil;
import org.eclipse.edt.ide.ui.internal.contentassist.EGLCompletionProposal;
import org.eclipse.edt.ide.ui.internal.contentassist.EGLProposalContextInformation;
import org.eclipse.edt.ide.ui.internal.contentassist.proposalhandlers.EGLAbstractProposalHandler;
import org.eclipse.edt.mof.egl.Constructor;
import org.eclipse.edt.mof.egl.Delegate;
import org.eclipse.edt.mof.egl.Element;
import org.eclipse.edt.mof.egl.Field;
import org.eclipse.edt.mof.egl.Function;
import org.eclipse.edt.mof.egl.FunctionParameter;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.jface.text.ITextViewer;

public class EGLFunctionSignatureProposalHandler
extends EGLAbstractProposalHandler {
    private Expression invocationTarget;

    public EGLFunctionSignatureProposalHandler(ITextViewer viewer, int documentOffset, Expression invocationTarget) {
        super(viewer, documentOffset, "");
        this.invocationTarget = invocationTarget;
    }

    public List getProposals() {
        ArrayList proposals = new ArrayList();
        Object obj = this.invocationTarget.getAttributeFromName(Name.OVERLOADED_FUNCTION_SET);
        if (obj != null && obj instanceof List) {
            List list = (List)obj;
            for (Object value : list) {
                this.addProposal(proposals, value);
            }
        } else {
            this.addProposal(proposals, this.invocationTarget.resolveMember());
        }
        return proposals;
    }

    private void addProposal(List proposals, Object obj) {
        Object proposal = this.createProposal(obj);
        if (proposal != null) {
            proposals.add(proposal);
        }
    }

    private Object createProposal(Object obj) {
        Type type;
        if (obj instanceof Function) {
            return this.createProposal((Function)obj);
        }
        if (obj instanceof Constructor) {
            Constructor constructor = (Constructor)obj;
            return this.createProposal("constructor", constructor.getParameters(), null, EGLFunctionSignatureProposalHandler.getNameFromElement((Element)constructor.getContainer()));
        }
        if (obj instanceof Field && (type = BindingUtil.getBaseType((Type)((Field)obj).getType())) instanceof Delegate) {
            Delegate delegate = (Delegate)type;
            return this.createProposal(delegate.getCaseSensitiveName(), delegate.getParameters(), delegate.getReturnType(), this.getPackageName((Part)delegate));
        }
        return null;
    }

    private Object createProposal(Function function) {
        return this.createProposal(function.getCaseSensitiveName(), function.getParameters(), function.getReturnType(), EGLFunctionSignatureProposalHandler.getNameFromElement((Element)function.getContainer()));
    }

    private Object createProposal(String funcName, List<FunctionParameter> parameters, Type returnType, String declarerName) {
        if (parameters == null || parameters.size() == 0) {
            return null;
        }
        String parameterList = this.getParameterListString(parameters);
        StringBuffer proposalSB = new StringBuffer();
        proposalSB.append(funcName);
        proposalSB.append("(");
        proposalSB.append(parameterList);
        proposalSB.append(")");
        if (returnType != null) {
            proposalSB.append(" ");
            proposalSB.append(EGLFunctionSignatureProposalHandler.getTypeString(returnType));
        }
        proposalSB.append(" - ");
        proposalSB.append(declarerName);
        EGLCompletionProposal completionProposal = new EGLCompletionProposal(this.viewer, proposalSB.toString(), "", null, this.getDocumentOffset() - this.getPrefix().length(), 0, 0, "");
        EGLProposalContextInformation contextInformation = new EGLProposalContextInformation(completionProposal, this.getLParenOffsetAfter(this.invocationTarget.getOffset()) + 1, proposalSB.toString(), parameterList);
        completionProposal.setContextInformation(contextInformation);
        return completionProposal;
    }
}

