/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.contentassist.proposalhandlers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.edt.compiler.core.ast.File;
import org.eclipse.edt.compiler.core.ast.NestedFunction;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.internal.util.BindingUtil;
import org.eclipse.edt.ide.core.internal.search.PartDeclarationInfo;
import org.eclipse.edt.ide.ui.internal.UINlsStrings;
import org.eclipse.edt.ide.ui.internal.contentassist.EGLCompletionProposal;
import org.eclipse.edt.ide.ui.internal.contentassist.proposalhandlers.EGLAbstractProposalHandler;
import org.eclipse.edt.mof.egl.AccessKind;
import org.eclipse.edt.mof.egl.Function;
import org.eclipse.edt.mof.egl.FunctionMember;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.ui.IEditorPart;

public class EGLFunctionMemberSearchProposalHandler
extends EGLAbstractProposalHandler {
    Node functionContainerPart;
    private Node functionPart;
    boolean addParens;

    public EGLFunctionMemberSearchProposalHandler(ITextViewer viewer, int documentOffset, String prefix, IEditorPart editor, boolean mustHaveReturnCode, Node boundNode) {
        this(viewer, documentOffset, prefix, editor, mustHaveReturnCode, boundNode, true);
    }

    public EGLFunctionMemberSearchProposalHandler(ITextViewer viewer, int documentOffset, String prefix, IEditorPart editor, boolean mustHaveReturnCode, Node boundNode, boolean addParens) {
        super(viewer, documentOffset, prefix, editor);
        this.addParens = addParens;
        while (!(boundNode instanceof File)) {
            if (boundNode instanceof NestedFunction) {
                this.functionPart = boundNode;
                this.functionContainerPart = boundNode.getParent();
            } else if (boundNode instanceof org.eclipse.edt.compiler.core.ast.Part) {
                this.functionContainerPart = boundNode;
            }
            boundNode = boundNode.getParent();
        }
    }

    protected List createProposals() {
        ArrayList proposals = new ArrayList();
        proposals.addAll(this.getNestedFunctionProposals());
        return proposals;
    }

    private boolean inStaticFunction() {
        if (this.functionPart != null) {
            return ((NestedFunction)this.functionPart).isStatic();
        }
        return false;
    }

    private List getNestedFunctionProposals() {
        ArrayList proposals = new ArrayList();
        if (this.functionContainerPart != null) {
            Part part = (Part)((org.eclipse.edt.compiler.core.ast.Part)this.functionContainerPart).getName().resolveType();
            List functions = BindingUtil.getAllFunctions((Type)part);
            ArrayList<String> sigs = new ArrayList<String>();
            for (Function function : functions) {
                String name;
                String sig;
                if (function.getAccessKind() == AccessKind.ACC_PRIVATE && function.getContainer() != part || sigs.contains(sig = this.getFunctionSignature(function))) continue;
                sigs.add(sig);
                if (!function.isStatic().booleanValue() && this.inStaticFunction() || !(name = function.getName()).toUpperCase().startsWith(this.getPrefix().toUpperCase())) continue;
                proposals.addAll(this.createFunctionInvocationProposals((FunctionMember)function, UINlsStrings.CAProposal_NestedFunction, 75, false));
            }
        }
        return proposals;
    }

    @Override
    protected String getProposalString(PartDeclarationInfo partDeclarationInfo, boolean includePackageName) {
        StringBuffer buffer = new StringBuffer(partDeclarationInfo.getPartName());
        if (this.addParens) {
            buffer.append("(");
            buffer.append(")");
        }
        return buffer.toString();
    }

    @Override
    protected List createFunctionInvocationProposals(FunctionMember function, String additionalInformation, int relevance, boolean addPrefix) {
        if (this.addParens) {
            return super.createFunctionInvocationProposals(function, additionalInformation, relevance, addPrefix);
        }
        ArrayList<EGLCompletionProposal> proposals = new ArrayList<EGLCompletionProposal>();
        String imgStr = function.getAccessKind() == AccessKind.ACC_PRIVATE ? "org.eclipse.edt.ide.ui.private_funct_obj.gif" : "org.eclipse.edt.ide.ui.funct_obj.gif";
        EGLCompletionProposal completionProposal = new EGLCompletionProposal(this.viewer, function.getCaseSensitiveName(), function.getCaseSensitiveName(), additionalInformation, this.getDocumentOffset() - this.getPrefix().length(), this.getPrefix().length(), function.getCaseSensitiveName().length(), relevance, 0, imgStr);
        proposals.add(completionProposal);
        return proposals;
    }

    public List getProposals() {
        return this.createProposals();
    }
}

