/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.contentassist.proposalhandlers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.edt.compiler.core.ast.ArrayLiteral;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.ide.ui.internal.contentassist.EGLCompletionProposal;
import org.eclipse.edt.ide.ui.internal.contentassist.proposalhandlers.EGLAbstractProposalHandler;
import org.eclipse.edt.ide.ui.internal.contentassist.proposalhandlers.EGLDeclarationProposalHandler;
import org.eclipse.edt.ide.ui.internal.contentassist.proposalhandlers.EGLFunctionMemberSearchProposalHandler;
import org.eclipse.edt.ide.ui.internal.contentassist.proposalhandlers.EGLVariableDotProposalHandler;
import org.eclipse.edt.mof.EClassifier;
import org.eclipse.edt.mof.EDataType;
import org.eclipse.edt.mof.EField;
import org.eclipse.edt.mof.EGenericType;
import org.eclipse.edt.mof.EType;
import org.eclipse.edt.mof.egl.AnnotationType;
import org.eclipse.edt.mof.egl.Enumeration;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.serialization.Environment;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.ui.IEditorPart;

public class EGLAnnotationValueProposalHandler
extends EGLAbstractProposalHandler {
    private static EType elistType;

    public EGLAnnotationValueProposalHandler(ITextViewer viewer, int documentOffset, String prefix, IEditorPart editor) {
        super(viewer, documentOffset, prefix, editor);
    }

    public List getProposals(EField field, Node boundNode) {
        return this.createProposals(field, boundNode);
    }

    private String getAdditionalInfo(EField field) {
        return "";
    }

    private List createProposals(EField field, Node boundNode) {
        EType eType = field.getEType();
        int dimDiff = this.getListDimensions(eType, 0) - this.getLiteralArrayDimensions(boundNode);
        if (dimDiff > 0) {
            String str = "";
            int i = 0;
            while (i < dimDiff) {
                str = String.valueOf(str) + "[";
                ++i;
            }
            i = 0;
            while (i < dimDiff) {
                str = String.valueOf(str) + "]";
                ++i;
            }
            ArrayList<EGLCompletionProposal> list = new ArrayList<EGLCompletionProposal>();
            list.add(new EGLCompletionProposal(this.viewer, str, str, this.getAdditionalInfo(field), this.getDocumentOffset() - this.getPrefix().length(), this.getPrefix().length(), dimDiff, 75, 0, null));
            return list;
        }
        if ((eType = this.getBaseType(eType)) instanceof Enumeration) {
            return new EGLVariableDotProposalHandler(this.viewer, this.getDocumentOffset(), this.getPrefix(), this.editor, (Type)((Enumeration)eType), false).getProposals(true);
        }
        if (eType.getETypeSignature().equalsIgnoreCase("org.eclipse.edt.mof.egl.FieldReference")) {
            return new EGLDeclarationProposalHandler(this.viewer, this.getDocumentOffset(), this.getPrefix(), boundNode).getProposals(boundNode);
        }
        if (eType.getETypeSignature().equalsIgnoreCase("org.eclipse.edt.mof.egl.FunctionReference")) {
            return new EGLFunctionMemberSearchProposalHandler(this.viewer, this.getDocumentOffset(), this.getPrefix(), this.editor, true, boundNode, false).getProposals();
        }
        if (eType.getETypeSignature().equalsIgnoreCase("org.eclipse.edt.mof.egl.MemberReference")) {
            ArrayList list = new ArrayList();
            list.addAll(new EGLDeclarationProposalHandler(this.viewer, this.getDocumentOffset(), this.getPrefix(), boundNode).getProposals(boundNode));
            list.addAll(new EGLFunctionMemberSearchProposalHandler(this.viewer, this.getDocumentOffset(), this.getPrefix(), this.editor, true, boundNode, false).getProposals());
            return list;
        }
        if (this.getPrefix().length() != 0) {
            return new ArrayList();
        }
        ProposalInfo info = this.getProposalInfo(eType);
        if (info != null) {
            ArrayList<EGLCompletionProposal> list = new ArrayList<EGLCompletionProposal>();
            list.add(new EGLCompletionProposal(this.viewer, info.proposalString, info.proposalString, this.getAdditionalInfo(field), this.getDocumentOffset() - this.getPrefix().length(), this.getPrefix().length(), info.cursorOffset, 75, info.highlightLen, null));
            return list;
        }
        return new ArrayList();
    }

    private ProposalInfo getProposalInfo(EType eType) {
        if (this.isGenericElistType(eType)) {
            EType currType = (EType)((EGenericType)eType).getETypeArguments().get(0);
            return this.getProposalInfo(currType);
        }
        if (eType instanceof EDataType) {
            String className = ((EDataType)eType).getJavaClassName();
            if (className.equals("java.lang.Object")) {
                return null;
            }
            if (className.equals("java.lang.String")) {
                ProposalInfo info = new ProposalInfo();
                info.proposalString = "\"\"";
                info.cursorOffset = 1;
                return info;
            }
            if (className.equals("java.lang.Boolean")) {
                ProposalInfo info = new ProposalInfo();
                info.proposalString = "yes";
                info.highlightLen = 3;
                return info;
            }
            if (className.equals("java.lang.Integer")) {
                ProposalInfo info = new ProposalInfo();
                info.proposalString = "0";
                info.highlightLen = 1;
                return info;
            }
            if (className.equals("java.lang.Float")) {
                ProposalInfo info = new ProposalInfo();
                info.proposalString = "0e0";
                info.highlightLen = 3;
                return info;
            }
            if (className.equals("java.math.BigDecimal")) {
                ProposalInfo info = new ProposalInfo();
                info.proposalString = "0.0";
                info.highlightLen = 3;
                return info;
            }
        }
        if (eType instanceof AnnotationType) {
            ProposalInfo info = new ProposalInfo();
            AnnotationType annotationType = (AnnotationType)eType;
            String str = "@" + annotationType.getCaseSensitiveName() + "{}";
            info.cursorOffset = str.length() - 1;
            info.proposalString = str;
            return info;
        }
        return null;
    }

    private int getLiteralArrayDimensions(Node node) {
        if (node != null && !(node instanceof ArrayLiteral)) {
            node = node.getParent();
        }
        int count = 0;
        while (node instanceof ArrayLiteral) {
            ++count;
            node = node.getParent();
        }
        return count;
    }

    private int getListDimensions(EType type, int dimCount) {
        if (this.isGenericElistType(type)) {
            EType currType = (EType)((EGenericType)type).getETypeArguments().get(0);
            return this.getListDimensions(currType, dimCount + 1);
        }
        return dimCount;
    }

    private EType getBaseType(EType type) {
        if (this.isGenericElistType(type)) {
            EType currType = (EType)((EGenericType)type).getETypeArguments().get(0);
            return this.getBaseType(currType);
        }
        return type;
    }

    private boolean isGenericElistType(EType type) {
        if (type instanceof EGenericType) {
            try {
                EType elistType = EGLAnnotationValueProposalHandler.getElistType();
                EClassifier eclassifier = ((EGenericType)type).getEClassifier();
                return elistType.equals(eclassifier);
            }
            catch (Exception exception) {}
        }
        return false;
    }

    private static EType getElistType() {
        if (elistType == null) {
            try {
                elistType = (EType)Environment.getCurrentEnv().findType("org.eclipse.edt.mof.EList");
            }
            catch (Exception exception) {}
        }
        return elistType;
    }

    private static class ProposalInfo {
        String proposalString;
        int cursorOffset;
        int highlightLen;

        private ProposalInfo() {
        }
    }
}

