/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.edt.ide.core.internal.model.util.EGLModelUtil;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.model.IPackageFragmentRoot;
import org.eclipse.edt.ide.ui.internal.EGLElementContainmentAdapter;
import org.eclipse.edt.ide.ui.internal.EGLElementProperties;
import org.eclipse.edt.ide.ui.internal.PersistableEGLElementFactory;
import org.eclipse.edt.ide.ui.internal.WorkbenchAdapter;
import org.eclipse.ui.IContainmentAdapter;
import org.eclipse.ui.IContributorResourceAdapter;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.views.properties.FilePropertySource;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.ResourcePropertySource;
import org.eclipse.ui.views.tasklist.ITaskListResourceAdapter;

public class EGLElementAdapterFactory
implements IAdapterFactory,
IContributorResourceAdapter {
    private static Class[] PROPERTIES = new Class[]{IPropertySource.class, IFile.class, IResource.class, IWorkbenchAdapter.class, IPersistableElement.class, IProject.class, IContributorResourceAdapter.class, ITaskListResourceAdapter.class, IContainmentAdapter.class};
    private static WorkbenchAdapter fgEGLWorkbenchAdapter = new WorkbenchAdapter();
    private static EGLElementContainmentAdapter fgEGLElementContainmentAdapter = new EGLElementContainmentAdapter();

    public Class[] getAdapterList() {
        return PROPERTIES;
    }

    public Object getAdapter(Object element, Class key) {
        IEGLElement egl = (IEGLElement)element;
        if (IPropertySource.class.equals((Object)key)) {
            return this.getProperties(egl);
        }
        if (IResource.class.equals((Object)key)) {
            return this.getResource(egl);
        }
        if (IProject.class.equals((Object)key)) {
            if (element instanceof IEGLProject) {
                return this.getProject(egl);
            }
            return null;
        }
        if (IFile.class.equals((Object)key)) {
            if (egl instanceof IEGLFile) {
                return EGLModelUtil.toOriginal((IEGLFile)((IEGLFile)egl)).getResource();
            }
            return null;
        }
        if (IWorkbenchAdapter.class.equals((Object)key)) {
            return fgEGLWorkbenchAdapter;
        }
        if (IPersistableElement.class.equals((Object)key)) {
            return new PersistableEGLElementFactory(egl);
        }
        if (IContributorResourceAdapter.class.equals((Object)key)) {
            return this;
        }
        if (IContainmentAdapter.class.equals((Object)key)) {
            return fgEGLElementContainmentAdapter;
        }
        return null;
    }

    private IResource getResource(IEGLElement element) {
        switch (element.getElementType()) {
            case 8: {
                IEGLElement parent = element.getParent();
                if (parent instanceof IEGLFile) {
                    return EGLModelUtil.toOriginal((IEGLFile)((IEGLFile)parent)).getResource();
                }
                return null;
            }
            case 6: {
                return EGLModelUtil.toOriginal((IEGLFile)((IEGLFile)element)).getResource();
            }
            case 4: 
            case 7: {
                IPackageFragmentRoot root = (IPackageFragmentRoot)element.getAncestor(3);
                if (!root.isArchive()) {
                    return element.getResource();
                }
                return null;
            }
            case 1: 
            case 2: 
            case 3: {
                return element.getResource();
            }
        }
        return null;
    }

    public IResource getAdaptedResource(IAdaptable adaptable) {
        return this.getResource((IEGLElement)adaptable);
    }

    private IResource getProject(IEGLElement element) {
        IEGLProject eglProject = element.getEGLProject();
        if (eglProject != null) {
            return eglProject.getProject();
        }
        return null;
    }

    private IPropertySource getProperties(IEGLElement element) {
        IResource resource = this.getResource(element);
        if (resource == null) {
            return new EGLElementProperties(element);
        }
        if (resource.getType() == 1) {
            return new FilePropertySource((IFile)resource);
        }
        return new ResourcePropertySource(resource);
    }
}

