/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.runtime.java.eglx.lang;

import eglx.lang.AnyException;
import eglx.lang.TypeCastException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.eclipse.edt.javart.AnyBoxedObject;
import org.eclipse.edt.javart.util.DateTimeUtil;
import org.eclipse.edt.javart.util.TimestampIntervalMask;
import org.eclipse.edt.runtime.java.eglx.lang.EAny;
import org.eclipse.edt.runtime.java.eglx.lang.EString;
import org.eclipse.edt.runtime.java.eglx.lang.ETimestamp;

public class ETime
extends AnyBoxedObject<Calendar> {
    private static final long serialVersionUID = 10L;

    public ETime() {
        this(DateTimeUtil.getNewCalendar());
    }

    public ETime(Calendar value) {
        super(value);
    }

    public static ETime ezeBox(Calendar value) {
        Calendar clone = null;
        if (value != null) {
            clone = (Calendar)value.clone();
        }
        return new ETime(clone);
    }

    public static Calendar ezeCast(Object value) throws AnyException {
        return (Calendar)EAny.ezeCast(value, "asTime", ETime.class, null, null);
    }

    public static boolean ezeIsa(Object value) {
        return value instanceof ETime && ((ETime)value).ezeUnbox() != null || value instanceof Calendar;
    }

    public String toString() {
        return EString.asString(EString.asStringTime((Calendar)this.object), new Integer[0]);
    }

    public static Calendar defaultValue() {
        long now = System.currentTimeMillis();
        Calendar cal = DateTimeUtil.getBaseCalendar();
        cal.setTimeInMillis(now);
        return cal;
    }

    public static Calendar asTime(EString time) throws TypeCastException {
        if (time == null) {
            return null;
        }
        return ETime.asTime((String)time.ezeUnbox());
    }

    public static Calendar asTime(String time) throws TypeCastException {
        if (time == null) {
            return null;
        }
        if (time.length() != 8 || time.charAt(2) != ':' || time.charAt(5) != ':') {
            TypeCastException tcx = new TypeCastException();
            tcx.actualTypeName = "string";
            tcx.castToName = "time";
            throw tcx.fillInMessage("EGL0007E", time, tcx.actualTypeName, tcx.castToName);
        }
        try {
            int hours = -1;
            char digit1 = time.charAt(0);
            char digit2 = time.charAt(1);
            if ('0' <= digit1 && digit1 <= '9' && '0' <= digit2 && digit2 <= '9') {
                hours = (digit1 - 48) * 10 + (digit2 - 48);
            }
            int minutes = -1;
            digit1 = time.charAt(3);
            digit2 = time.charAt(4);
            if ('0' <= digit1 && digit1 <= '9' && '0' <= digit2 && digit2 <= '9') {
                minutes = (digit1 - 48) * 10 + (digit2 - 48);
            }
            int seconds = -1;
            digit1 = time.charAt(6);
            digit2 = time.charAt(7);
            if ('0' <= digit1 && digit1 <= '9' && '0' <= digit2 && digit2 <= '9') {
                seconds = (digit1 - 48) * 10 + (digit2 - 48);
            }
            Calendar cal = DateTimeUtil.getBaseCalendar();
            cal.set(1, cal.get(1));
            cal.set(2, cal.get(2));
            cal.set(5, cal.get(5));
            cal.set(11, hours);
            cal.set(12, minutes);
            cal.set(13, seconds);
            cal.setTimeInMillis(cal.getTimeInMillis());
            return cal;
        }
        catch (Exception ex) {
            TypeCastException tcx = new TypeCastException();
            tcx.actualTypeName = "string";
            tcx.castToName = "time";
            tcx.initCause(ex);
            throw tcx.fillInMessage("EGL0007E", time, tcx.actualTypeName, tcx.castToName);
        }
    }

    public static Calendar asTime(ETime time) throws AnyException {
        if (time == null) {
            return null;
        }
        return ETime.asTime((Calendar)time.ezeUnbox());
    }

    public static Calendar asTime(ETimestamp time) throws AnyException {
        if (time == null) {
            return null;
        }
        return ETime.asTime((Calendar)time.ezeUnbox(), time.getStartCode(), time.getEndCode());
    }

    public static Calendar asTime(GregorianCalendar time) throws AnyException {
        if (time == null) {
            return null;
        }
        return ETime.asTime((Calendar)time);
    }

    public static Calendar asTime(Calendar time) throws AnyException {
        if (time == null) {
            return null;
        }
        return ETime.asTime(time, 3, 5);
    }

    public static Calendar asTime(Calendar original, int startCode, int endCode) {
        if (original == null) {
            return null;
        }
        if (startCode > 3 || endCode < 5) {
            TypeCastException tcx = new TypeCastException();
            tcx.actualTypeName = "timestamp(\"" + ETimestamp.createMask(startCode, endCode) + "\")";
            tcx.castToName = "time";
            throw tcx.fillInMessage("EGL0007E", original, tcx.actualTypeName, tcx.castToName);
        }
        Calendar cal = (Calendar)original.clone();
        Calendar result = DateTimeUtil.getBaseCalendar();
        result.set(11, cal.get(11));
        result.set(12, cal.get(12));
        result.set(13, cal.get(13));
        try {
            result.setTimeInMillis(result.getTimeInMillis());
        }
        catch (Exception ex) {
            TypeCastException tcx = new TypeCastException();
            tcx.actualTypeName = "timestamp(\"" + ETimestamp.createMask(startCode, endCode) + "\")";
            tcx.castToName = "time";
            tcx.initCause(ex);
            throw tcx.fillInMessage("EGL0007E", original, tcx.actualTypeName, tcx.castToName);
        }
        return result;
    }

    public static int compareTo(Calendar op1, Calendar op2) throws AnyException {
        return op1.compareTo(op2);
    }

    public static boolean equals(Calendar op1, Calendar op2) {
        if (op1 == op2) {
            return true;
        }
        if (op1 == null || op2 == null) {
            return false;
        }
        return op1.get(11) == op2.get(11) && op1.get(12) == op2.get(12) && op1.get(13) == op2.get(13);
    }

    public static boolean notEquals(Calendar op1, Calendar op2) {
        return !ETime.equals(op1, op2);
    }

    public static int hourOf(ETime aTime) {
        return ((Calendar)aTime.ezeUnbox()).get(11);
    }

    public static int minuteOf(ETime aTime) {
        return ((Calendar)aTime.ezeUnbox()).get(12);
    }

    public static int secondOf(ETime aTime) {
        return ((Calendar)aTime.ezeUnbox()).get(13);
    }

    public static Calendar extend(ETime aTime, String timeSpanPattern) throws AnyException {
        int startCode = 0;
        int endCode = 5;
        TimestampIntervalMask mask = new TimestampIntervalMask(timeSpanPattern);
        if (mask.getStartCode() != -1 && mask.getStartCode() <= mask.getEndCode()) {
            startCode = mask.getStartCode();
            endCode = mask.getEndCode();
        }
        return ETimestamp.asTimestamp(aTime, startCode, endCode);
    }
}

