/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.javart.util;

import eglx.lang.AnyException;
import org.eclipse.edt.javart.ByteStorage;
import org.eclipse.edt.javart.ConversionAttributeSet;
import org.eclipse.edt.javart.resources.Trace;

public class ByteFormatter {
    private ConversionAttributeSet attrs;
    private static final int MAX_DISPLAY_LEN = 1024;
    private static final int BYTE_LINE_LEN = 37;
    private static final int CHAR_LINE_LEN = 17;
    private static ByteStorage bs;

    private ByteFormatter(ConversionAttributeSet attrs) {
        this.attrs = attrs;
        bs = new ByteStorage(1);
    }

    private void print(byte[] bytes, StringBuilder line, int max) {
        int len;
        int n = len = bytes == null ? 0 : bytes.length;
        if (len > max) {
            len = max;
        }
        this.evalBytes(bytes, line, len);
    }

    private void evalBytes(byte[] bytes, StringBuilder line, int limit) {
        StringBuilder ebcdicBuf = new StringBuilder();
        StringBuilder asciiBuf = new StringBuilder();
        StringBuilder byteBuf = new StringBuilder();
        int i = 0;
        while (i < bytes.length && i < limit) {
            if (i % 16 == 0) {
                line.append(String.valueOf(ByteFormatter.getInt(i)) + " ");
                ebcdicBuf = new StringBuilder("'");
                asciiBuf = new StringBuilder("'");
                byteBuf = new StringBuilder();
            }
            byteBuf.append(ByteFormatter.getByte(bytes[i]));
            ByteFormatter.appendChar(bytes[i], asciiBuf, this.attrs);
            if ((i + 1) % 16 == 0) {
                this.endLine(line, ebcdicBuf, asciiBuf, byteBuf);
            } else if ((i + 1) % 4 == 0) {
                byteBuf.append(" ");
            }
            ++i;
        }
        if (byteBuf.length() < 37) {
            this.endLine(line, ebcdicBuf, asciiBuf, byteBuf);
        }
    }

    private void endLine(StringBuilder line, StringBuilder ebcdicBuf, StringBuilder asciiBuf, StringBuilder byteBuf) {
        if (byteBuf.length() < 37) {
            while (byteBuf.length() < 37) {
                byteBuf.append(' ');
            }
            while (asciiBuf.length() < 17) {
                asciiBuf.append(' ');
            }
            while (ebcdicBuf.length() < 17) {
                ebcdicBuf.append(' ');
            }
        }
        line.append((CharSequence)byteBuf);
        if (this.attrs != null) {
            line.append((CharSequence)asciiBuf);
            line.append("'  ");
        }
        line.append('\n');
    }

    private static String getInt(int i) {
        String retVal = "00000000" + Integer.toHexString(i).toUpperCase();
        return retVal.substring(retVal.length() - 8);
    }

    private static String getByte(byte b) {
        String retVal = "00" + Integer.toHexString(b).toUpperCase();
        return retVal.substring(retVal.length() - 2);
    }

    private static void appendChar(byte val, StringBuilder buf, ConversionAttributeSet attrs) {
        if (attrs != null) {
            char ch = ByteFormatter.getChar(val, attrs);
            if (Character.isISOControl(ch)) {
                ch = '.';
            }
            buf.append(ch);
        }
    }

    private static char getChar(byte val, ConversionAttributeSet attrs) {
        char ch = ' ';
        try {
            attrs.apply(bs);
            byte[] bytes = new byte[]{val};
            bs.reset(bytes);
            String strVal = bs.loadString(1, 1);
            if (strVal != null && strVal.length() > 0) {
                ch = strVal.charAt(0);
            }
        }
        catch (Exception exception) {}
        return ch;
    }

    public static void printBytes(byte[] bytes, String header, ConversionAttributeSet attrs) throws AnyException {
        if (bytes != null) {
            ByteFormatter bf = new ByteFormatter(attrs);
            StringBuilder buf = new StringBuilder();
            bf.print(bytes, buf, 1024);
            System.out.println(header);
            System.out.println(buf.toString());
        }
    }

    public static void traceBytes(byte[] bytes, int dumpSize, String header, ConversionAttributeSet attrs, Trace tracer) throws AnyException {
        if (bytes != null) {
            ByteFormatter bf = new ByteFormatter(attrs);
            StringBuilder buf = new StringBuilder();
            bf.print(bytes, buf, dumpSize);
            buf.insert(0, "\n");
            buf.insert(0, header);
            tracer.put(buf.toString());
        }
    }

    public static void traceBytes(byte[] bytes, String header, ConversionAttributeSet attrs, Trace tracer) throws AnyException {
        ByteFormatter.traceBytes(bytes, 1024, header, attrs, tracer);
    }

    public static void traceBytes(byte[] bytes, Trace tracer) throws AnyException {
        if (bytes != null) {
            ByteFormatter bf = new ByteFormatter(null);
            StringBuilder buf = new StringBuilder();
            bf.print(bytes, buf, 1024);
            buf.insert(0, "\n");
            tracer.put(buf.toString());
        }
    }
}

