/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.jtopen.wizards;

import java.util.HashMap;
import org.eclipse.edt.ide.jtopen.Messages;
import org.eclipse.edt.ide.jtopen.wizards.IBMiBindingConnectionConfiguration;
import org.eclipse.edt.ide.ui.internal.IUIHelpConstants;
import org.eclipse.edt.ide.ui.internal.wizards.EGLDDBindingWizardPage;
import org.eclipse.edt.ide.ui.internal.wizards.EGLPartWizard;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.DialogField;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.StringDialogField;
import org.eclipse.edt.ide.ui.wizards.BindingBaseConfiguration;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class IBMiBindingWizardPage
extends EGLDDBindingWizardPage {
    private StringDialogField fSystemField;
    private StringDialogField fUserIdField;
    private StringDialogField fPasswordField;
    private StringDialogField fLibraryField;
    private StringDialogField fTextEncodingField;
    private StringDialogField fTimezoneField;
    private StringDialogField fDateFormatField;
    private StringDialogField fDateSeparatorField;
    private StringDialogField fTimeFormatField;
    private StringDialogField fTimeSeparatorField;
    private static String storeSystemNameId = ".STORE_SYSTEM_NAME_ID";
    private static String storeUserIDNameId = ".STORE_USERID_NAME_ID";
    private static String storePasswordNameId = ".STORE_PASSWORD_NAME_ID";
    private static String storeLibraryNameId = ".STORE_LIBRARY_NAME_ID";
    private static String storeTextEncodingId = ".STORE_TEXT_ENCODING_ID";
    private static String storeTimezoneId = ".STORE_TIMEZONE_ID";
    private static String storeDateFormatId = ".STORE_DATE_FORMAT_ID";
    private static String storeDateSeparatorId = ".STORE_DATE_SEPARATOR_ID";
    private static String storeTimeFormatId = ".STORE_TIME_FORMAT_ID";
    private static String storeTimeSeparatorId = ".STORE_TIME_SEPARATOR_ID";
    private final String fStoreSystemNameId;
    private final String fStoreUserIDNameId;
    private final String fStorePasswordNameId;
    private final String fStoreLibraryNameId;
    private final String fStoreTextEncodingId;
    private final String fStoreTimezoneId;
    private final String fStoreDateFormatId;
    private final String fStoreDateSeparatorId;
    private final String fStoreTimeFormatId;
    private final String fStoreTimeSeparatorId;

    public IBMiBindingWizardPage(String pageName) {
        super(pageName);
        this.fStoreSystemNameId = String.valueOf(pageName) + storeSystemNameId;
        this.fStoreUserIDNameId = String.valueOf(pageName) + storeUserIDNameId;
        this.fStorePasswordNameId = String.valueOf(pageName) + storePasswordNameId;
        this.fStoreLibraryNameId = String.valueOf(pageName) + storeLibraryNameId;
        this.fStoreTextEncodingId = String.valueOf(pageName) + storeTextEncodingId;
        this.fStoreTimezoneId = String.valueOf(pageName) + storeTimezoneId;
        this.fStoreDateFormatId = String.valueOf(pageName) + storeDateFormatId;
        this.fStoreDateSeparatorId = String.valueOf(pageName) + storeDateSeparatorId;
        this.fStoreTimeFormatId = String.valueOf(pageName) + storeTimeFormatId;
        this.fStoreTimeSeparatorId = String.valueOf(pageName) + storeTimeSeparatorId;
        this.setTitle(Messages.TitleAddIBMiBinding);
        this.setDescription(Messages.DescAddIBMiBinding);
        this.nColumns = 4;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, IUIHelpConstants.MODULE_RESTBINDING);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = this.nColumns;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.createComponentNameControl(composite, Messages.LabelIBMiBindingName, this.getEGLDDBindingConfiguration().getConfiguration("edt.binding.ibmiconnection"));
        this.createSystemControl(composite);
        this.createUserIdControl(composite);
        this.createPasswordControl(composite);
        this.createLibraryControl(composite);
        this.createTextEncodingControl(composite);
        this.createTimezoneControl(composite);
        this.createDateFormatControl(composite);
        this.createDateSeparatorControl(composite);
        this.createTimeFormatControl(composite);
        this.createTimeSeparatorControl(composite);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)parent);
        this.determinePageCompletion();
    }

    private IBMiBindingConnectionConfiguration getConfiguration() {
        return (IBMiBindingConnectionConfiguration)((EGLPartWizard)this.getWizard()).getConfiguration(this.getName());
    }

    private void createSystemControl(Composite composite) {
        Label spacer = new Label(composite, 64);
        GridData gd = new GridData(768);
        gd.horizontalSpan = this.nColumns;
        spacer.setLayoutData((Object)gd);
        this.fSystemField = new StringDialogField();
        this.fSystemField.setLabelText(Messages.LabelSystem);
        this.fSystemField.setText(this.getStoredValue(this.fStoreSystemNameId));
        this.getConfiguration().setSystem(this.fSystemField.getText());
        this.createStringDialogField(composite, this.fSystemField, new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                if (field == IBMiBindingWizardPage.this.fSystemField) {
                    IBMiBindingWizardPage.this.HandleSystemFieldChanged();
                }
            }
        });
    }

    protected void HandleSystemFieldChanged() {
        this.getConfiguration().setSystem(this.fSystemField.getText());
        this.determinePageCompletion();
    }

    private void createUserIdControl(Composite composite) {
        this.fUserIdField = new StringDialogField();
        this.fUserIdField.setLabelText(Messages.LabelUserId);
        this.fUserIdField.setText(this.getStoredValue(this.fStoreUserIDNameId));
        this.getConfiguration().setUserId(this.fUserIdField.getText());
        this.createStringDialogField(composite, this.fUserIdField, new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                if (field == IBMiBindingWizardPage.this.fUserIdField) {
                    IBMiBindingWizardPage.this.HandleUserIdChanged();
                }
            }
        });
    }

    protected void HandleUserIdChanged() {
        this.getConfiguration().setUserId(this.fUserIdField.getText());
        this.determinePageCompletion();
    }

    private void createPasswordControl(Composite composite) {
        this.fPasswordField = new StringDialogField();
        this.fPasswordField.setLabelText(Messages.LabelPassword);
        this.fPasswordField.setText(this.getStoredValue(this.fStorePasswordNameId));
        this.getConfiguration().setPassword(this.fPasswordField.getText());
        this.createStringDialogField(composite, this.fPasswordField, new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                if (field == IBMiBindingWizardPage.this.fPasswordField) {
                    IBMiBindingWizardPage.this.HandlePasswordChanged();
                }
            }
        });
    }

    protected void HandlePasswordChanged() {
        this.getConfiguration().setPassword(this.fPasswordField.getText());
        this.determinePageCompletion();
    }

    private void createLibraryControl(Composite composite) {
        this.fLibraryField = new StringDialogField();
        this.fLibraryField.setLabelText(Messages.LabelLibrary);
        this.fLibraryField.setText(this.getStoredValue(this.fStoreLibraryNameId));
        this.getConfiguration().setLibrary(this.fLibraryField.getText());
        this.createStringDialogField(composite, this.fLibraryField, new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                if (field == IBMiBindingWizardPage.this.fLibraryField) {
                    IBMiBindingWizardPage.this.HandleLibraryChanged();
                }
            }
        });
    }

    protected void HandleLibraryChanged() {
        this.getConfiguration().setLibrary(this.fLibraryField.getText());
        this.determinePageCompletion();
    }

    private void createTextEncodingControl(Composite composite) {
        this.fTextEncodingField = new StringDialogField();
        this.fTextEncodingField.setLabelText(Messages.LabelTextEncoding);
        this.fTextEncodingField.setText(this.getStoredValue(this.fStoreTextEncodingId));
        this.getConfiguration().setTextEncoding(this.fTextEncodingField.getText());
        this.createStringDialogField(composite, this.fTextEncodingField, new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                if (field == IBMiBindingWizardPage.this.fTextEncodingField) {
                    IBMiBindingWizardPage.this.HandleTextEncodingChanged();
                }
            }
        });
    }

    protected void HandleTextEncodingChanged() {
        this.getConfiguration().setTextEncoding(this.fTextEncodingField.getText());
        this.determinePageCompletion();
    }

    private void createTimezoneControl(Composite composite) {
        this.fTimezoneField = new StringDialogField();
        this.fTimezoneField.setLabelText(Messages.LabelTimezone);
        this.fTimezoneField.setText(this.getStoredValue(this.fStoreTimezoneId));
        this.getConfiguration().setTimezone(this.fTimezoneField.getText());
        this.createStringDialogField(composite, this.fTimezoneField, new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                if (field == IBMiBindingWizardPage.this.fTimezoneField) {
                    IBMiBindingWizardPage.this.HandleTimezoneChanged();
                }
            }
        });
    }

    protected void HandleTimezoneChanged() {
        this.getConfiguration().setTimezone(this.fTimezoneField.getText());
        this.determinePageCompletion();
    }

    private void createDateFormatControl(Composite composite) {
        this.fDateFormatField = new StringDialogField();
        this.fDateFormatField.setLabelText(Messages.LabelDateFormat);
        this.fDateFormatField.setText(this.getStoredValue(this.fStoreDateFormatId));
        this.getConfiguration().setDateFormat(this.fDateFormatField.getText());
        this.createStringDialogField(composite, this.fDateFormatField, new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                if (field == IBMiBindingWizardPage.this.fDateFormatField) {
                    IBMiBindingWizardPage.this.HandleDateFormatChanged();
                }
            }
        });
    }

    protected void HandleDateFormatChanged() {
        this.getConfiguration().setDateFormat(this.fDateFormatField.getText());
        this.determinePageCompletion();
    }

    private void createDateSeparatorControl(Composite composite) {
        this.fDateSeparatorField = new StringDialogField();
        this.fDateSeparatorField.setLabelText(Messages.LabelDateSeparator);
        this.fDateSeparatorField.setText(this.getStoredValue(this.fStoreDateSeparatorId));
        this.getConfiguration().setDateSeparator(this.fDateSeparatorField.getText());
        this.createStringDialogField(composite, this.fDateSeparatorField, new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                if (field == IBMiBindingWizardPage.this.fDateSeparatorField) {
                    IBMiBindingWizardPage.this.HandleDateSeparatorChanged();
                }
            }
        });
        this.fDateSeparatorField.getTextControl().setTextLimit(1);
    }

    protected void HandleDateSeparatorChanged() {
        this.getConfiguration().setDateSeparator(this.fDateSeparatorField.getText());
        this.determinePageCompletion();
    }

    private void createTimeFormatControl(Composite composite) {
        this.fTimeFormatField = new StringDialogField();
        this.fTimeFormatField.setLabelText(Messages.LabelTimeFormat);
        this.fTimeFormatField.setText(this.getStoredValue(this.fStoreTimeFormatId));
        this.getConfiguration().setTimeFormat(this.fTimeFormatField.getText());
        this.createStringDialogField(composite, this.fTimeFormatField, new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                if (field == IBMiBindingWizardPage.this.fTimeFormatField) {
                    IBMiBindingWizardPage.this.HandleTimeFormatChanged();
                }
            }
        });
    }

    protected void HandleTimeFormatChanged() {
        this.getConfiguration().setTimeFormat(this.fTimeFormatField.getText());
        this.determinePageCompletion();
    }

    private void createTimeSeparatorControl(Composite composite) {
        this.fTimeSeparatorField = new StringDialogField();
        this.fTimeSeparatorField.setLabelText(Messages.LabelTimeSeparator);
        this.fTimeSeparatorField.setText(this.getStoredValue(this.fStoreTimeSeparatorId));
        this.getConfiguration().setTimeSeparator(this.fTimeSeparatorField.getText());
        this.createStringDialogField(composite, this.fTimeSeparatorField, new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                if (field == IBMiBindingWizardPage.this.fTimeSeparatorField) {
                    IBMiBindingWizardPage.this.HandleTimeSeparatorChanged();
                }
            }
        });
        this.fTimeSeparatorField.getTextControl().setTextLimit(1);
    }

    protected void HandleTimeSeparatorChanged() {
        this.getConfiguration().setTimeSeparator(this.fTimeSeparatorField.getText());
        this.determinePageCompletion();
    }

    protected void createComponentNameControl(Composite parent, String labelName, final BindingBaseConfiguration esConfig) {
        this.fNameField = new StringDialogField();
        this.fNameField.setLabelText(labelName);
        this.createStringDialogField(parent, this.fNameField, new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                if (field == IBMiBindingWizardPage.this.fNameField) {
                    IBMiBindingWizardPage.this.HandleBindingNameChanged(esConfig);
                }
            }
        });
    }

    protected void HandleBindingNameChanged(BindingBaseConfiguration esConfig) {
        super.HandleBindingNameChanged(esConfig);
        this.determinePageCompletion();
    }

    protected boolean determinePageCompletion() {
        this.setErrorMessage(null);
        boolean result = true;
        String name = this.fNameField.getText();
        String systemName = this.fSystemField.getText();
        String dateFormat = this.fDateFormatField.getText();
        String timeFormat = this.fTimeFormatField.getText();
        if (name == null || name.trim().length() == 0) {
            this.setErrorMessage(Messages.IBMiBindingBlankError);
            result = false;
        } else if (systemName == null || systemName.trim().length() == 0) {
            this.setErrorMessage(Messages.IBMiBindingSystemBlankError);
            result = false;
        } else if (dateFormat != null && dateFormat.trim().length() > 0 && !this.isValidInteger(dateFormat)) {
            this.setErrorMessage(Messages.IBMiBindingDateFormatError);
            result = false;
        } else if (timeFormat != null && timeFormat.trim().length() > 0 && !this.isValidInteger(timeFormat)) {
            this.setErrorMessage(Messages.IBMiBindingTimeFormatError);
            result = false;
        }
        this.setPageComplete(result);
        return result;
    }

    private boolean isValidInteger(String value) {
        try {
            Integer.decode(value);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public HashMap<String, String> getStoredKeyValues() {
        HashMap ret = super.getStoredKeyValues();
        ret.put(this.fStorePasswordNameId, this.fPasswordField.getText());
        ret.put(this.fStoreSystemNameId, this.fSystemField.getText());
        ret.put(this.fStoreUserIDNameId, this.fUserIdField.getText());
        ret.put(this.fStoreLibraryNameId, this.fLibraryField.getText());
        ret.put(this.fStoreTextEncodingId, this.fTextEncodingField.getText());
        ret.put(this.fStoreTimezoneId, this.fTimezoneField.getText());
        ret.put(this.fStoreDateFormatId, this.fDateFormatField.getText());
        ret.put(this.fStoreDateSeparatorId, this.fDateSeparatorField.getText());
        ret.put(this.fStoreTimeFormatId, this.fTimeFormatField.getText());
        ret.put(this.fStoreTimeSeparatorId, this.fTimeSeparatorField.getText());
        return ret;
    }

    private String getStoredValue(String key) {
        IDialogSettings dialogSettings = this.getDialogSettings();
        return dialogSettings.get(key) == null ? "" : dialogSettings.get(key);
    }
}

