/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.model;

import org.eclipse.edt.compiler.internal.core.utils.CharOperation;

public final class Signature {
    public static final char C_ARRAY = '[';
    public static final char C_BIGINT = 'A';
    public static final char C_BIN = 'B';
    public static final char C_BYTE = 'C';
    public static final char C_CHAR = 'D';
    public static final char C_DATE = 'E';
    public static final char C_DBCHAR = 'F';
    public static final char C_DECIMAL = 'G';
    public static final char C_DECIMALFLOAT = 'H';
    public static final char C_FLOAT = 'I';
    public static final char C_INT = 'J';
    public static final char C_INTERVAL = 'K';
    public static final char C_INTEGERDATE = 'L';
    public static final char C_MBCHAR = 'M';
    public static final char C_NUM = 'N';
    public static final char C_NUMBER = 'O';
    public static final char C_SMALLINT = 'P';
    public static final char C_TIME = 'Q';
    public static final char C_TIMESTAMP = 'R';
    public static final char C_UNICODE = 'S';
    public static final char C_VARCHAR = 'T';
    public static final char C_VARDBCHAR = 'U';
    public static final char C_VARMBCHAR = 'V';
    public static final char C_VARUNICODE = 'W';
    public static final char C_VOID = 'X';
    public static final char C_RESOLVED = 'Y';
    public static final char C_UNRESOLVED = 'Z';
    public static final char C_DOT = '.';
    public static final char C_SEMICOLON = ';';
    public static final char C_DOLLAR = '$';
    public static final char C_NAME_END = ';';
    public static final char C_PARAM_START = '(';
    public static final char C_PARAM_END = ')';
    public static final String SIG_ARRAY = "[";
    public static final String SIG_BIGINT = "A";
    public static final String SIG_BIN = "B";
    public static final String SIG_BYTE = "C";
    public static final String SIG_CHAR = "D";
    public static final String SIG_DATE = "E";
    public static final String SIG_DBCHAR = "F";
    public static final String SIG_DECIMAL = "G";
    public static final String SIG_DECIMALFLOAT = "H";
    public static final String SIG_FLOAT = "I";
    public static final String SIG_INT = "J";
    public static final String SIG_INTERVAL = "K";
    public static final String SIG_INTEGERDATE = "L";
    public static final String SIG_MBCHAR = "M";
    public static final String SIG_NUM = "N";
    public static final String SIG_NUMBER = "O";
    public static final String SIG_SMALLINT = "P";
    public static final String SIG_TIME = "Q";
    public static final String SIG_TIMESTAMP = "R";
    public static final String SIG_UNICODE = "S";
    public static final String SIG_VARCHAR = "T";
    public static final String SIG_VARDBCHAR = "U";
    public static final String SIG_VARMBCHAR = "V";
    public static final String SIG_VARUNICODE = "W";
    public static final String SIG_VOID = "X";
    public static final String SIG_RESOLVED = "Y";
    public static final String SIG_UNRESOLVED = "Z";
    public static final String SIG_DOT = ".";
    public static final String SIG_SEMICOLON = ";";
    public static final String SIG_DOLLAR = "$";
    public static final String SIG_NAME_END = ";";
    public static final String SIG_PARAM_START = "(";
    public static final String SIG_PARAM_END = ")";
    private static final String EMPTY = new String(CharOperation.NO_CHAR);
    private static final char[] BIGINT = new char[]{'b', 'i', 'g', 'i', 'n', 't'};
    private static final char[] BIN = new char[]{'b', 'i', 'n'};
    private static final char[] BYTE = new char[]{'b', 'y', 't', 'e'};
    private static final char[] CHAR = new char[]{'c', 'h', 'a', 'r'};
    private static final char[] DATE = new char[]{'d', 'a', 't', 'e'};
    private static final char[] DBCHAR = new char[]{'d', 'b', 'c', 'h', 'a', 'r'};
    private static final char[] DECIMAL = new char[]{'d', 'e', 'c', 'i', 'm', 'a', 'l'};
    private static final char[] DECIMALFLOAT = new char[]{'d', 'e', 'c', 'i', 'm', 'a', 'l', 'f', 'l', 'o', 'a', 't'};
    private static final char[] FLOAT = new char[]{'f', 'l', 'o', 'a', 't'};
    private static final char[] INT = new char[]{'i', 'n', 't'};
    private static final char[] INTERVAL = new char[]{'i', 'n', 't', 'e', 'r', 'v', 'a', 'l'};
    private static final char[] INTEGERDATE = new char[]{'i', 'n', 't', 'e', 'g', 'e', 'r', 'd', 'a', 't', 'e'};
    private static final char[] MBCHAR = new char[]{'m', 'b', 'c', 'h', 'a', 'r'};
    private static final char[] NUM = new char[]{'n', 'u', 'm'};
    private static final char[] NUMBER = new char[]{'n', 'u', 'm', 'b', 'e', 'r'};
    private static final char[] SMALLINT = new char[]{'s', 'm', 'a', 'l', 'l', 'i', 'n', 't'};
    private static final char[] TIME = new char[]{'t', 'i', 'm', 'e'};
    private static final char[] TIMESTAMP = new char[]{'t', 'i', 'm', 'e', 's', 't', 'a', 'm', 'p'};
    private static final char[] UNICODE = new char[]{'u', 'n', 'i', 'c', 'o', 'd', 'e'};
    private static final char[] VARCHAR = new char[]{'v', 'a', 'r', 'c', 'h', 'a', 'r'};
    private static final char[] VARDBCHAR = new char[]{'v', 'a', 'r', 'd', 'b', 'c', 'h', 'a', 'r'};
    private static final char[] VARMBCHAR = new char[]{'v', 'a', 'r', 'm', 'b', 'c', 'h', 'a', 'r'};
    private static final char[] VARUNICODE = new char[]{'u', 'n', 'i', 'c', 'o', 'd', 'e'};

    private Signature() {
    }

    /*
     * Unable to fully structure code
     */
    private static long copyType(char[] signature, int sigPos, char[] dest, int index, boolean fullyQualifyTypeNames) {
        arrayCount = 0;
        while (true) {
            switch (signature[sigPos++]) {
                case '[': {
                    ++arrayCount;
                    break;
                }
                case 'A': 
                case 'B': {
                    length = Signature.BIN.length;
                    System.arraycopy(Signature.BIN, 0, dest, index, length);
                    index += length;
                    ** GOTO lbl136
                }
                case 'C': {
                    length = Signature.BYTE.length;
                    System.arraycopy(Signature.BYTE, 0, dest, index, length);
                    index += length;
                    ** GOTO lbl136
                }
                case 'D': {
                    length = Signature.CHAR.length;
                    System.arraycopy(Signature.CHAR, 0, dest, index, length);
                    index += length;
                    ** GOTO lbl136
                }
                case 'E': {
                    length = Signature.DATE.length;
                    System.arraycopy(Signature.DATE, 0, dest, index, length);
                    index += length;
                    ** GOTO lbl136
                }
                case 'F': {
                    length = Signature.DBCHAR.length;
                    System.arraycopy(Signature.DBCHAR, 0, dest, index, length);
                    index += length;
                    ** GOTO lbl136
                }
                case 'G': {
                    length = Signature.DECIMAL.length;
                    System.arraycopy(Signature.DECIMAL, 0, dest, index, length);
                    index += length;
                    ** GOTO lbl136
                }
                case 'H': {
                    length = Signature.DECIMALFLOAT.length;
                    System.arraycopy(Signature.DECIMALFLOAT, 0, dest, index, length);
                    index += length;
                    ** GOTO lbl136
                }
                case 'I': {
                    length = Signature.FLOAT.length;
                    System.arraycopy(Signature.FLOAT, 0, dest, index, length);
                    index += length;
                    ** GOTO lbl136
                }
                case 'J': {
                    length = Signature.INT.length;
                    System.arraycopy(Signature.INT, 0, dest, index, length);
                    index += length;
                    ** GOTO lbl136
                }
                case 'K': {
                    length = Signature.INTERVAL.length;
                    System.arraycopy(Signature.INTERVAL, 0, dest, index, length);
                    index += length;
                    ** GOTO lbl136
                }
                case 'L': {
                    length = Signature.INT.length;
                    System.arraycopy(Signature.INTEGERDATE, 0, dest, index, length);
                    index += length;
                    ** GOTO lbl136
                }
                case 'M': {
                    length = Signature.MBCHAR.length;
                    System.arraycopy(Signature.MBCHAR, 0, dest, index, length);
                    index += length;
                    ** GOTO lbl136
                }
                case 'N': {
                    length = Signature.NUM.length;
                    System.arraycopy(Signature.NUM, 0, dest, index, length);
                    index += length;
                    ** GOTO lbl136
                }
                case 'O': {
                    length = Signature.NUMBER.length;
                    System.arraycopy(Signature.NUMBER, 0, dest, index, length);
                    index += length;
                    ** GOTO lbl136
                }
                case 'P': {
                    length = Signature.SMALLINT.length;
                    System.arraycopy(Signature.SMALLINT, 0, dest, index, length);
                    index += length;
                    ** GOTO lbl136
                }
                case 'Q': {
                    length = Signature.TIME.length;
                    System.arraycopy(Signature.TIME, 0, dest, index, length);
                    index += length;
                    ** GOTO lbl136
                }
                case 'R': {
                    length = Signature.TIMESTAMP.length;
                    System.arraycopy(Signature.TIMESTAMP, 0, dest, index, length);
                    index += length;
                    ** GOTO lbl136
                }
                case 'S': {
                    length = Signature.UNICODE.length;
                    System.arraycopy(Signature.UNICODE, 0, dest, index, length);
                    index += length;
                    ** GOTO lbl136
                }
                case 'T': {
                    length = Signature.VARCHAR.length;
                    System.arraycopy(Signature.VARCHAR, 0, dest, index, length);
                    index += length;
                    ** GOTO lbl136
                }
                case 'U': {
                    length = Signature.VARDBCHAR.length;
                    System.arraycopy(Signature.VARDBCHAR, 0, dest, index, length);
                    index += length;
                    ** GOTO lbl136
                }
                case 'V': {
                    length = Signature.VARMBCHAR.length;
                    System.arraycopy(Signature.VARMBCHAR, 0, dest, index, length);
                    index += length;
                    ** GOTO lbl136
                }
                case 'W': {
                    length = Signature.VARUNICODE.length;
                    System.arraycopy(Signature.VARUNICODE, 0, dest, index, length);
                    index += length;
                    ** GOTO lbl136
                }
                case 'Y': 
                case 'Z': {
                    end = CharOperation.indexOf((char)';', (char[])signature, (int)sigPos);
                    if (end == -1) {
                        throw new IllegalArgumentException();
                    }
                    if (fullyQualifyTypeNames) {
                        start = sigPos;
                    } else {
                        start = CharOperation.lastIndexOf((char)'.', (char[])signature, (int)sigPos, (int)end) + 1;
                        if (start == 0) {
                            start = sigPos;
                        }
                    }
                    length = end - start;
                    System.arraycopy(signature, start, dest, index, length);
                    sigPos = end + 1;
                    index += length;
                    if (true) ** GOTO lbl136
                }
            }
        }
        do {
            dest[index++] = 91;
            dest[index++] = 93;
lbl136:
            // 24 sources

        } while (arrayCount-- > 0);
        return ((long)index << 32) + (long)sigPos;
    }

    public static char[] createArraySignature(char[] typeSignature, int arrayCount) {
        if (arrayCount == 0) {
            return typeSignature;
        }
        int sigLength = typeSignature.length;
        char[] result = new char[arrayCount + sigLength];
        int i = 0;
        while (i < arrayCount) {
            result[i] = 91;
            ++i;
        }
        System.arraycopy(typeSignature, 0, result, arrayCount, sigLength);
        return result;
    }

    public static String createArraySignature(String typeSignature, int arrayCount) {
        return new String(Signature.createArraySignature(typeSignature.toCharArray(), arrayCount));
    }

    public static char[] createFunctionSignature(char[][] parameterTypes, char[] returnType) {
        int parameterTypesLength = parameterTypes.length;
        int parameterLength = 0;
        int i = 0;
        while (i < parameterTypesLength) {
            parameterLength += parameterTypes[i].length;
            ++i;
        }
        int returnTypeLength = returnType.length;
        char[] result = new char[1 + parameterLength + 1 + returnTypeLength];
        result[0] = 40;
        int index = 1;
        int i2 = 0;
        while (i2 < parameterTypesLength) {
            char[] parameterType = parameterTypes[i2];
            int length = parameterType.length;
            System.arraycopy(parameterType, 0, result, index, length);
            index += length;
            ++i2;
        }
        result[index] = 41;
        System.arraycopy(returnType, 0, result, index + 1, returnTypeLength);
        return result;
    }

    public static String createFunctionSignature(String[] parameterTypes, String returnType) {
        int parameterTypesLenth = parameterTypes.length;
        char[][] parameters = new char[parameterTypesLenth][];
        int i = 0;
        while (i < parameterTypesLenth) {
            parameters[i] = parameterTypes[i].toCharArray();
            ++i;
        }
        return new String(Signature.createFunctionSignature(parameters, returnType.toCharArray()));
    }

    public static String createTypeSignature(char[] typeName, boolean isResolved) {
        return typeName.length == 0 ? "" : new String(Signature.createCharArrayTypeSignature(typeName, isResolved));
    }

    public static char[] createCharArrayTypeSignature(char[] typeName, boolean isResolved) {
        char[] sig;
        if (typeName == null) {
            throw new IllegalArgumentException("null");
        }
        int length = typeName.length;
        if (length == 0) {
            throw new IllegalArgumentException(new String(typeName));
        }
        int arrayCount = CharOperation.occurencesOf((char)'[', (char[])typeName);
        switch (typeName[0]) {
            case 'b': {
                if (CharOperation.fragmentEquals((char[])BIGINT, (char[])typeName, (int)0, (boolean)false)) {
                    sig = new char[arrayCount + 1];
                    sig[arrayCount] = 65;
                    break;
                }
                if (CharOperation.fragmentEquals((char[])BYTE, (char[])typeName, (int)0, (boolean)false)) {
                    sig = new char[arrayCount + 1];
                    sig[arrayCount] = 67;
                    break;
                }
                if (CharOperation.fragmentEquals((char[])BIN, (char[])typeName, (int)0, (boolean)false)) {
                    sig = new char[arrayCount + 1];
                    sig[arrayCount] = 66;
                    break;
                }
            }
            case 'c': {
                if (CharOperation.fragmentEquals((char[])CHAR, (char[])typeName, (int)0, (boolean)false)) {
                    sig = new char[arrayCount + 1];
                    sig[arrayCount] = 68;
                    break;
                }
            }
            case 'd': {
                if (CharOperation.fragmentEquals((char[])DECIMALFLOAT, (char[])typeName, (int)0, (boolean)false)) {
                    sig = new char[arrayCount + 1];
                    sig[arrayCount] = 72;
                    break;
                }
                if (CharOperation.fragmentEquals((char[])DECIMAL, (char[])typeName, (int)0, (boolean)false)) {
                    sig = new char[arrayCount + 1];
                    sig[arrayCount] = 71;
                    break;
                }
                if (CharOperation.fragmentEquals((char[])DATE, (char[])typeName, (int)0, (boolean)false)) {
                    sig = new char[arrayCount + 1];
                    sig[arrayCount] = 69;
                    break;
                }
                if (CharOperation.fragmentEquals((char[])DBCHAR, (char[])typeName, (int)0, (boolean)false)) {
                    sig = new char[arrayCount + 1];
                    sig[arrayCount] = 70;
                    break;
                }
            }
            case 'f': {
                if (CharOperation.fragmentEquals((char[])FLOAT, (char[])typeName, (int)0, (boolean)false)) {
                    sig = new char[arrayCount + 1];
                    sig[arrayCount] = 73;
                    break;
                }
            }
            case 'i': {
                if (CharOperation.fragmentEquals((char[])INTEGERDATE, (char[])typeName, (int)0, (boolean)false)) {
                    sig = new char[arrayCount + 1];
                    sig[arrayCount] = 76;
                    break;
                }
                if (CharOperation.fragmentEquals((char[])INTERVAL, (char[])typeName, (int)0, (boolean)false)) {
                    sig = new char[arrayCount + 1];
                    sig[arrayCount] = 75;
                    break;
                }
                if (CharOperation.fragmentEquals((char[])INT, (char[])typeName, (int)0, (boolean)false)) {
                    sig = new char[arrayCount + 1];
                    sig[arrayCount] = 74;
                    break;
                }
            }
            case 'm': {
                if (CharOperation.fragmentEquals((char[])MBCHAR, (char[])typeName, (int)0, (boolean)false)) {
                    sig = new char[arrayCount + 1];
                    sig[arrayCount] = 77;
                    break;
                }
            }
            case 'n': {
                if (CharOperation.fragmentEquals((char[])NUM, (char[])typeName, (int)0, (boolean)false)) {
                    sig = new char[arrayCount + 1];
                    sig[arrayCount] = 78;
                    break;
                }
                if (CharOperation.fragmentEquals((char[])NUMBER, (char[])typeName, (int)0, (boolean)false)) {
                    sig = new char[arrayCount + 1];
                    sig[arrayCount] = 79;
                    break;
                }
            }
            case 's': {
                if (CharOperation.fragmentEquals((char[])SMALLINT, (char[])typeName, (int)0, (boolean)false)) {
                    sig = new char[arrayCount + 1];
                    sig[arrayCount] = 80;
                    break;
                }
            }
            case 't': {
                if (CharOperation.fragmentEquals((char[])TIME, (char[])typeName, (int)0, (boolean)false)) {
                    sig = new char[arrayCount + 1];
                    sig[arrayCount] = 81;
                    break;
                }
                if (CharOperation.fragmentEquals((char[])TIMESTAMP, (char[])typeName, (int)0, (boolean)false)) {
                    sig = new char[arrayCount + 1];
                    sig[arrayCount] = 82;
                    break;
                }
            }
            case 'u': {
                if (CharOperation.fragmentEquals((char[])UNICODE, (char[])typeName, (int)0, (boolean)false)) {
                    sig = new char[arrayCount + 1];
                    sig[arrayCount] = 83;
                    break;
                }
            }
            case 'v': {
                if (CharOperation.fragmentEquals((char[])VARCHAR, (char[])typeName, (int)0, (boolean)false)) {
                    sig = new char[arrayCount + 1];
                    sig[arrayCount] = 84;
                    break;
                }
                if (CharOperation.fragmentEquals((char[])VARDBCHAR, (char[])typeName, (int)0, (boolean)false)) {
                    sig = new char[arrayCount + 1];
                    sig[arrayCount] = 85;
                    break;
                }
                if (CharOperation.fragmentEquals((char[])VARUNICODE, (char[])typeName, (int)0, (boolean)false)) {
                    sig = new char[arrayCount + 1];
                    sig[arrayCount] = 87;
                    break;
                }
            }
            default: {
                int sigLength = arrayCount + 1 + length + 1;
                sig = new char[sigLength];
                int sigIndex = arrayCount + 1;
                int startID = 0;
                int index = 0;
                while (index < length) {
                    char currentChar = typeName[index];
                    switch (currentChar) {
                        case '.': {
                            if (startID == -1) {
                                throw new IllegalArgumentException(new String(typeName));
                            }
                            if (startID < index) {
                                sig = CharOperation.append((char[])sig, (int)sigIndex, (char[])typeName, (int)startID, (int)index);
                                sigIndex += index - startID;
                            }
                            sig[sigIndex++] = 46;
                            startID = ++index;
                            break;
                        }
                        case '[': {
                            if (startID != -1) {
                                if (startID < index) {
                                    sig = CharOperation.append((char[])sig, (int)sigIndex, (char[])typeName, (int)startID, (int)index);
                                    sigIndex += index - startID;
                                }
                                startID = -1;
                            }
                            ++index;
                            break;
                        }
                        default: {
                            if (startID != -1 && CharOperation.isWhitespace((char)currentChar)) {
                                if (startID < index) {
                                    sig = CharOperation.append((char[])sig, (int)sigIndex, (char[])typeName, (int)startID, (int)index);
                                    sigIndex += index - startID;
                                }
                                startID = index + 1;
                            }
                            ++index;
                        }
                    }
                }
                if (startID != -1 && startID < index) {
                    sig = CharOperation.append((char[])sig, (int)sigIndex, (char[])typeName, (int)startID, (int)index);
                    sigIndex += index - startID;
                }
                sig[arrayCount] = isResolved ? 89 : 90;
                sig[sigIndex++] = 59;
                if (sigLength <= sigIndex) break;
                char[] cArray = sig;
                sig = new char[sigIndex];
                System.arraycopy(cArray, 0, sig, 0, sigIndex);
            }
        }
        int i = 0;
        while (i < arrayCount) {
            sig[i] = 91;
            ++i;
        }
        return sig;
    }

    public static String createTypeSignature(String typeName, boolean isResolved) {
        return Signature.createTypeSignature(typeName == null ? null : typeName.toCharArray(), isResolved);
    }

    public static int getArrayCount(char[] typeSignature) throws IllegalArgumentException {
        try {
            int count = 0;
            while (typeSignature[count] == '[') {
                ++count;
            }
            return count;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException();
        }
    }

    public static int getArrayCount(String typeSignature) throws IllegalArgumentException {
        return Signature.getArrayCount(typeSignature.toCharArray());
    }

    public static char[] getElementType(char[] typeSignature) throws IllegalArgumentException {
        int count = Signature.getArrayCount(typeSignature);
        if (count == 0) {
            return typeSignature;
        }
        int length = typeSignature.length;
        char[] result = new char[length - count];
        System.arraycopy(typeSignature, count, result, 0, length - count);
        return result;
    }

    public static String getElementType(String typeSignature) throws IllegalArgumentException {
        return new String(Signature.getElementType(typeSignature.toCharArray()));
    }

    public static int getParameterCount(char[] methodSignature) throws IllegalArgumentException {
        try {
            int count = 0;
            int i = CharOperation.indexOf((char)'(', (char[])methodSignature) + 1;
            if (i == 0) {
                throw new IllegalArgumentException();
            }
            block8: while (true) {
                char c = methodSignature[i++];
                switch (c) {
                    case '[': {
                        continue block8;
                    }
                    case 'A': 
                    case 'B': 
                    case 'C': 
                    case 'D': 
                    case 'E': 
                    case 'F': 
                    case 'G': 
                    case 'H': 
                    case 'I': 
                    case 'J': 
                    case 'K': 
                    case 'L': 
                    case 'M': 
                    case 'N': 
                    case 'O': 
                    case 'P': 
                    case 'Q': 
                    case 'R': 
                    case 'S': 
                    case 'T': 
                    case 'U': 
                    case 'V': 
                    case 'W': {
                        ++count;
                        continue block8;
                    }
                    case 'Y': 
                    case 'Z': {
                        i = CharOperation.indexOf((char)';', (char[])methodSignature, (int)i) + 1;
                        if (i == 0) {
                            throw new IllegalArgumentException();
                        }
                        ++count;
                        continue block8;
                    }
                    case ')': {
                        return count;
                    }
                }
                break;
            }
            throw new IllegalArgumentException();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException();
        }
    }

    public static int getParameterCount(String methodSignature) throws IllegalArgumentException {
        return Signature.getParameterCount(methodSignature.toCharArray());
    }

    public static char[][] getParameterTypes(char[] methodSignature) throws IllegalArgumentException {
        try {
            int count = Signature.getParameterCount(methodSignature);
            char[][] result = new char[count][];
            if (count == 0) {
                return result;
            }
            int i = CharOperation.indexOf((char)'(', (char[])methodSignature) + 1;
            count = 0;
            int start = i;
            block33: while (true) {
                char c = methodSignature[i++];
                switch (c) {
                    case '[': {
                        continue block33;
                    }
                    case 'A': 
                    case 'B': 
                    case 'C': 
                    case 'D': 
                    case 'E': 
                    case 'F': 
                    case 'G': 
                    case 'H': 
                    case 'I': 
                    case 'J': 
                    case 'K': 
                    case 'L': 
                    case 'M': 
                    case 'N': 
                    case 'O': 
                    case 'P': 
                    case 'Q': 
                    case 'R': 
                    case 'S': 
                    case 'T': 
                    case 'U': 
                    case 'V': 
                    case 'W': {
                        if (i - start == 1) {
                            switch (c) {
                                case 'A': {
                                    result[count++] = new char[]{'A'};
                                    break;
                                }
                                case 'B': {
                                    result[count++] = new char[]{'B'};
                                    break;
                                }
                                case 'C': {
                                    result[count++] = new char[]{'C'};
                                    break;
                                }
                                case 'D': {
                                    result[count++] = new char[]{'D'};
                                    break;
                                }
                                case 'E': {
                                    result[count++] = new char[]{'E'};
                                    break;
                                }
                                case 'F': {
                                    result[count++] = new char[]{'F'};
                                    break;
                                }
                                case 'G': {
                                    result[count++] = new char[]{'G'};
                                    break;
                                }
                                case 'H': {
                                    result[count++] = new char[]{'H'};
                                    break;
                                }
                                case 'I': {
                                    result[count++] = new char[]{'I'};
                                    break;
                                }
                                case 'J': {
                                    result[count++] = new char[]{'J'};
                                    break;
                                }
                                case 'K': {
                                    result[count++] = new char[]{'K'};
                                    break;
                                }
                                case 'L': {
                                    result[count++] = new char[]{'L'};
                                    break;
                                }
                                case 'M': {
                                    result[count++] = new char[]{'M'};
                                    break;
                                }
                                case 'N': {
                                    result[count++] = new char[]{'N'};
                                    break;
                                }
                                case 'O': {
                                    result[count++] = new char[]{'O'};
                                    break;
                                }
                                case 'P': {
                                    result[count++] = new char[]{'P'};
                                    break;
                                }
                                case 'Q': {
                                    result[count++] = new char[]{'Q'};
                                    break;
                                }
                                case 'R': {
                                    result[count++] = new char[]{'R'};
                                    break;
                                }
                                case 'S': {
                                    result[count++] = new char[]{'S'};
                                    break;
                                }
                                case 'T': {
                                    result[count++] = new char[]{'T'};
                                    break;
                                }
                                case 'U': {
                                    result[count++] = new char[]{'U'};
                                    break;
                                }
                                case 'V': {
                                    result[count++] = new char[]{'V'};
                                    break;
                                }
                                case 'W': {
                                    result[count++] = new char[]{'W'};
                                }
                            }
                        } else {
                            result[count++] = CharOperation.subarray((char[])methodSignature, (int)start, (int)i);
                        }
                        start = i;
                        continue block33;
                    }
                    case 'Y': 
                    case 'Z': {
                        i = CharOperation.indexOf((char)';', (char[])methodSignature, (int)i) + 1;
                        if (i == 0) {
                            throw new IllegalArgumentException();
                        }
                        result[count++] = CharOperation.subarray((char[])methodSignature, (int)start, (int)i);
                        start = i;
                        continue block33;
                    }
                    case ')': {
                        return result;
                    }
                }
                break;
            }
            throw new IllegalArgumentException();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException();
        }
    }

    public static String[] getParameterTypes(String methodSignature) throws IllegalArgumentException {
        char[][] parameterTypes = Signature.getParameterTypes(methodSignature.toCharArray());
        int length = parameterTypes.length;
        String[] result = new String[length];
        int i = 0;
        while (i < length) {
            result[i] = new String(parameterTypes[i]);
            ++i;
        }
        return result;
    }

    public static char[] getQualifier(char[] name) {
        int lastDot = CharOperation.lastIndexOf((char)'.', (char[])name);
        if (lastDot == -1) {
            return CharOperation.NO_CHAR;
        }
        return CharOperation.subarray((char[])name, (int)0, (int)lastDot);
    }

    public static String getQualifier(String name) {
        int lastDot = name.lastIndexOf(46);
        if (lastDot == -1) {
            return EMPTY;
        }
        return name.substring(0, lastDot);
    }

    public static char[] getReturnType(char[] methodSignature) throws IllegalArgumentException {
        int i = CharOperation.lastIndexOf((char)')', (char[])methodSignature);
        if (i == -1) {
            throw new IllegalArgumentException();
        }
        return CharOperation.subarray((char[])methodSignature, (int)(i + 1), (int)methodSignature.length);
    }

    public static String getReturnType(String methodSignature) throws IllegalArgumentException {
        return new String(Signature.getReturnType(methodSignature.toCharArray()));
    }

    public static char[] getSimpleName(char[] name) {
        int lastDot = CharOperation.lastIndexOf((char)'.', (char[])name);
        if (lastDot == -1) {
            return name;
        }
        return CharOperation.subarray((char[])name, (int)(lastDot + 1), (int)name.length);
    }

    public static String getSimpleName(String name) {
        int lastDot = name.lastIndexOf(46);
        if (lastDot == -1) {
            return name;
        }
        return name.substring(lastDot + 1, name.length());
    }

    public static char[][] getSimpleNames(char[] name) {
        if (name.length == 0) {
            return CharOperation.NO_CHAR_CHAR;
        }
        int dot = CharOperation.indexOf((char)'.', (char[])name);
        if (dot == -1) {
            return new char[][]{name};
        }
        int n = 1;
        while ((dot = CharOperation.indexOf((char)'.', (char[])name, (int)(dot + 1))) != -1) {
            ++n;
        }
        char[][] result = new char[n + 1][];
        int segStart = 0;
        int i = 0;
        while (i < n) {
            dot = CharOperation.indexOf((char)'.', (char[])name, (int)segStart);
            result[i] = CharOperation.subarray((char[])name, (int)segStart, (int)dot);
            segStart = dot + 1;
            ++i;
        }
        result[n] = CharOperation.subarray((char[])name, (int)segStart, (int)name.length);
        return result;
    }

    public static String[] getSimpleNames(String name) {
        char[][] simpleNames = Signature.getSimpleNames(name.toCharArray());
        int length = simpleNames.length;
        String[] result = new String[length];
        int i = 0;
        while (i < length) {
            result[i] = new String(simpleNames[i]);
            ++i;
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static char[] toCharArray(char[] methodSignature, char[] methodName, char[][] parameterNames, boolean fullyQualifyTypeNames, boolean includeReturnType) {
        try {
            int firstParen = CharOperation.indexOf((char)'(', (char[])methodSignature);
            if (firstParen == -1) {
                throw new IllegalArgumentException();
            }
            int sigLength = methodSignature.length;
            int paramCount = 0;
            int lastParen = -1;
            int resultLength = 0;
            int i = firstParen;
            block31: while (i < sigLength) {
                block48: {
                    switch (methodSignature[i]) {
                        case '[': {
                            resultLength += 2;
                            break block48;
                        }
                        case 'A': {
                            resultLength += BIGINT.length;
                            break;
                        }
                        case 'B': {
                            resultLength += BIN.length;
                            break;
                        }
                        case 'C': {
                            resultLength += BYTE.length;
                            break;
                        }
                        case 'D': {
                            resultLength += CHAR.length;
                            break;
                        }
                        case 'E': {
                            resultLength += DATE.length;
                            break;
                        }
                        case 'F': {
                            resultLength += DBCHAR.length;
                            break;
                        }
                        case 'G': {
                            resultLength += DECIMAL.length;
                            break;
                        }
                        case 'H': {
                            resultLength += DECIMALFLOAT.length;
                            break;
                        }
                        case 'I': {
                            resultLength += FLOAT.length;
                            break;
                        }
                        case 'J': {
                            resultLength += INT.length;
                            break;
                        }
                        case 'K': {
                            resultLength += INTERVAL.length;
                            break;
                        }
                        case 'L': {
                            resultLength += INTEGERDATE.length;
                            break;
                        }
                        case 'M': {
                            resultLength += MBCHAR.length;
                            break;
                        }
                        case 'N': {
                            resultLength += NUM.length;
                            break;
                        }
                        case 'O': {
                            resultLength += NUMBER.length;
                            break;
                        }
                        case 'P': {
                            resultLength += SMALLINT.length;
                            break;
                        }
                        case 'Q': {
                            resultLength += TIME.length;
                            break;
                        }
                        case 'R': {
                            resultLength += TIMESTAMP.length;
                            break;
                        }
                        case 'S': {
                            resultLength += UNICODE.length;
                            break;
                        }
                        case 'T': {
                            resultLength += VARCHAR.length;
                            break;
                        }
                        case 'U': {
                            resultLength += VARDBCHAR.length;
                            break;
                        }
                        case 'V': {
                            resultLength += VARMBCHAR.length;
                            break;
                        }
                        case 'W': {
                            resultLength += VARUNICODE.length;
                            break;
                        }
                        case 'Y': 
                        case 'Z': {
                            int start;
                            int end = CharOperation.indexOf((char)';', (char[])methodSignature, (int)i);
                            if (end == -1) {
                                throw new IllegalArgumentException();
                            }
                            if (fullyQualifyTypeNames) {
                                start = i + 1;
                            } else {
                                start = CharOperation.lastIndexOf((char)'.', (char[])methodSignature, (int)i, (int)end) + 1;
                                if (start == 0) {
                                    start = i + 1;
                                }
                            }
                            resultLength += end - start;
                            i = end;
                            break;
                        }
                        case '(': {
                            ++resultLength;
                            break block48;
                        }
                        case ')': {
                            lastParen = i;
                            if (includeReturnType) {
                                if (paramCount > 0) {
                                    resultLength -= 2;
                                }
                                --paramCount;
                                break block48;
                            } else {
                                if (paramCount > 0) {
                                    --resultLength;
                                    break block31;
                                }
                                ++resultLength;
                                break block31;
                            }
                        }
                        default: {
                            throw new IllegalArgumentException();
                        }
                    }
                    resultLength += 2;
                    ++paramCount;
                }
                ++i;
            }
            int parameterNamesLength = parameterNames == null ? 0 : parameterNames.length;
            int i2 = 0;
            while (true) {
                block49: {
                    if (i2 < parameterNamesLength) break block49;
                }
                resultLength += parameterNames[i2].length + 1;
                ++i2;
            }
            int selectorLength = methodName == null ? 0 : methodName.length;
            char[] result = new char[resultLength += selectorLength];
            int index = 0;
            if (includeReturnType) {
                long pos = Signature.copyType(methodSignature, lastParen + 1, result, index, fullyQualifyTypeNames);
                index = (int)(pos >>> 32);
                result[index++] = 32;
            }
            if (methodName != null) {
                System.arraycopy(methodName, 0, result, index, selectorLength);
                index += selectorLength;
            }
            result[index++] = 40;
            int sigPos = firstParen + 1;
            int i3 = 0;
            while (true) {
                if (i3 >= paramCount) {
                    if (sigPos < sigLength) break;
                    throw new IllegalArgumentException();
                }
                long pos = Signature.copyType(methodSignature, sigPos, result, index, fullyQualifyTypeNames);
                index = (int)(pos >>> 32);
                sigPos = (int)pos;
                if (parameterNames != null) {
                    result[index++] = 32;
                    char[] parameterName = parameterNames[i3];
                    int paramLength = parameterName.length;
                    System.arraycopy(parameterName, 0, result, index, paramLength);
                    index += paramLength;
                }
                if (i3 != paramCount - 1) {
                    result[index++] = 44;
                    result[index++] = 32;
                }
                ++i3;
            }
            result[index++] = 41;
            return result;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException();
        }
    }

    public static char[] toCharArray(char[] signature) throws IllegalArgumentException {
        try {
            int sigLength = signature.length;
            if (sigLength == 0 || signature[0] == '(') {
                try {
                    return Signature.toCharArray(signature, CharOperation.NO_CHAR, null, true, true);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return new char[0];
                }
            }
            int resultLength = 0;
            int index = -1;
            while (signature[++index] == '[') {
                resultLength += 2;
            }
            switch (signature[index]) {
                case 'A': {
                    resultLength += BIGINT.length;
                    break;
                }
                case 'B': {
                    resultLength += BIN.length;
                    break;
                }
                case 'C': {
                    resultLength += BYTE.length;
                    break;
                }
                case 'D': {
                    resultLength += CHAR.length;
                    break;
                }
                case 'E': {
                    resultLength += DATE.length;
                    break;
                }
                case 'F': {
                    resultLength += DBCHAR.length;
                    break;
                }
                case 'G': {
                    resultLength += DECIMAL.length;
                    break;
                }
                case 'H': {
                    resultLength += DECIMALFLOAT.length;
                    break;
                }
                case 'I': {
                    resultLength += FLOAT.length;
                    break;
                }
                case 'J': {
                    resultLength += INT.length;
                    break;
                }
                case 'K': {
                    resultLength += INTERVAL.length;
                    break;
                }
                case 'L': {
                    resultLength += INTEGERDATE.length;
                    break;
                }
                case 'M': {
                    resultLength += MBCHAR.length;
                    break;
                }
                case 'N': {
                    resultLength += NUM.length;
                    break;
                }
                case 'O': {
                    resultLength += NUMBER.length;
                    break;
                }
                case 'P': {
                    resultLength += SMALLINT.length;
                    break;
                }
                case 'Q': {
                    resultLength += TIME.length;
                    break;
                }
                case 'R': {
                    resultLength += TIMESTAMP.length;
                    break;
                }
                case 'S': {
                    resultLength += UNICODE.length;
                    break;
                }
                case 'T': {
                    resultLength += VARCHAR.length;
                    break;
                }
                case 'U': {
                    resultLength += VARDBCHAR.length;
                    break;
                }
                case 'V': {
                    resultLength += VARMBCHAR.length;
                    break;
                }
                case 'W': {
                    resultLength += VARUNICODE.length;
                    break;
                }
                case 'Y': 
                case 'Z': {
                    int end = CharOperation.indexOf((char)';', (char[])signature, (int)index);
                    if (end == -1) {
                        throw new IllegalArgumentException();
                    }
                    int start = index + 1;
                    resultLength += end - start;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            char[] result = new char[resultLength];
            Signature.copyType(signature, 0, result, 0, true);
            return result;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException();
        }
    }

    public static char[] toQualifiedName(char[][] segments) {
        int length = segments.length;
        if (length == 0) {
            return CharOperation.NO_CHAR;
        }
        if (length == 1) {
            return segments[0];
        }
        int resultLength = 0;
        int i = 0;
        while (i < length) {
            resultLength += segments[i].length + 1;
            ++i;
        }
        char[] result = new char[--resultLength];
        int index = 0;
        int i2 = 0;
        while (i2 < length) {
            char[] segment = segments[i2];
            int segmentLength = segment.length;
            System.arraycopy(segment, 0, result, index, segmentLength);
            index += segmentLength;
            if (i2 != length - 1) {
                result[index++] = 46;
            }
            ++i2;
        }
        return result;
    }

    public static String toQualifiedName(String[] segments) {
        int length = segments.length;
        char[][] charArrays = new char[length][];
        int i = 0;
        while (i < length) {
            charArrays[i] = segments[i].toCharArray();
            ++i;
        }
        return new String(Signature.toQualifiedName(charArrays));
    }

    public static String toString(String signature) throws IllegalArgumentException {
        return new String(Signature.toCharArray(signature.toCharArray()));
    }

    public static String toString(String methodSignature, String methodName, String[] parameterNames, boolean fullyQualifyTypeNames, boolean includeReturnType) {
        char[][] params;
        if (parameterNames == null) {
            params = null;
        } else {
            int paramLength = parameterNames.length;
            params = new char[paramLength][];
            int i = 0;
            while (i < paramLength) {
                params[i] = parameterNames[i].toCharArray();
                ++i;
            }
        }
        return new String(Signature.toCharArray(methodSignature.toCharArray(), methodName == null ? null : methodName.toCharArray(), params, fullyQualifyTypeNames, includeReturnType));
    }
}

