/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.utils;

public class PatternMatcher {
    protected Stream pattern = null;
    private Stream comparator = null;
    private int state;
    private static final int STATE_BASE = 10;
    private static final int STATE_POUND = 20;
    private static final int STATE_ASTERISK = 30;
    private static final int STATE_NOTEQUAL = -1;
    protected static final int STATE_EQUAL = 0;
    private static final int STATE_COMPARE = 40;
    private static final String wildCards = "*#";

    public PatternMatcher() {
    }

    public PatternMatcher(String pattern) {
        this.pattern = new Stream(pattern);
    }

    private void checkState() {
        switch (this.state) {
            case 10: {
                this.stateBase();
                break;
            }
            case 40: {
                this.stateCompare();
                break;
            }
            case 20: {
                this.statePound();
                break;
            }
            case 30: {
                this.stateAsterisk();
            }
        }
    }

    protected int compareTo(String compareString) {
        this.pattern.reset();
        this.comparator = new Stream(compareString);
        this.state = 10;
        while (!this.done()) {
            this.checkState();
        }
        return this.state;
    }

    public boolean containsWildCards() {
        boolean found = false;
        this.pattern.reset();
        while (this.pattern.hasNext() && !found) {
            if (wildCards.indexOf(this.pattern.next()) < 0) continue;
            found = true;
        }
        this.pattern.reset();
        return found;
    }

    private boolean done() {
        return this.state == 0 || this.state == -1;
    }

    public boolean equals(String string) {
        return this.compareTo(string) == 0;
    }

    private void setPattern(String string) {
        this.pattern = new Stream(string);
    }

    private void stateAsterisk() {
        this.pattern.skip();
        if (this.pattern.hasNext()) {
            PatternMatcher newMatcher = new PatternMatcher(this.pattern.upToEnd());
            int compareValue = -1;
            Integer save = null;
            while (this.comparator.hasNext() && compareValue != 0) {
                compareValue = newMatcher.compareTo(this.comparator.peekToEnd());
                if (save == null) {
                    save = new Integer(compareValue);
                }
                this.comparator.skip();
            }
            this.state = compareValue == 0 ? 0 : (save == null ? compareValue : save);
        } else {
            this.state = 0;
        }
    }

    private void stateBase() {
        String next;
        this.state = !this.pattern.hasNext() ? (!this.comparator.hasNext() ? 0 : -1) : ((next = this.pattern.peek()).equals("#") ? 20 : (next.equals("*") ? 30 : 40));
    }

    private void stateCompare() {
        int result;
        this.state = this.comparator.hasNext() ? ((result = this.pattern.next().compareTo(this.comparator.next())) == 0 ? 10 : -1) : -1;
    }

    private void statePound() {
        if (this.comparator.hasNext()) {
            this.pattern.skip();
            this.comparator.skip();
            this.state = 10;
        } else {
            this.state = -1;
        }
    }

    public class Stream {
        private String string;
        private int index = 0;

        public Stream() {
        }

        public Stream(String string) {
            this.string = string == null ? "" : string;
        }

        public boolean hasNext() {
            return this.index < this.string.length();
        }

        public String next() {
            if (this.hasNext()) {
                ++this.index;
                return this.string.substring(this.index - 1, this.index);
            }
            return "";
        }

        public String peek() {
            if (this.hasNext()) {
                return this.string.substring(this.index, this.index + 1);
            }
            return "";
        }

        public String peekToEnd() {
            if (this.hasNext()) {
                return this.string.substring(this.index, this.string.length());
            }
            return "";
        }

        public String upToEnd() {
            if (this.hasNext()) {
                String toEnd = this.peekToEnd();
                this.index = this.string.length();
                return toEnd;
            }
            return "";
        }

        public void skip() {
            ++this.index;
        }

        public void reset() {
            this.index = 0;
        }
    }
}

