/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.search.matching;

import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.edt.ide.core.internal.model.index.IEntryResult;
import org.eclipse.edt.ide.core.internal.model.index.impl.IndexInput;
import org.eclipse.edt.ide.core.internal.search.IIndexSearchRequestor;
import org.eclipse.edt.ide.core.internal.search.matching.SearchPattern;
import org.eclipse.edt.ide.core.search.IEGLSearchScope;

public abstract class AndPattern
extends SearchPattern {
    public AndPattern(int matchMode, boolean isCaseSensitive) {
        super(matchMode, isCaseSensitive);
    }

    @Override
    public void findIndexMatches(IndexInput input, IIndexSearchRequestor requestor, int detailLevel, IProgressMonitor progressMonitor, IEGLSearchScope scope) throws IOException {
        IEntryResult[] entries;
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        long[] potentialRefs = null;
        int maxRefs = -1;
        this.resetQuery();
        while ((entries = input.queryEntriesPrefixedBy(this.indexEntryPrefix())) != null) {
            int numFiles = input.getNumFiles();
            long[] references = null;
            int referencesLength = -1;
            int i = 0;
            int max = entries.length;
            while (i < max) {
                if (progressMonitor != null && progressMonitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                IEntryResult entry = entries[i];
                this.decodeIndexEntry(entry);
                if (this.matchIndexEntry()) {
                    int[] fileReferences = entry.getFileReferences();
                    int j = 0;
                    int refLength = fileReferences.length;
                    while (j < refLength) {
                        int fileReference = fileReferences[j];
                        int vectorIndex = fileReference / 64;
                        if (references == null) {
                            referencesLength = numFiles / 64 + 1;
                            references = new long[referencesLength];
                        }
                        long mask = 1L << fileReference % 64;
                        int n = vectorIndex;
                        references[n] = references[n] | mask;
                        ++j;
                    }
                }
                ++i;
            }
            if (references == null) {
                return;
            }
            if (potentialRefs == null) {
                potentialRefs = references;
                maxRefs = numFiles;
            } else {
                i = 0;
                int length = references.length;
                while (i < length) {
                    if (i < potentialRefs.length) {
                        int n = i;
                        potentialRefs[n] = potentialRefs[n] & references[i];
                    } else {
                        potentialRefs[i] = 0L;
                    }
                    ++i;
                }
            }
            if (this.hasNextQuery()) continue;
        }
        if (potentialRefs != null) {
            int[] refs = new int[maxRefs];
            int refsLength = 0;
            int reference = 1;
            while (reference <= maxRefs) {
                int vectorIndex = reference / 64;
                if ((potentialRefs[vectorIndex] & 1L << reference % 64) != 0L) {
                    refs[refsLength++] = reference;
                }
                ++reference;
            }
            int[] nArray = refs;
            refs = new int[refsLength];
            System.arraycopy(nArray, 0, refs, 0, refsLength);
            this.feedIndexRequestor(requestor, detailLevel, refs, input, scope);
        }
    }

    protected abstract boolean hasNextQuery();

    protected abstract void resetQuery();
}

