/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model.indexing;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.CRC32;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.edt.compiler.internal.core.utils.CharOperation;
import org.eclipse.edt.ide.core.EDTCoreIDEPlugin;
import org.eclipse.edt.ide.core.internal.model.EGLModel;
import org.eclipse.edt.ide.core.internal.model.EGLModelManager;
import org.eclipse.edt.ide.core.internal.model.EGLProject;
import org.eclipse.edt.ide.core.internal.model.index.IIndex;
import org.eclipse.edt.ide.core.internal.model.index.impl.Index;
import org.eclipse.edt.ide.core.internal.model.indexing.AddEGLFileToIndex;
import org.eclipse.edt.ide.core.internal.model.indexing.AddEGLIRFileToIndex;
import org.eclipse.edt.ide.core.internal.model.indexing.AddEglarFileToIndex;
import org.eclipse.edt.ide.core.internal.model.indexing.AddFolderToIndex;
import org.eclipse.edt.ide.core.internal.model.indexing.EGLModelSearchResources;
import org.eclipse.edt.ide.core.internal.model.indexing.EGLReadWriteMonitor;
import org.eclipse.edt.ide.core.internal.model.indexing.IndexAllProject;
import org.eclipse.edt.ide.core.internal.model.indexing.IndexBinaryProject;
import org.eclipse.edt.ide.core.internal.model.indexing.IndexRequest;
import org.eclipse.edt.ide.core.internal.model.indexing.IndexSelector;
import org.eclipse.edt.ide.core.internal.model.indexing.RemoveFolderFromIndex;
import org.eclipse.edt.ide.core.internal.model.indexing.RemoveFromIndex;
import org.eclipse.edt.ide.core.internal.model.search.processing.IJob;
import org.eclipse.edt.ide.core.internal.model.search.processing.JobManager;
import org.eclipse.edt.ide.core.internal.model.util.SimpleLookupTable;
import org.eclipse.edt.ide.core.internal.model.util.Util;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLPathEntry;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.model.IIndexConstants;

public class IndexManager
extends JobManager
implements IIndexConstants {
    public static int MAX_FILES_IN_MEMORY = 0;
    public IWorkspace workspace;
    public SimpleLookupTable indexNames = new SimpleLookupTable();
    private Map indexes = new HashMap(5);
    private Map monitors = new HashMap(5);
    private boolean needToSave = false;
    private static final CRC32 checksumCalculator = new CRC32();
    private IPath eglPluginLocation = null;
    private SimpleLookupTable indexStates = null;
    private File savedIndexNamesFile = new File(this.getEGLPluginWorkingLocation().append("savedIndexNames.txt").toOSString());
    public static Integer SAVED_STATE = new Integer(0);
    public static Integer UPDATING_STATE = new Integer(1);
    public static Integer UNKNOWN_STATE = new Integer(2);
    public static Integer REBUILDING_STATE = new Integer(3);

    public synchronized void aboutToUpdateIndex(IPath path, Integer newIndexState) {
        Integer currentIndexState;
        String indexName = this.computeIndexName(path);
        Object state = this.getIndexStates().get(indexName);
        Integer n = currentIndexState = state == null ? UNKNOWN_STATE : (Integer)state;
        if (currentIndexState.equals(REBUILDING_STATE)) {
            return;
        }
        int compare = newIndexState.compareTo(currentIndexState);
        if (compare > 0) {
            this.updateIndexState(indexName, newIndexState);
        } else if (compare < 0 && this.indexes.get(path) == null) {
            this.rebuildIndex(indexName, path);
        }
    }

    public void addSource(IFile resource, IPath indexedContainer) {
        if (EDTCoreIDEPlugin.getPlugin() == null) {
            return;
        }
        AddEGLFileToIndex job = new AddEGLFileToIndex(resource, indexedContainer, this);
        if (this.awaitingJobsCount() < MAX_FILES_IN_MEMORY && !job.initializeContents()) {
            return;
        }
        this.request(job);
    }

    public void addIRSource(IFile resource, IPath indexedContainer) {
        if (EDTCoreIDEPlugin.getPlugin() == null) {
            return;
        }
        AddEGLIRFileToIndex job = new AddEGLIRFileToIndex(resource, indexedContainer, this);
        if (this.awaitingJobsCount() < MAX_FILES_IN_MEMORY && !job.initializeContents()) {
            return;
        }
        this.request(job);
    }

    String computeIndexName(IPath path) {
        String name = (String)this.indexNames.get(path);
        if (name == null) {
            String pathString = path.toOSString();
            checksumCalculator.reset();
            checksumCalculator.update(pathString.getBytes());
            String fileName = String.valueOf(Long.toString(checksumCalculator.getValue())) + ".index";
            if (VERBOSE) {
                JobManager.verbose("-> index name for " + pathString + " is " + fileName);
            }
            name = this.getEGLPluginWorkingLocation().append(fileName).toOSString();
            this.indexNames.put(path, name);
        }
        return name;
    }

    public synchronized IIndex getIndex(IPath path, boolean reuseExistingFile, boolean createIfMissing) {
        IIndex index = (IIndex)this.indexes.get(path);
        if (index == null) {
            Integer currentIndexState;
            String indexName = this.computeIndexName(path);
            Object state = this.getIndexStates().get(indexName);
            Integer n = currentIndexState = state == null ? UNKNOWN_STATE : (Integer)state;
            if (currentIndexState == UNKNOWN_STATE) {
                this.rebuildIndex(indexName, path);
                return null;
            }
            if (reuseExistingFile) {
                File indexFile = new File(indexName);
                if (indexFile.exists()) {
                    try {
                        index = new Index(indexName, "Index for " + path.toOSString(), true);
                        this.indexes.put(path, index);
                        this.monitors.put(index, new EGLReadWriteMonitor());
                        return index;
                    }
                    catch (IOException iOException) {
                        if (currentIndexState != REBUILDING_STATE) {
                            if (VERBOSE) {
                                JobManager.verbose("-> cannot reuse existing index: " + indexName + " path: " + path.toOSString());
                            }
                            this.rebuildIndex(indexName, path);
                            return null;
                        }
                        index = null;
                    }
                }
                if (currentIndexState == SAVED_STATE) {
                    this.rebuildIndex(indexName, path);
                    return null;
                }
            }
            if (createIfMissing) {
                try {
                    if (VERBOSE) {
                        JobManager.verbose("-> create empty index: " + indexName + " path: " + path.toOSString());
                    }
                    index = new Index(indexName, "Index for " + path.toOSString(), false);
                    this.indexes.put(path, index);
                    this.monitors.put(index, new EGLReadWriteMonitor());
                    return index;
                }
                catch (IOException iOException) {
                    if (VERBOSE) {
                        JobManager.verbose("-> unable to create empty index: " + indexName + " path: " + path.toOSString());
                    }
                    return null;
                }
            }
        }
        return index;
    }

    private SimpleLookupTable getIndexStates() {
        if (this.indexStates != null) {
            return this.indexStates;
        }
        this.indexStates = new SimpleLookupTable();
        char[] savedIndexNames = this.readIndexState();
        if (savedIndexNames.length > 0) {
            char[][] names = CharOperation.splitOn((char)'\n', (char[])savedIndexNames);
            int i = 0;
            int l = names.length;
            while (i < l) {
                char[] name = names[i];
                if (name.length > 0) {
                    this.indexStates.put(new String(name), SAVED_STATE);
                }
                ++i;
            }
        }
        return this.indexStates;
    }

    private IPath getEGLPluginWorkingLocation() {
        if (this.eglPluginLocation != null) {
            return this.eglPluginLocation;
        }
        this.eglPluginLocation = EDTCoreIDEPlugin.getPlugin().getStateLocation();
        return this.eglPluginLocation;
    }

    public EGLReadWriteMonitor getMonitorFor(IIndex index) {
        return (EGLReadWriteMonitor)this.monitors.get(index);
    }

    public void indexAll(IProject project) {
        this.indexAll(project, false);
    }

    public void indexAll(IProject project, boolean forceReIndex) {
        int i;
        if (EDTCoreIDEPlugin.getPlugin() == null) {
            return;
        }
        EGLModel model = EGLModelManager.getEGLModelManager().getEGLModel();
        IEGLProject eglProject = model.getEGLProject((IResource)project);
        try {
            IEGLPathEntry[] entries = eglProject.getResolvedEGLPath(true);
            i = 0;
            while (i < entries.length) {
                IEGLPathEntry entry = entries[i];
                if (entry.getEntryKind() == 1) {
                    this.indexLibrary(entry.getPath(), project);
                }
                ++i;
            }
        }
        catch (EGLModelException eGLModelException) {}
        IndexAllProject request = new IndexAllProject(project, this, forceReIndex);
        i = this.jobEnd;
        while (i > this.jobStart) {
            if (((Object)request).equals(this.awaitingJobs[i])) {
                return;
            }
            --i;
        }
        this.request(request);
    }

    public void indexLibrary(IPath path, IProject requestingProject) {
        if (EDTCoreIDEPlugin.getPlugin() == null) {
            return;
        }
        Object target = EGLModel.getTarget((IContainer)ResourcesPlugin.getWorkspace().getRoot(), path, true);
        AddEglarFileToIndex request = null;
        if (target instanceof IFile) {
            request = new AddEglarFileToIndex((IFile)target, this);
        } else if (target instanceof File) {
            request = new AddEglarFileToIndex(path, this, requestingProject);
        } else if (!(target instanceof IFolder)) {
            return;
        }
        int i = this.jobEnd;
        while (i > this.jobStart) {
            if (((Object)request).equals(this.awaitingJobs[i])) {
                return;
            }
            --i;
        }
        this.request(request);
    }

    public void indexBinaryProject(IPath path, IProject requestingProject) {
        if (EDTCoreIDEPlugin.getPlugin() == null) {
            return;
        }
        IndexBinaryProject request1 = new IndexBinaryProject(requestingProject, this);
        int i = this.jobEnd;
        while (i > this.jobStart) {
            if (request1.equals(this.awaitingJobs[i])) {
                return;
            }
            --i;
        }
        this.request(request1);
    }

    public void indexSourceFolder(EGLProject eglProject, IPath sourceFolder, char[][] exclusionPattern) {
        IProject project = eglProject.getProject();
        if (this.jobEnd > this.jobStart) {
            IndexAllProject request = new IndexAllProject(project, this);
            int i = this.jobEnd;
            while (i > this.jobStart) {
                if (((Object)request).equals(this.awaitingJobs[i])) {
                    return;
                }
                --i;
            }
        }
        this.request(new AddFolderToIndex(sourceFolder, project, exclusionPattern, this));
    }

    public void jobWasCancelled(IPath path) {
        Object o = this.indexes.get(path);
        if (o instanceof IIndex) {
            this.monitors.remove(o);
            this.indexes.remove(path);
        }
        this.updateIndexState(this.computeIndexName(path), UNKNOWN_STATE);
    }

    @Override
    protected synchronized void moveToNextJob() {
        this.needToSave = true;
        super.moveToNextJob();
    }

    @Override
    protected void notifyIdle(long idlingTime) {
        if (idlingTime > 1000L && this.needToSave) {
            this.saveIndexes();
        }
    }

    public IIndex peekAtIndex(IPath path) {
        return (IIndex)this.indexes.get(path);
    }

    @Override
    public String processName() {
        return EGLModelSearchResources.ProcessName;
    }

    private void rebuildIndex(String indexName, IPath path) {
        IResource resource;
        Object target = EGLModel.getTarget((IContainer)ResourcesPlugin.getWorkspace().getRoot(), path, true);
        if (target == null) {
            return;
        }
        if (VERBOSE) {
            JobManager.verbose("-> request to rebuild index: " + indexName + " path: " + path.toOSString());
        }
        this.updateIndexState(indexName, REBUILDING_STATE);
        IndexRequest request = null;
        if (target instanceof IProject) {
            IProject p = (IProject)target;
            EGLModel model = EGLModelManager.getEGLModelManager().getEGLModel();
            IEGLProject eglProject = model.getEGLProject((IResource)p);
            if (EGLProject.hasEGLNature(p) && !eglProject.isReadOnly()) {
                request = new IndexAllProject(p, this);
            }
        } else if (target instanceof IFile) {
            request = new AddEglarFileToIndex((IFile)target, this);
        } else if (target instanceof File && (resource = ResourcesPlugin.getWorkspace().getRoot().findMember(path)) != null) {
            request = new AddEglarFileToIndex(path, this, resource.getProject());
        }
        if (request != null) {
            this.request(request);
        }
    }

    public synchronized IIndex recreateIndex(IPath path) {
        try {
            IIndex index = (IIndex)this.indexes.get(path);
            EGLReadWriteMonitor monitor = (EGLReadWriteMonitor)this.monitors.remove(index);
            String indexPath = this.computeIndexName(path);
            if (VERBOSE) {
                JobManager.verbose("-> recreating index: " + indexPath + " for path: " + path.toOSString());
            }
            index = new Index(indexPath, "Index for " + path.toOSString(), false);
            this.indexes.put(path, index);
            this.monitors.put(index, monitor);
            return index;
        }
        catch (IOException e) {
            if (VERBOSE) {
                JobManager.verbose("-> failed to recreate index for path: " + path.toOSString());
                e.printStackTrace();
            }
            return null;
        }
    }

    public void remove(String resourceName, IPath indexedContainer) {
        this.request(new RemoveFromIndex(resourceName, indexedContainer, this));
    }

    public synchronized void removeIndex(IPath path) {
        Object o;
        String indexName;
        File indexFile;
        if (VERBOSE) {
            JobManager.verbose("removing index " + path);
        }
        if ((indexFile = new File(indexName = this.computeIndexName(path))).exists()) {
            indexFile.delete();
        }
        if ((o = this.indexes.get(path)) instanceof IIndex) {
            this.monitors.remove(o);
        }
        this.indexes.remove(path);
        this.updateIndexState(indexName, null);
    }

    public synchronized void removeIndexFamily(IPath path) {
        ArrayList<IPath> toRemove = null;
        for (IPath indexPath : this.indexes.keySet()) {
            if (!path.isPrefixOf(indexPath)) continue;
            if (toRemove == null) {
                toRemove = new ArrayList<IPath>();
            }
            toRemove.add(indexPath);
        }
        if (toRemove != null) {
            int i = 0;
            int length = toRemove.size();
            while (i < length) {
                this.removeIndex((IPath)toRemove.get(i));
                ++i;
            }
        }
    }

    public void removeSourceFolderFromIndex(EGLProject eglProject, IPath sourceFolder, char[][] exclusionPatterns) {
        IProject project = eglProject.getProject();
        if (this.jobEnd > this.jobStart) {
            IndexAllProject request = new IndexAllProject(project, this);
            int i = this.jobEnd;
            while (i > this.jobStart) {
                if (((Object)request).equals(this.awaitingJobs[i])) {
                    return;
                }
                --i;
            }
        }
        this.request(new RemoveFolderFromIndex(sourceFolder, exclusionPatterns, project, this));
    }

    @Override
    public void reset() {
        super.reset();
        if (this.indexes != null) {
            this.indexes = new HashMap(5);
            this.monitors = new HashMap(5);
            this.indexStates = null;
        }
        this.indexNames = new SimpleLookupTable();
        this.eglPluginLocation = null;
    }

    public void saveIndex(IIndex index) throws IOException {
        Object indexPath;
        if (index.hasChanged()) {
            if (VERBOSE) {
                JobManager.verbose("-> saving index " + index.getIndexFile());
            }
            index.save();
        }
        String indexName = index.getIndexFile().getPath();
        if (this.jobEnd > this.jobStart && (indexPath = this.indexNames.keyForValue(indexName)) != null) {
            int i = this.jobEnd;
            while (i > this.jobStart) {
                IJob job = this.awaitingJobs[i];
                if (job instanceof IndexRequest && ((IndexRequest)job).indexPath.equals(indexPath)) {
                    return;
                }
                --i;
            }
        }
        this.updateIndexState(indexName, SAVED_STATE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveIndexes() {
        ArrayList toSave = new ArrayList();
        IndexManager indexManager = this;
        synchronized (indexManager) {
            for (Object o : this.indexes.values()) {
                if (!(o instanceof IIndex)) continue;
                toSave.add(o);
            }
        }
        int i = 0;
        int length = toSave.size();
        while (i < length) {
            IIndex index = (IIndex)toSave.get(i);
            EGLReadWriteMonitor monitor = this.getMonitorFor(index);
            if (monitor != null) {
                try {
                    monitor.enterWrite();
                    try {
                        this.saveIndex(index);
                    }
                    catch (IOException e) {
                        if (VERBOSE) {
                            JobManager.verbose("-> got the following exception while saving:");
                            e.printStackTrace();
                        }
                    }
                }
                finally {
                    monitor.exitWrite();
                }
            }
            ++i;
        }
        this.needToSave = false;
    }

    private IPath[] getProjectPaths() {
        ArrayList<IPath> list = new ArrayList<IPath>();
        try {
            IEGLProject[] projects = EGLModelManager.getEGLModelManager().getEGLModel().getEGLProjects();
            int i = 0;
            int length = projects.length;
            while (i < length) {
                if (!projects[i].isBinary()) {
                    list.add(projects[i].getProject().getFullPath());
                }
                IEGLPathEntry[] entries = projects[i].getResolvedEGLPath(true);
                int j = 0;
                while (j < entries.length) {
                    IEGLPathEntry entry = entries[j];
                    if (entry.getEntryKind() == 1) {
                        list.add(entry.getPath());
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (EGLModelException eGLModelException) {}
        return list.toArray(new IPath[list.size()]);
    }

    @Override
    public void shutdown() {
        File[] indexesFiles;
        File indexesDirectory;
        if (VERBOSE) {
            JobManager.verbose("Shutdown");
        }
        IndexSelector indexSelector = new IndexSelector(this.getProjectPaths(), null, false, this);
        IIndex[] selectedIndexes = indexSelector.getIndexes();
        SimpleLookupTable knownPaths = new SimpleLookupTable();
        int i = 0;
        int max = selectedIndexes.length;
        while (i < max) {
            String path = selectedIndexes[i].getIndexFile().getAbsolutePath();
            knownPaths.put(path, path);
            ++i;
        }
        if (this.indexStates != null) {
            Object[] indexNames = this.indexStates.keyTable;
            int i2 = 0;
            int l = indexNames.length;
            while (i2 < l) {
                String key = (String)indexNames[i2];
                if (key != null && !knownPaths.containsKey(key)) {
                    this.updateIndexState(key, null);
                }
                ++i2;
            }
        }
        if ((indexesDirectory = new File(this.getEGLPluginWorkingLocation().toOSString())).isDirectory() && (indexesFiles = indexesDirectory.listFiles()) != null) {
            int i3 = 0;
            int indexesFilesLength = indexesFiles.length;
            while (i3 < indexesFilesLength) {
                String fileName = indexesFiles[i3].getAbsolutePath();
                if (!knownPaths.containsKey(fileName) && fileName.toLowerCase().endsWith(".index")) {
                    if (VERBOSE) {
                        JobManager.verbose("Deleting index file " + indexesFiles[i3]);
                    }
                    indexesFiles[i3].delete();
                }
                ++i3;
            }
        }
        super.shutdown();
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer(10);
        buffer.append(super.toString());
        buffer.append("In-memory indexes:\n");
        int count = 0;
        Iterator iter = this.indexes.values().iterator();
        while (iter.hasNext()) {
            buffer.append(++count).append(" - ").append(iter.next().toString()).append('\n');
        }
        return buffer.toString();
    }

    private char[] readIndexState() {
        try {
            return Util.getFileCharContent(this.savedIndexNamesFile, null);
        }
        catch (IOException iOException) {
            if (VERBOSE) {
                JobManager.verbose("Failed to read saved index file names");
            }
            return new char[0];
        }
    }

    private void updateIndexState(String indexName, Integer indexState) {
        block29: {
            this.getIndexStates();
            if (indexState != null) {
                if (indexState.equals(this.indexStates.get(indexName))) {
                    return;
                }
                this.indexStates.put(indexName, indexState);
            } else {
                if (!this.indexStates.containsKey(indexName)) {
                    return;
                }
                this.indexStates.removeKey(indexName);
            }
            BufferedWriter writer = null;
            try {
                try {
                    writer = new BufferedWriter(new FileWriter(this.savedIndexNamesFile));
                    Object[] indexNames = this.indexStates.keyTable;
                    Object[] states = this.indexStates.valueTable;
                    int i = 0;
                    int l = states.length;
                    while (i < l) {
                        if (states[i] == SAVED_STATE) {
                            writer.write((String)indexNames[i]);
                            writer.write(10);
                        }
                        ++i;
                    }
                }
                catch (IOException iOException) {
                    if (VERBOSE) {
                        JobManager.verbose("Failed to write saved index file names");
                    }
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    break block29;
                }
            }
            catch (Throwable throwable) {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (VERBOSE) {
            String state = "?";
            if (indexState == SAVED_STATE) {
                state = "SAVED";
            } else if (indexState == UPDATING_STATE) {
                state = "UPDATING";
            } else if (indexState == UNKNOWN_STATE) {
                state = "UNKNOWN";
            } else if (indexState == REBUILDING_STATE) {
                state = "REBUILDING";
            }
            JobManager.verbose("-> index state updated to: " + state + " for: " + indexName);
        }
    }
}

