/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model.document;

import java.io.IOException;
import java.io.Reader;
import org.eclipse.edt.ide.core.internal.model.document.EGLDocument;
import org.eclipse.jface.text.BadLocationException;

public class EGLDocumentReader
extends Reader {
    private EGLDocument document;
    private int length;
    private int next;

    public EGLDocumentReader(EGLDocument document) {
        this.document = document;
        this.length = document.getLength();
    }

    public EGLDocumentReader(EGLDocument document, int startOffset) {
        this.document = document;
        this.next = startOffset;
        this.length = document.getLength();
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        if (this.next >= this.length) {
            return -1;
        }
        int n = Math.min(this.length - this.next, len);
        try {
            this.document.get(this.next, n).getChars(0, n, cbuf, off);
        }
        catch (BadLocationException badLocationException) {
            throw new IOException();
        }
        this.next += n;
        return n;
    }

    @Override
    public int read() throws IOException {
        try {
            return this.next >= this.length ? -1 : (int)this.document.getChar(this.next++);
        }
        catch (BadLocationException badLocationException) {
            throw new IOException();
        }
    }

    @Override
    public void close() throws IOException {
    }
}

