/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.lookup;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.edt.compiler.internal.core.builder.BuildException;
import org.eclipse.edt.compiler.internal.core.lookup.IBuildPathEntry;
import org.eclipse.edt.ide.core.internal.model.EGLProject;
import org.eclipse.edt.ide.core.internal.model.EglarPackageFragmentRoot;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLModelMarker;
import org.eclipse.edt.ide.core.model.IEGLPathEntry;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.model.IPackageFragmentRoot;

public abstract class AbstractProjectBuildPath {
    protected IProject project;
    private Boolean readOnly;
    private Boolean binary;

    public AbstractProjectBuildPath(IProject project) {
        this.project = project;
    }

    public void updateEGLPath() {
        try {
            EGLProject eglProject = (EGLProject)EGLCore.create(this.project);
            eglProject.getExpandedEGLPath(true, true);
        }
        catch (EGLModelException e) {
            throw new BuildException((Throwable)((Object)e));
        }
    }

    public boolean isReadOnly() {
        if (this.readOnly == null) {
            IEGLProject eglProject = EGLCore.create(this.project);
            IContainer[] srcLocations = this.getSourceLocations();
            boolean hasSource = srcLocations != null && srcLocations.length > 0;
            this.readOnly = new Boolean(eglProject.isReadOnly() || !hasSource);
        }
        return this.readOnly;
    }

    public void clearReadOnly() {
        this.readOnly = null;
    }

    public boolean isBinary() {
        if (this.binary == null) {
            IEGLProject eglProject = EGLCore.create(this.project);
            this.binary = new Boolean(eglProject.isBinary());
        }
        return this.binary;
    }

    public IContainer getOutputLocation() {
        IProject outputContainer = null;
        IEGLProject eglProject = EGLCore.create(this.project);
        try {
            IPath outputLocation = eglProject.getOutputLocation();
            outputContainer = ResourcesPlugin.getWorkspace().getRoot().getFolder(outputLocation);
        }
        catch (EGLModelException eGLModelException) {
            outputContainer = eglProject.getProject();
        }
        return outputContainer;
    }

    public IContainer[] getSourceLocations() {
        try {
            IEGLProject eglProject = EGLCore.create(this.project);
            IPackageFragmentRoot[] packageFragmentRoots = eglProject.getPackageFragmentRoots();
            ArrayList<IContainer> sourceLocationsArr = new ArrayList<IContainer>();
            int i = 0;
            while (i < packageFragmentRoots.length) {
                if (!(packageFragmentRoots[i] instanceof EglarPackageFragmentRoot)) {
                    IContainer root = (IContainer)packageFragmentRoots[i].getResource();
                    sourceLocationsArr.add(root);
                }
                ++i;
            }
            IContainer[] sourceLocations = new IContainer[sourceLocationsArr.size()];
            sourceLocationsArr.toArray(sourceLocations);
            return sourceLocations;
        }
        catch (EGLModelException e) {
            throw new BuildException("Error initializing ProjectBuildPath:SourceLocations", (Throwable)((Object)e));
        }
    }

    private Object getProject(String projectName) {
        IProject newProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (newProject != null && newProject.exists()) {
            return newProject;
        }
        return newProject;
    }

    public IProject[] getRequiredProjects() {
        try {
            IEGLProject eglProject = EGLCore.create(this.project);
            String[] requiredProjectNames = eglProject.getRequiredProjectNames();
            ArrayList<Object> requiredProjects = new ArrayList<Object>();
            int i = 0;
            while (i < requiredProjectNames.length) {
                Object reqProject = this.getProject(requiredProjectNames[i]);
                if (!requiredProjects.contains(reqProject)) {
                    requiredProjects.add(reqProject);
                }
                ++i;
            }
            return requiredProjects.toArray(new IProject[requiredProjects.size()]);
        }
        catch (EGLModelException e) {
            throw new BuildException("Error initializing ProjectBuildPath:RequiredProjects", (Throwable)((Object)e));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isEGLPathBroken() {
        try {
            IMarker[] markers = this.project.findMarkers(IEGLModelMarker.BUILDPATH_PROBLEM_MARKER, false, 0);
            int i = 0;
            int l = markers.length;
            while (true) {
                if (i >= l) {
                    return false;
                }
                if ((Integer)markers[i].getAttribute("severity") == 2) {
                    return true;
                }
                ++i;
            }
        }
        catch (CoreException e) {
            throw new BuildException((Throwable)e);
        }
    }

    public boolean hasCycle() {
        try {
            IEGLProject eglProject = EGLCore.create(this.project);
            return eglProject.hasEGLPathCycle(eglProject.getResolvedEGLPath(true));
        }
        catch (EGLModelException e) {
            throw new BuildException((Throwable)((Object)e));
        }
    }

    public IProject[] getCycleParticipants() {
        try {
            IEGLProject eglProject = EGLCore.create(this.project);
            HashSet cycleParticipants = new HashSet();
            ((EGLProject)eglProject).updateCycleParticipants(eglProject.getResolvedEGLPath(true), new ArrayList(2), cycleParticipants, ResourcesPlugin.getWorkspace().getRoot(), new HashSet(2));
            IProject[] projects = new IProject[cycleParticipants.size()];
            Iterator iter = cycleParticipants.iterator();
            int i = 0;
            while (iter.hasNext()) {
                IPath path = (IPath)iter.next();
                IProject proj = ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(0));
                projects[i++] = proj;
            }
            return projects;
        }
        catch (EGLModelException e) {
            throw new BuildException((Throwable)((Object)e));
        }
    }

    public IProject getProject() {
        return this.project;
    }

    public String toString() {
        return this.project.getName();
    }

    public void clear() {
        this.readOnly = null;
        this.binary = null;
    }

    protected void initializeEGLPathEntriesHelper(List entries, Set visitedProjects, IProject project, Object requestingProject) {
        visitedProjects.add(project);
        IEGLProject eglProject = EGLCore.create(project);
        try {
            if (((IProject)eglProject.getResource()).isOpen()) {
                IEGLPathEntry[] resolvedEGLPath = eglProject.getResolvedEGLPath(true);
                int i = 0;
                while (i < resolvedEGLPath.length) {
                    IProject requiredProject;
                    IBuildPathEntry entry;
                    if (resolvedEGLPath[i].getEntryKind() == 3) {
                        entry = this.getProjectBuildPathEntry(project);
                        if (!entries.contains(entry)) {
                            entries.add(entry);
                        }
                    } else if (resolvedEGLPath[i].getEntryKind() == 1) {
                        if ((project == requestingProject || resolvedEGLPath[i].isExported()) && (entry = this.getZipFileBuildPathEntry(project, resolvedEGLPath[i].getPath())) != null) {
                            entries.add(entry);
                        }
                    } else if (resolvedEGLPath[i].getEntryKind() == 2 && (project == requestingProject || resolvedEGLPath[i].isExported()) && !visitedProjects.contains(requiredProject = ResourcesPlugin.getWorkspace().getRoot().getProject(resolvedEGLPath[i].getPath().toString()))) {
                        this.initializeEGLPathEntriesHelper(entries, visitedProjects, requiredProject, requestingProject);
                    }
                    ++i;
                }
            }
        }
        catch (EGLModelException e) {
            throw new BuildException((Throwable)((Object)e));
        }
    }

    protected abstract IBuildPathEntry getProjectBuildPathEntry(IProject var1);

    protected abstract IBuildPathEntry getZipFileBuildPathEntry(Object var1, IPath var2);
}

