/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.dependency;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.edt.ide.core.internal.dependency.DependentEntry;
import org.eclipse.edt.ide.core.internal.dependency.Part;

public class QualifiedNameDependentEntry
extends DependentEntry {
    private Set qualifiedNames = Collections.EMPTY_SET;

    public void addPart(Part part) {
        if (this.qualifiedNames == Collections.EMPTY_SET) {
            this.qualifiedNames = new HashSet();
        }
        this.qualifiedNames.add(part);
    }

    public Set getParts() {
        return this.qualifiedNames;
    }

    public void removePart(Part part) {
        this.qualifiedNames.remove(part);
    }

    @Override
    public boolean isEmpty() {
        return this.qualifiedNames.size() == 0;
    }

    @Override
    public void serialize(DataOutputStream outputStream) throws IOException {
        outputStream.writeInt(this.qualifiedNames.size());
        for (Part part : this.qualifiedNames) {
            part.serialize(outputStream);
        }
    }

    @Override
    public void deserialize(DataInputStream inputStream) throws IOException {
        int numQualifiedNames = inputStream.readInt();
        int i = 0;
        while (i < numQualifiedNames) {
            Part part = new Part();
            part.deserialize(inputStream);
            this.addPart(part);
            ++i;
        }
    }

    @Override
    public int getKind() {
        return 1;
    }
}

