/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.internal.preferences;

import org.eclipse.edt.ide.rui.internal.nls.Locale;
import org.eclipse.edt.ide.rui.internal.nls.LocaleUtility;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;

public class LocaleViewerSorter
extends ViewerSorter {
    public static final int CODE = 0;
    public static final int DESCRIPTION = 1;
    public static final int RUNTIME = 2;
    private int criteria;

    public LocaleViewerSorter(int criteria) {
        this.criteria = criteria;
    }

    public int compare(Viewer viewer, Object o1, Object o2) {
        Locale locale1 = (Locale)o1;
        Locale locale2 = (Locale)o2;
        switch (this.criteria) {
            case 1: {
                return this.compareDescriptions(locale1, locale2);
            }
            case 0: {
                return this.compareLocaleCodes(locale1, locale2);
            }
            case 2: {
                return this.compareRuntimeLocales(locale1, locale2);
            }
        }
        return 0;
    }

    private int compareDescriptions(Locale locale1, Locale locale2) {
        return this.getComparator().compare(locale1.getDescription(), locale2.getDescription());
    }

    private int compareLocaleCodes(Locale locale1, Locale locale2) {
        return this.getComparator().compare(locale1.getCode(), locale2.getCode());
    }

    private int compareRuntimeLocales(Locale locale1, Locale locale2) {
        String l1 = LocaleUtility.getRuntimeDescriptionForCode(locale1.getRuntimeLocaleCode());
        String l2 = LocaleUtility.getRuntimeDescriptionForCode(locale2.getRuntimeLocaleCode());
        return this.getComparator().compare(l1, l2);
    }
}

