/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.internal.preferences;

import org.eclipse.edt.ide.rui.internal.nls.Locale;
import org.eclipse.edt.ide.rui.internal.nls.LocaleUtility;
import org.eclipse.edt.ide.rui.internal.preferences.RUIPreferencePage;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.swt.widgets.TableItem;

public class CellModifier
implements ICellModifier {
    private RUIPreferencePage page;

    public CellModifier(RUIPreferencePage page) {
        this.page = page;
    }

    public boolean canModify(Object element, String property) {
        return true;
    }

    public Object getValue(Object element, String property) {
        int columnIndex = this.page.getColumnNames().indexOf(property);
        Object result = null;
        Locale locale = (Locale)element;
        switch (columnIndex) {
            case 0: {
                result = locale.getDescription();
                break;
            }
            case 1: {
                result = locale.getCode();
                break;
            }
            case 2: {
                String code = locale.getRuntimeLocaleCode();
                String stringValue = LocaleUtility.getRuntimeDescriptionForCode(code);
                String[] choices = LocaleUtility.getRuntimeDescriptionsArray();
                int i = choices.length - 1;
                while (!stringValue.equals(choices[i]) && i > 0) {
                    --i;
                }
                result = new Integer(i);
                break;
            }
            default: {
                result = "";
            }
        }
        return result;
    }

    public void modify(Object element, String property, Object value) {
        int columnIndex = this.page.getColumnNames().indexOf(property);
        TableItem item = (TableItem)element;
        Locale locale = (Locale)item.getData();
        switch (columnIndex) {
            case 0: {
                String valueString = ((String)value).trim();
                locale.setDescription(valueString);
                break;
            }
            case 1: {
                String valueString = ((String)value).trim();
                locale.setCode(valueString);
                break;
            }
            case 2: {
                String valueString = LocaleUtility.getRuntimeDescriptionsArray()[(Integer)value].trim();
                String currentDescription = LocaleUtility.getRuntimeDescriptionForCode(locale.getRuntimeLocaleCode());
                if (currentDescription.equals(valueString)) break;
                String newCode = LocaleUtility.getRuntimeCodeForDescription(valueString);
                locale.setRuntimeLocaleCode(newCode);
            }
        }
        this.page.getLocalesList().localeChanged(locale);
    }
}

