/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.document.utils;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.IField;
import org.eclipse.edt.ide.core.model.IFunction;
import org.eclipse.edt.ide.core.model.IPart;
import org.eclipse.edt.ide.rui.internal.Activator;
import org.eclipse.edt.ide.ui.internal.EGLUI;

public class NameGenerator {
    private final IFile currentFile;

    public NameGenerator(IFile currentFile) {
        this.currentFile = currentFile;
    }

    public String generateFieldName(String type) {
        String fieldName = null;
        try {
            IEGLFile modelFile = (IEGLFile)EGLCore.create((IFile)this.currentFile);
            IEGLFile sharedWorkingCopy = (IEGLFile)modelFile.getSharedWorkingCopy(null, EGLUI.getBufferFactory(), null);
            sharedWorkingCopy.reconcile(false, null);
            try {
                try {
                    String partName = new Path(this.currentFile.getName()).removeFileExtension().toString();
                    IPart modelPart = sharedWorkingCopy.getPart(partName);
                    fieldName = this.doGenerateFieldName(modelPart, type);
                }
                catch (Exception e) {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.edt.ide.rui", "Field Name Generator: Error generating field name", (Throwable)e));
                    sharedWorkingCopy.destroy();
                }
            }
            finally {
                sharedWorkingCopy.destroy();
            }
        }
        catch (Exception e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.edt.ide.rui", "Field Name Generator: Error creating working copy", (Throwable)e));
        }
        return fieldName;
    }

    private String doGenerateFieldName(IPart modelPart, String type) throws EGLModelException {
        int i = 0;
        String tempName = type;
        while (this.hasField(modelPart, tempName) || this.hasFunction(modelPart, tempName)) {
            tempName = String.valueOf(type) + ++i;
        }
        return tempName;
    }

    private boolean hasField(IPart part, String name) throws EGLModelException {
        boolean foundDuplicate = false;
        IField[] fields = part.getFields();
        int i = 0;
        while (i < fields.length) {
            IField field = fields[i];
            if (field.getElementName().equalsIgnoreCase(name)) {
                foundDuplicate = true;
                break;
            }
            ++i;
        }
        return foundDuplicate;
    }

    private boolean hasFunction(IPart part, String name) throws EGLModelException {
        boolean foundDuplicate = false;
        IFunction[] functions = part.getFunctions();
        int i = 0;
        while (i < functions.length) {
            IFunction function = functions[i];
            if (function.getElementName().equalsIgnoreCase(name)) {
                foundDuplicate = true;
                break;
            }
            ++i;
        }
        return foundDuplicate;
    }
}

