/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.gen.eunit;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.edt.compiler.ICompiler;
import org.eclipse.edt.compiler.ZipFileBindingBuildPathEntry;
import org.eclipse.edt.compiler.internal.interfaces.IGenerationMessageRequestor;
import org.eclipse.edt.compiler.tools.IRUtils;
import org.eclipse.edt.gen.AbstractGeneratorCommand;
import org.eclipse.edt.gen.EGLMessages.AccumulatingGenerationMessageRequestor;
import org.eclipse.edt.gen.eunit.EUnitDriverGenerator;
import org.eclipse.edt.gen.eunit.EUnitGenerator;
import org.eclipse.edt.gen.eunit.EUnitRunAllDriverGenerator;
import org.eclipse.edt.gen.eunit.GenPartsXMLFile;
import org.eclipse.edt.gen.eunit.IEUnitGenerationNotifier;
import org.eclipse.edt.gen.eunit.TestCounter;
import org.eclipse.edt.mof.egl.lookup.PartEnvironment;
import org.eclipse.edt.mof.serialization.Environment;
import org.eclipse.edt.mof.serialization.IEnvironment;

public abstract class EGL2Base
extends AbstractGeneratorCommand {
    public static final String ARG_PARM_GENPARTS = "genParts";
    protected List<String> generatedLibs = new ArrayList<String>();
    protected TestCounter totalCnts = new TestCounter();

    protected abstract EUnitDriverGenerator getEckDriverGenerator(AbstractGeneratorCommand var1, IGenerationMessageRequestor var2, IEUnitGenerationNotifier var3);

    protected abstract EUnitRunAllDriverGenerator getEckRunAllDriverGenerator(AbstractGeneratorCommand var1, IGenerationMessageRequestor var2, IEUnitGenerationNotifier var3);

    public void generateRunAllDriver(String[] args, EUnitRunAllDriverGenerator allDriverGenerator, List<String> genedLibs, TestCounter totalCnts) {
        allDriverGenerator.generateRunAllDriver(genedLibs, totalCnts);
        try {
            if (allDriverGenerator.getResult().length() > 0) {
                this.writeFile(null, allDriverGenerator);
            }
            allDriverGenerator.dumpErrorMessages();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    protected void startGeneration(String[] args, ICompiler compiler, IEUnitGenerationNotifier eckGenerationNotifier) {
        boolean hasPart = false;
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            if (arg.equalsIgnoreCase("-p") || arg.equalsIgnoreCase("-part")) {
                hasPart = true;
                break;
            }
            ++n2;
        }
        if (!hasPart) {
            this.startGeneration4AllPartsUnderIRRootDir(args, compiler, eckGenerationNotifier);
        } else {
            this.generate(args, new EUnitGenerator(this, this.generatedLibs, this.totalCnts, (IGenerationMessageRequestor)new AccumulatingGenerationMessageRequestor(), eckGenerationNotifier), null, compiler);
            this.generate(args, this.getEckDriverGenerator(this, (IGenerationMessageRequestor)new AccumulatingGenerationMessageRequestor(), eckGenerationNotifier), null, compiler);
            this.generateRunAllDriver(args, this.getEckRunAllDriverGenerator(this, (IGenerationMessageRequestor)new AccumulatingGenerationMessageRequestor(), eckGenerationNotifier), this.generatedLibs, this.totalCnts);
            eckGenerationNotifier.updateProgress(1);
        }
        eckGenerationNotifier.done();
    }

    private IEnvironment createEnvironment(ICompiler compiler) {
        if (compiler == null) {
            return null;
        }
        Environment env = new Environment();
        PartEnvironment partEnv = new PartEnvironment((IEnvironment)env);
        for (ZipFileBindingBuildPathEntry entry : compiler.getSystemBuildPathEntries()) {
            partEnv.registerObjectStore(entry.getObjectStore().getKeyScheme(), entry.getObjectStore());
        }
        return partEnv;
    }

    protected void startGeneration4AllPartsUnderIRRootDir(String[] args, ICompiler compiler, IEUnitGenerationNotifier eckGenerationNotifier) {
        List<String> parts = this.getParts2Gen(args);
        ArrayList<String> argList = new ArrayList<String>();
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            argList.add(arg);
            ++n2;
        }
        IEnvironment env = this.createEnvironment(compiler);
        eckGenerationNotifier.begin(parts.size() * 2 + 1);
        for (String part : parts) {
            if (eckGenerationNotifier.isAborted()) {
                return;
            }
            argList.add("-p");
            argList.add(part);
            String[] argArray = argList.toArray(new String[argList.size()]);
            this.generate(argArray, new EUnitGenerator(this, this.generatedLibs, this.totalCnts, (IGenerationMessageRequestor)new AccumulatingGenerationMessageRequestor(), eckGenerationNotifier), env, compiler);
            this.generate(argArray, this.getEckDriverGenerator(this, (IGenerationMessageRequestor)new AccumulatingGenerationMessageRequestor(), eckGenerationNotifier), env, compiler);
        }
        this.generateRunAllDriver(args, this.getEckRunAllDriverGenerator(this, (IGenerationMessageRequestor)new AccumulatingGenerationMessageRequestor(), eckGenerationNotifier), this.generatedLibs, this.totalCnts);
        eckGenerationNotifier.updateProgress(1);
    }

    protected List<String> getParts2Gen(String[] args) {
        int i = 0;
        while (i < args.length) {
            String arg = args[i];
            if (arg.equalsIgnoreCase("-genParts")) {
                return this.getPartsFromGenFile(args[i + 1]);
            }
            ++i;
        }
        return this.getPartsFromIRRootFolder(args);
    }

    protected List<String> getPartsFromGenFile(String genFileName) {
        GenPartsXMLFile driverXMLFile = new GenPartsXMLFile(genFileName);
        return driverXMLFile.getGenerationEntries();
    }

    private List<String> getPartsFromIRRootFolder(String[] args) {
        ArrayList<String> parts = new ArrayList<String>();
        String irRootDir = null;
        int i = 0;
        while (i < args.length) {
            String arg = args[i];
            if (arg.equalsIgnoreCase("-r") || arg.equalsIgnoreCase("-root")) {
                irRootDir = args[i + 1];
                break;
            }
            ++i;
        }
        File irRootDirFile = new File(irRootDir);
        String irRootDirAbsolutePath = irRootDirFile.getAbsolutePath();
        int irRootDirAbsolutePathLen = irRootDirAbsolutePath.length();
        ArrayList<File> irfiles = new ArrayList<File>();
        this.listAllFiles(irRootDirFile, irfiles);
        for (File irfile : irfiles) {
            String irFileAbsolutePath = irfile.getAbsolutePath();
            String irFileRelativePath = irFileAbsolutePath.substring(irRootDirAbsolutePathLen);
            boolean isIRFile = IRUtils.isEGLIRFileName((String)irFileRelativePath);
            if (!isIRFile) continue;
            if (irFileRelativePath.startsWith(File.separator)) {
                irFileRelativePath = irFileRelativePath.substring(File.separator.length());
            }
            int dotPos = irFileRelativePath.lastIndexOf(46);
            irFileRelativePath = irFileRelativePath.substring(0, dotPos);
            String partQName = irFileRelativePath.replace(File.separatorChar, '.');
            parts.add(partQName);
            System.out.println(partQName);
        }
        return parts;
    }

    private void listAllFiles(File parent, List<File> files) {
        if (parent.isDirectory()) {
            File[] children;
            File[] fileArray = children = parent.listFiles();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                if (child.isFile()) {
                    files.add(child);
                }
                this.listAllFiles(child, files);
                ++n2;
            }
        }
    }
}

