/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.gen;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.eclipse.edt.compiler.internal.interfaces.IGenerationMessageRequestor;
import org.eclipse.edt.compiler.internal.util.IGenerationResultsMessage;
import org.eclipse.edt.gen.AbstractGeneratorCommand;
import org.eclipse.edt.gen.CommandParameter;
import org.eclipse.edt.gen.EGLMessages.EGLMessage;
import org.eclipse.edt.gen.EglContext;
import org.eclipse.edt.gen.GenerationException;
import org.eclipse.edt.mof.codegen.api.TabbedReportWriter;
import org.eclipse.edt.mof.codegen.api.TemplateFactory;
import org.eclipse.edt.mof.egl.Annotation;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.edt.mof.egl.Stereotype;

public abstract class Generator {
    protected TemplateFactory factory = new TemplateFactory();
    protected EglContext context;
    protected IGenerationMessageRequestor requestor;
    private String header;

    public Generator(AbstractGeneratorCommand processor, IGenerationMessageRequestor requestor) {
        this.requestor = requestor;
    }

    public void initialize(AbstractGeneratorCommand processor) {
        this.context = this.makeContext(processor);
        if (this.requestor != null) {
            this.context.setMessageRequestor(this.requestor);
        }
        this.context.setTemplateFactory(this.factory);
        Map<String, CommandParameter> parameterMapping = processor.getParameterMapping();
        for (Map.Entry<String, CommandParameter> entry : parameterMapping.entrySet()) {
            this.context.put(entry.getKey(), entry.getValue());
        }
        this.factory.load(processor.getTemplates(), processor.getClass().getClassLoader());
    }

    public EglContext getContext() {
        return this.context;
    }

    public abstract EglContext makeContext(AbstractGeneratorCommand var1);

    public abstract void generate(Object var1) throws GenerationException;

    public abstract void processFile(String var1);

    public abstract Object getResult();

    public abstract void dumpErrorMessages();

    public abstract String getFileExtension();

    public String getRelativeFileName(Part part) {
        return String.valueOf(part.getTypeSignature().replaceAll("\\.", "/")) + this.getFileExtension();
    }

    protected static void writeFileUtil(EglContext context, String fileName, String output, String encoding, String encodingError, String writeError) {
        File outFile = new File(fileName);
        try {
            FileOutputStream outStream = new FileOutputStream(outFile);
            byte[] outBytes = output.getBytes(encoding);
            outStream.write(outBytes, 0, outBytes.length);
            outStream.close();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            String[] details = new String[]{encoding};
            EGLMessage message = EGLMessage.createEGLMessage(context.getMessageMapping(), 1, encodingError, null, details, context.getLastStatementLocation());
            context.getMessageRequestor().addMessage((IGenerationResultsMessage)message);
        }
        catch (IOException iOException) {
            String[] details = new String[]{outFile.getName()};
            EGLMessage message = EGLMessage.createEGLMessage(context.getMessageMapping(), 1, writeError, null, details, context.getLastStatementLocation());
            context.getMessageRequestor().addMessage((IGenerationResultsMessage)message);
            return;
        }
    }

    public TabbedReportWriter getReport() {
        return null;
    }

    protected static void writeReport(EglContext context, String fileName, TabbedReportWriter report, String encodingError, String writeError) {
        try {
            if (report != null) {
                String fn = String.valueOf(fileName.substring(0, fileName.lastIndexOf(46))) + ".html";
                String rpt = report.rpt.getWriter().toString();
                Generator.writeFileUtil(context, fn, rpt, "UTF-8", encodingError, writeError);
            }
        }
        catch (Exception exception) {
            System.err.println("Error writing generation report for " + fileName);
        }
    }

    public String getHeader() {
        block21: {
            if (this.header != null) {
                return this.header;
            }
            if (this.context == null) {
                return null;
            }
            String headerFile = (String)this.context.getParameter("headerFile");
            if (headerFile != null && headerFile.length() > 0) {
                File file = new File(headerFile);
                if (file.exists()) {
                    FileInputStream stream = null;
                    try {
                        try {
                            stream = new FileInputStream(file);
                            int fileLen = (int)file.length();
                            byte[] bytes = new byte[fileLen];
                            int totalRead = 0;
                            int currentRead = 0;
                            while (currentRead != -1 && totalRead != fileLen) {
                                currentRead = stream.read(bytes, totalRead += currentRead, fileLen - totalRead);
                            }
                            this.header = new String(bytes);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            this.context.getMessageRequestor().addMessage((IGenerationResultsMessage)EGLMessage.createEGLMessage(this.context.getMessageMapping(), 2, "7000", null, new String[]{headerFile}, null));
                            if (stream != null) {
                                try {
                                    stream.close();
                                }
                                catch (IOException iOException) {}
                            }
                            break block21;
                        }
                    }
                    catch (Throwable throwable) {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (IOException iOException) {}
                        }
                        throw throwable;
                    }
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException iOException) {}
                    }
                } else {
                    this.context.getMessageRequestor().addMessage((IGenerationResultsMessage)EGLMessage.createEGLMessage(this.context.getMessageMapping(), 2, "7000", null, new String[]{headerFile}, null));
                }
            }
        }
        if (this.header == null) {
            this.header = "";
        }
        return this.header;
    }

    public boolean verifyPartSupported(Object obj, String generatorName) {
        if (obj instanceof Part) {
            Part part = (Part)obj;
            Stereotype ann = part.getStereotype();
            if (ann != null) {
                String key = ann.getEClass().getETypeSignature();
                if (!this.context.getSupportedStereotypes().contains(key)) {
                    String[] details1 = new String[]{part.getCaseSensitiveName(), ann.getEClass().getCaseSensitiveName(), generatorName};
                    Annotation loc = part.getAnnotation("EGL_Location");
                    if (loc == null) {
                        loc = this.context.getLastStatementLocation();
                    }
                    EGLMessage message1 = EGLMessage.createEGLMessage(this.context.getMessageMapping(), 1, "9950", null, details1, loc);
                    this.context.getMessageRequestor().addMessage((IGenerationResultsMessage)message1);
                    return false;
                }
                return true;
            }
            String key = part.getEClass().getETypeSignature();
            if (!this.context.getSupportedPartTypes().contains(key)) {
                String[] details1 = new String[]{part.getCaseSensitiveName(), generatorName};
                Annotation loc = part.getAnnotation("EGL_Location");
                if (loc == null) {
                    loc = this.context.getLastStatementLocation();
                }
                EGLMessage message1 = EGLMessage.createEGLMessage(this.context.getMessageMapping(), 1, "9951", null, details1, loc);
                this.context.getMessageRequestor().addMessage((IGenerationResultsMessage)message1);
                return false;
            }
        }
        return true;
    }
}

