/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.gen;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Stack;
import org.eclipse.edt.compiler.internal.interfaces.IGenerationMessageRequestor;
import org.eclipse.edt.gen.AbstractGeneratorCommand;
import org.eclipse.edt.gen.CommandParameter;
import org.eclipse.edt.gen.EGLMessages.AccumulatingGenerationMessageRequestor;
import org.eclipse.edt.gen.Label;
import org.eclipse.edt.mof.EClassifier;
import org.eclipse.edt.mof.EObject;
import org.eclipse.edt.mof.codegen.api.TabbedWriter;
import org.eclipse.edt.mof.codegen.api.Template;
import org.eclipse.edt.mof.codegen.api.TemplateContext;
import org.eclipse.edt.mof.codegen.api.TemplateException;
import org.eclipse.edt.mof.egl.Annotation;
import org.eclipse.edt.mof.egl.Classifier;
import org.eclipse.edt.mof.egl.Element;
import org.eclipse.edt.mof.egl.IrFactory;
import org.eclipse.edt.mof.egl.Stereotype;
import org.eclipse.edt.mof.egl.StructPart;
import org.eclipse.edt.mof.egl.TryStatement;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.egl.utils.TypeUtils;

public abstract class EglContext
extends TemplateContext {
    private IrFactory factory;
    private Stack<Label> labelStack;
    private Stack<TryStatement> tryStack;
    private Map<String, String> primitiveTypeMappings;
    private Map<String, String> nativeTypeMappings;
    private Map<String, String> messageMappings;
    private List<String> supportedPartTypes;
    private List<String> supportedStereotypes;
    private IGenerationMessageRequestor messageRequestor;
    private int tempIndex;
    private Annotation lastStatementLocation;
    private final Set<String> requiredRuntimeContainers = new HashSet<String>();

    public EglContext(AbstractGeneratorCommand processor) {
        this.factory = IrFactory.INSTANCE;
        this.tryStack = new Stack();
        this.labelStack = new Stack();
        this.messageRequestor = new AccumulatingGenerationMessageRequestor();
        ClassLoader loader = processor.getClass().getClassLoader();
        this.nativeTypeMappings = this.load(processor.getNativeTypes(), loader);
        this.primitiveTypeMappings = this.load(processor.getPrimitiveTypes(), loader);
        this.messageMappings = this.load(processor.getEGLMessages(), loader);
        this.supportedPartTypes = processor.getSupportedPartTypes();
        this.supportedStereotypes = processor.getSupportedStereotypes();
    }

    public IrFactory getFactory() {
        return this.factory;
    }

    public void pushLabelStack(Label label) {
        this.labelStack.push(label);
    }

    public void popLabelStack() {
        this.labelStack.pop();
    }

    public Label searchLabelStack(int type) {
        int i = this.labelStack.size();
        while (i > 0) {
            Label label = (Label)this.labelStack.get(--i);
            if (type != 0 && label.getType() != type) continue;
            return label;
        }
        return null;
    }

    public Label searchLabelStack(int type, int ignore) {
        int i = this.labelStack.size();
        while (i > 0) {
            Label label = (Label)this.labelStack.get(--i);
            if (type != 0 || label.getType() == ignore) continue;
            return label;
        }
        return null;
    }

    public void clearTryStack() {
        this.tryStack.clear();
    }

    public boolean tryStackIsEmpty() {
        return this.tryStack.isEmpty();
    }

    public void pushTryStack(TryStatement stmt) {
        this.tryStack.push(stmt);
    }

    public void popTryStack(TryStatement stmt) {
        this.tryStack.pop();
    }

    public int nextTempIndex() {
        ++this.tempIndex;
        return this.tempIndex;
    }

    public String nextTempName() {
        return "eze$Temp" + this.nextTempIndex();
    }

    public String nextLogicallyNotNullableTempName() {
        return "eze$LNNTemp" + this.nextTempIndex();
    }

    public IGenerationMessageRequestor getMessageRequestor() {
        return this.messageRequestor;
    }

    public void setMessageRequestor(IGenerationMessageRequestor requestor) {
        this.messageRequestor = requestor;
    }

    public Map<String, String> getMessageMapping() {
        return this.messageMappings;
    }

    public boolean mapsToPrimitiveType(Type type) {
        return this.primitiveTypeMappings.containsKey(type.getClassifier().getTypeSignature());
    }

    public String getPrimitiveMapping(String item) {
        String value = this.primitiveTypeMappings.get(item);
        if (value != null) {
            return value;
        }
        return null;
    }

    public String getPrimitiveMapping(Type type) {
        String value = this.primitiveTypeMappings.get(type.getClassifier().getTypeSignature());
        if (value != null) {
            return value;
        }
        this.handleValidationError(type);
        throw new TemplateException("", (EObject)type);
    }

    public boolean mapsToNativeType(Type type) {
        return this.nativeTypeMappings.containsKey(type.getClassifier().getTypeSignature());
    }

    public String getNativeMapping(String item) {
        String value = this.nativeTypeMappings.get(item);
        if (value != null) {
            return value;
        }
        return null;
    }

    public String getNativeImplementationMapping(Type type) {
        String value = this.nativeTypeMappings.get(type.getClassifier().getTypeSignature());
        if (value != null) {
            String impl = this.nativeTypeMappings.get(value);
            if (impl != null) {
                return impl;
            }
            return value;
        }
        return type.getClassifier().getTypeSignature();
    }

    public String getNativeInterfaceMapping(Type type) {
        String value = this.nativeTypeMappings.get(type.getClassifier().getTypeSignature());
        if (value != null) {
            if (this.nativeTypeMappings.get(value) != null) {
                return value;
            }
            return type.getClassifier().getTypeSignature();
        }
        return type.getClassifier().getTypeSignature();
    }

    public Object getParameter(String internalName) {
        Object value = null;
        if (this.get(internalName) != null) {
            value = ((CommandParameter)this.get(internalName)).getValue();
        }
        return value;
    }

    public void foreachAnnotation(List<? extends Annotation> list, char separator, String methodName, EglContext ctx, TabbedWriter out, Object ... args) throws TemplateException {
        int i = 0;
        while (i < list.size()) {
            this.invoke(methodName, (EObject)list.get(i), new Object[]{ctx, out, args});
            if (i < list.size() - 1) {
                out.print(separator);
                out.print(' ');
            }
            ++i;
        }
    }

    public void foreachType(List<? extends Type> list, char separator, String methodName, EglContext ctx, TabbedWriter out, Object ... args) throws TemplateException {
        int i = 0;
        while (i < list.size()) {
            this.invoke(methodName, list.get(i), new Object[]{ctx, out, args});
            if (i < list.size() - 1) {
                out.print(separator);
                out.print(' ');
            }
            ++i;
        }
    }

    public Object getAttribute(Object key, String value) {
        List list = (List)this.get(key);
        if (list == null) {
            return null;
        }
        Annotation annotation = this.findAnnotation(value, list);
        if (annotation != null) {
            return annotation.getValue();
        }
        return null;
    }

    private Annotation findAnnotation(String value, List<Annotation> list) {
        int i = 0;
        while (i < list.size()) {
            Annotation annotation = list.get(i);
            if (value.equalsIgnoreCase(annotation.getEClass().getName())) {
                return annotation;
            }
            ++i;
        }
        return null;
    }

    public void putAttribute(Object key, String value, Object entry) {
        Annotation annotation;
        ArrayList<Annotation> list = (ArrayList<Annotation>)this.get(key);
        if (list == null) {
            list = new ArrayList<Annotation>();
            this.put(key, list);
        }
        if ((annotation = this.findAnnotation(value, list)) == null) {
            annotation = this.factory.createAnnotation(value);
            list.add(annotation);
        }
        annotation.setValue(entry);
    }

    public Map<String, String> load(String fileList, ClassLoader loader) {
        String[] files;
        HashMap<String, String> map = new HashMap<String, String>();
        String[] stringArray = files = fileList.length() == 0 ? new String[]{} : fileList.split("[;]");
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            String file = stringArray[n2];
            ResourceBundle bundle = ResourceBundle.getBundle(file, Locale.getDefault(), loader);
            Enumeration<String> keys = bundle.getKeys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                String data = bundle.getString(key);
                if (map.get(key) != null) continue;
                map.put(key, data);
            }
            ++n2;
        }
        return map;
    }

    public abstract void handleValidationError(Element var1);

    public abstract void handleValidationError(Annotation var1);

    public abstract void handleValidationError(Type var1);

    public Object invoke(String methodName, Type type, Object ... args) {
        TemplateContext.TemplateMethod tm = this.getTemplateMethod(methodName, type, args);
        if (tm == null) {
            tm = this.getTemplateMethod(methodName, (EClassifier)type.getEClass(), args);
        }
        if (tm != null) {
            return this.doInvoke(tm.getMethod(), tm.getTemplate(), type, args);
        }
        return this.invoke(methodName, type, args);
    }

    public Object invokeSuper(Template template, String methodName, Type type, Object ... args) {
        Classifier classifier = this.getClassifierForTemplate(template);
        StructPart superType = null;
        if (classifier instanceof StructPart && !((StructPart)classifier).getSuperTypes().isEmpty()) {
            superType = (StructPart)((StructPart)classifier).getSuperTypes().get(0);
        }
        if (superType == null) {
            return this.invokeSuper(template, methodName, (EObject)type, args);
        }
        TemplateContext.TemplateMethod tm = this.getTemplateMethod(methodName, (Type)superType, args);
        if (tm != null && tm.getTemplate().getClass().toString().equals(template.getClass().toString())) {
            tm = this.getTemplateMethod(methodName, (Type)((StructPart)superType.getClassifier()).getSuperTypes().get(0), args);
        }
        if (tm != null) {
            return this.doInvoke(tm.getMethod(), tm.getTemplate(), type, args);
        }
        return this.invokeSuper(template, methodName, (EObject)type, args);
    }

    public TemplateContext.TemplateMethod getTemplateMethod(String methodName, Type type, Object ... args) throws TemplateException {
        TemplateContext.TemplateMethod tm;
        block7: {
            Template template;
            Method method;
            block8: {
                Stereotype stereotype;
                tm = null;
                method = null;
                template = null;
                template = this.getTemplateForClassifier(type.getClassifier());
                if (template == null && (stereotype = type.getClassifier().getStereotype()) != null) {
                    template = this.getTemplateForEClassifier((EClassifier)stereotype.getEClass());
                }
                if (template != null || !(type instanceof StructPart)) break block8;
                for (StructPart part : ((StructPart)type).getSuperTypes()) {
                    tm = this.getTemplateMethod(methodName, (Type)part, args);
                    if (tm == null) {
                        continue;
                    }
                    break block7;
                }
                break block7;
            }
            if (template == null) break block7;
            Class<?> classifierClass = type.getClass();
            method = this.primGetMethod(methodName, template.getClass(), classifierClass, args);
            if (method != null) {
                return new TemplateContext.TemplateMethod((TemplateContext)this, template, method);
            }
            if (tm == null && type instanceof StructPart) {
                for (StructPart part : ((StructPart)type).getSuperTypes()) {
                    tm = this.getTemplateMethod(methodName, (Type)part, args);
                    if (tm == null) {
                        continue;
                    }
                    break;
                }
            }
        }
        return tm;
    }

    public Classifier getClassifierForTemplate(Template template) throws TemplateException {
        Classifier result = null;
        String signature = this.getTemplateKey(template);
        result = (Classifier)TypeUtils.getEGLType((String)signature);
        return result;
    }

    public Template getTemplateForClassifier(Classifier clazz) {
        return this.getTemplateRaw(clazz.getTypeSignature());
    }

    public Annotation getLastStatementLocation() {
        return this.lastStatementLocation;
    }

    public void setLastStatementLocation(Annotation lastStatementLocation) {
        this.lastStatementLocation = lastStatementLocation;
    }

    public void requireRuntimeContainer(String id) {
        this.requiredRuntimeContainers.add(id);
    }

    public Set<String> getRequiredRuntimeContainers() {
        return this.requiredRuntimeContainers;
    }

    public List<String> getSupportedPartTypes() {
        return this.supportedPartTypes;
    }

    public List<String> getSupportedStereotypes() {
        return this.supportedStereotypes;
    }
}

