/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.visualeditor.internal.views.dataview.model;

import java.util.List;
import org.eclipse.edt.compiler.core.ast.ClassDataDeclaration;
import org.eclipse.edt.compiler.core.ast.File;
import org.eclipse.edt.compiler.core.ast.Handler;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.compiler.core.ast.SimpleName;
import org.eclipse.edt.compiler.internal.util.BindingUtil;
import org.eclipse.edt.ide.rui.visualeditor.internal.util.HandlerFieldsResolver;
import org.eclipse.edt.ide.rui.visualeditor.internal.views.dataview.model.DataFieldPageDataNode;
import org.eclipse.edt.ide.rui.visualeditor.internal.views.dataview.model.HandlerPageDataNode;
import org.eclipse.edt.ide.rui.visualeditor.internal.views.dataview.model.PageDataModel;
import org.eclipse.edt.ide.rui.visualeditor.internal.views.dataview.model.PageDataNodeFactory;
import org.eclipse.edt.ide.ui.internal.editor.EGLEditor;
import org.eclipse.edt.mof.egl.ArrayType;
import org.eclipse.edt.mof.egl.Member;
import org.eclipse.edt.mof.egl.ParameterizedType;
import org.eclipse.edt.mof.egl.Record;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.egl.utils.TypeUtils;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.part.FileEditorInput;

public class PageDataModelBuilder {
    private static PageDataModelBuilder instance;

    public static PageDataModelBuilder getInstance() {
        if (instance == null) {
            instance = new PageDataModelBuilder();
        }
        return instance;
    }

    private PageDataModelBuilder() {
    }

    public PageDataModel create(File file, EGLEditor editor) {
        PageDataModel model = new PageDataModel();
        List parts = file.getParts();
        for (Part part : parts) {
            if (!(part instanceof Handler)) continue;
            this.fillPageDataModel(editor, model);
        }
        return model;
    }

    private void fillPageDataModel(EGLEditor editor, PageDataModel model) {
        IEditorInput editorInput;
        if (editor != null && (editorInput = editor.getEditorInput()) instanceof FileEditorInput) {
            FileEditorInput fileEditorInput = (FileEditorInput)editorInput;
            HandlerFieldsResolver handlerFieldsResolver = new HandlerFieldsResolver(fileEditorInput.getFile());
            handlerFieldsResolver.resolve();
            Handler handler = handlerFieldsResolver.getRUIHandler();
            if (handler != null) {
                HandlerPageDataNode handlerPageDataNode = (HandlerPageDataNode)PageDataNodeFactory.newPageDataNode(this.getName(handler), 1);
                model.addRootPageDataNode(handlerPageDataNode);
                List contents = handler.getContents();
                int i = 0;
                while (i < contents.size()) {
                    if (contents.get(i) instanceof ClassDataDeclaration) {
                        ClassDataDeclaration classDataDeclaration = (ClassDataDeclaration)contents.get(i);
                        List names = classDataDeclaration.getNames();
                        int j = 0;
                        while (j < names.size()) {
                            Object oName = names.get(j);
                            if (oName instanceof SimpleName) {
                                SimpleName simpleName = (SimpleName)oName;
                                Member dataBinding = simpleName.resolveMember();
                                Type typeBinding = simpleName.resolveType();
                                if (dataBinding != null && typeBinding != null && this.isAcceptType(typeBinding)) {
                                    ArrayType arrayTypeBinding;
                                    Type elementTypeBinding;
                                    if (typeBinding instanceof ParameterizedType) {
                                        typeBinding = ((ParameterizedType)typeBinding).getParameterizableType();
                                    }
                                    if ((TypeUtils.isPrimitive((Type)typeBinding) || typeBinding instanceof Record) && !TypeUtils.Type_ANY.equals(typeBinding).booleanValue()) {
                                        DataFieldPageDataNode dataFieldPageDataNode = null;
                                        dataFieldPageDataNode = classDataDeclaration.isPrivate() ? (DataFieldPageDataNode)PageDataNodeFactory.newPageDataNode(this.getName(dataBinding), 3) : (DataFieldPageDataNode)PageDataNodeFactory.newPageDataNode(this.getName(dataBinding), 2);
                                        dataFieldPageDataNode.setDataBindingName(dataBinding.getCaseSensitiveName());
                                        handlerPageDataNode.addChild(dataFieldPageDataNode);
                                    }
                                    if (typeBinding instanceof ArrayType && (TypeUtils.isPrimitive((Type)(elementTypeBinding = (arrayTypeBinding = (ArrayType)typeBinding).getElementType())) || elementTypeBinding instanceof Record) && !TypeUtils.Type_ANY.equals(elementTypeBinding).booleanValue()) {
                                        DataFieldPageDataNode dataFieldPageDataNode = null;
                                        dataFieldPageDataNode = classDataDeclaration.isPrivate() ? (DataFieldPageDataNode)PageDataNodeFactory.newPageDataNode(this.getName(dataBinding), 3) : (DataFieldPageDataNode)PageDataNodeFactory.newPageDataNode(this.getName(dataBinding), 2);
                                        dataFieldPageDataNode.setDataBindingName(dataBinding.getCaseSensitiveName());
                                        handlerPageDataNode.addChild(dataFieldPageDataNode);
                                    }
                                }
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
        }
    }

    private boolean isAcceptType(Type typeBinding) {
        String packageQualifiedName = typeBinding.getTypeSignature();
        return !packageQualifiedName.equals("org.eclipse.edt.rui.mvc.FormField");
    }

    private String getName(Handler handler) {
        StringBuffer sbName = new StringBuffer(handler.getName().getCanonicalName());
        Name handlerType = handler.getSubType();
        if (handlerType != null) {
            sbName.append(" : ");
            sbName.append(handlerType.getCanonicalString());
        }
        return sbName.toString();
    }

    private String getName(Member dataBinding) {
        StringBuffer sbName = new StringBuffer(dataBinding.getCaseSensitiveName());
        sbName.append(" : ");
        sbName.append(BindingUtil.getShortTypeString((Type)dataBinding.getType(), (boolean)true));
        return sbName.toString();
    }
}

