/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.visualeditor.internal.properties;

import java.util.ArrayList;
import org.eclipse.edt.ide.rui.visualeditor.internal.actions.EvActionPropertyViewFilter;
import org.eclipse.edt.ide.rui.visualeditor.internal.editor.EvEditor;
import org.eclipse.edt.ide.rui.visualeditor.internal.editor.EvHelp;
import org.eclipse.edt.ide.rui.visualeditor.internal.nl.Messages;
import org.eclipse.edt.ide.rui.visualeditor.internal.properties.IEvPropertySheetPageAdapter;
import org.eclipse.edt.ide.rui.visualeditor.internal.properties.PropertyPage;
import org.eclipse.edt.ide.rui.visualeditor.internal.util.EvFunctionNameDialog;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.WidgetDescriptor;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.WidgetDescriptorRegistry;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.WidgetEventDescriptor;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.WidgetPart;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.WidgetPropertyDescriptor;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.WidgetPropertyValue;
import org.eclipse.edt.ide.rui.visualeditor.plugin.Activator;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IPartSelectionListener;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.views.properties.IPropertySheetPage;

public class PropertySheetPage
extends Page
implements DisposeListener,
IPartSelectionListener,
IPropertySheetPage,
SelectionListener {
    public static int filter_Type = 2;
    private IMenuManager submenu;
    private EvActionPropertyViewFilter filter_ShowAll;
    private EvActionPropertyViewFilter filter_HideExcluded;
    private boolean layoutChanged = false;
    protected static PropertySheetPage _instance = null;
    protected Composite _composite = null;
    protected Cursor _cursorWait = null;
    protected IEvPropertySheetPageAdapter _editorAdapter = null;
    protected Label _labelWidgetTypeImage = null;
    protected Label _labelWidgetTypeLabel = null;
    protected String _selectedTabName = "";
    protected PropertyPage _propertyPage = null;
    protected WidgetPart _widgetSelected = null;

    public static PropertySheetPage getInstance() {
        if (_instance == null) {
            _instance = new PropertySheetPage();
        }
        return _instance;
    }

    private PropertySheetPage() {
    }

    public void createControl(Composite compositeParent) {
        if (this._composite != null && !this._composite.isDisposed()) {
            return;
        }
        this._composite = new Composite(compositeParent, 0);
        GridLayout gridLayout = new GridLayout();
        this._composite.setLayout((Layout)gridLayout);
        Composite compositeHeader = new Composite(this._composite, 0);
        GridData gridData = new GridData(768);
        compositeHeader.setLayoutData((Object)gridData);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        compositeHeader.setLayout((Layout)gridLayout);
        compositeHeader.setBackground(this._composite.getBackground());
        this._labelWidgetTypeImage = new Label(compositeHeader, 0);
        gridData = new GridData();
        this._labelWidgetTypeImage.setLayoutData((Object)gridData);
        this._labelWidgetTypeImage.setBackground(this._composite.getBackground());
        this._labelWidgetTypeLabel = new Label(compositeHeader, 0);
        gridData = new GridData(768);
        this._labelWidgetTypeLabel.setLayoutData((Object)gridData);
        this._labelWidgetTypeLabel.setBackground(this._composite.getBackground());
        Label label = new Label(this._composite, 258);
        gridData = new GridData(768);
        label.setLayoutData((Object)gridData);
        compositeParent.addDisposeListener((DisposeListener)this);
        this.registerActions();
        EvHelp.setHelp((Control)this._composite, EvHelp.PROPERTY_PAGE);
    }

    public boolean createNewEventHandlingFunction(TableItem tableItem) {
        if (this._editorAdapter == null) {
            return false;
        }
        String strEventName = String.valueOf(this._widgetSelected.getVariableName()) + "_";
        if (tableItem != null) {
            strEventName = String.valueOf(strEventName) + tableItem.getText(0);
        }
        EvFunctionNameDialog dialog = new EvFunctionNameDialog(this._composite.getShell(), this._editorAdapter.getEditorProvider(), strEventName);
        dialog.open();
        String strFunctionName = dialog.getName();
        if (dialog.getReturnCode() == 0) {
            if (tableItem != null) {
                this.setEventValue(tableItem, strFunctionName, false);
            }
            this._editorAdapter.createEventHandlingFunction(strFunctionName);
            int offset = this._editorAdapter.getEditorProvider().getFunctionFirstLineOffset(strFunctionName);
            this._editorAdapter.selectAndRevealRange(offset, 0);
            return true;
        }
        return false;
    }

    public void eventValueChanged(WidgetEventDescriptor descriptor, String strValueOld, String strValueNew, boolean refresh) {
        if (this._editorAdapter == null) {
            return;
        }
        this._editorAdapter.eventChanged(this._widgetSelected, descriptor, strValueOld, strValueNew, refresh);
    }

    public Control getControl() {
        return this._composite;
    }

    public IEvPropertySheetPageAdapter getEditorAdapter() {
        return this._editorAdapter;
    }

    public String[] getEventHandlingFunctionNames() {
        return this._editorAdapter.getEventHandlingFunctionNames();
    }

    public void propertyValueChanged(WidgetPropertyDescriptor descriptor, WidgetPropertyValue valueOld, WidgetPropertyValue valueNew) {
        if (this._editorAdapter == null) {
            return;
        }
        Control control = this.getControl();
        if (this._cursorWait == null) {
            this._cursorWait = new Cursor((Device)control.getDisplay(), 1);
        }
        control.setCursor(this._cursorWait);
        this._editorAdapter.propertyChanged(this._widgetSelected, descriptor, valueOld, valueNew);
        control.setCursor(null);
    }

    public void setLayoutChanged(boolean changed) {
        this.layoutChanged = changed;
    }

    public void selectionChanged(IFormPart part, ISelection selection) {
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (part == null || !(part instanceof IEditorPart)) {
            return;
        }
        IEvPropertySheetPageAdapter editorAdapter = (IEvPropertySheetPageAdapter)part.getAdapter(IEvPropertySheetPageAdapter.class);
        boolean bRefreshRequired = false;
        if (editorAdapter != this._editorAdapter) {
            this._editorAdapter = editorAdapter;
            bRefreshRequired = true;
        }
        if (this._editorAdapter != null) {
            WidgetPart widget = this._editorAdapter.getWidgetSelected();
            this.widgetSelected(widget, editorAdapter, bRefreshRequired);
        }
    }

    public void setEventValue(TableItem tableItem, String strFunctionName, boolean refresh) {
        WidgetEventDescriptor descriptor = (WidgetEventDescriptor)tableItem.getData("descriptor");
        tableItem.setText(1, strFunctionName != null ? strFunctionName : "");
        WidgetPropertyValue propertyValue = this._editorAdapter.getEventValue(this._widgetSelected, descriptor.getID());
        if (propertyValue == null && strFunctionName == null) {
            return;
        }
        String strValueCurrent = null;
        ArrayList listValues = null;
        if (propertyValue != null) {
            listValues = propertyValue.getValues();
        }
        if (listValues != null && listValues.size() > 0) {
            strValueCurrent = (String)listValues.get(0);
        }
        if (strValueCurrent == null && strFunctionName == null) {
            return;
        }
        if (strValueCurrent != null && strFunctionName != null && strValueCurrent.equals(strFunctionName)) {
            return;
        }
        this._editorAdapter.eventChanged(this._widgetSelected, descriptor, strValueCurrent, strFunctionName, refresh);
    }

    public void setFocus() {
    }

    public void tabFolderPageNameChanged() {
        this._selectedTabName = this._propertyPage.getTabFolderPageName();
    }

    public void update() {
        if (this._propertyPage == null || this._widgetSelected == null || this._editorAdapter == null) {
            return;
        }
        String strStatement = this._editorAdapter.getDocumentStatement(this._widgetSelected);
        if (strStatement != null) {
            String strStatement1 = strStatement.replaceAll("\r", "");
            this._labelWidgetTypeLabel.setToolTipText(strStatement1);
        }
        String[] straFunctionNames = this._editorAdapter.getEventHandlingFunctionNames();
        this._propertyPage.reloadValues(this._widgetSelected, straFunctionNames);
    }

    public void widgetDefaultSelected(SelectionEvent event) {
        this.widgetSelected(event);
    }

    public void widgetDisposed(DisposeEvent e) {
        if (this._cursorWait != null && !this._cursorWait.isDisposed()) {
            this._cursorWait.dispose();
            this._cursorWait = null;
        }
    }

    public void widgetSelected(SelectionEvent event) {
        this.createNewEventHandlingFunction(null);
    }

    public void widgetSelected(WidgetPart widgetSelected, IEvPropertySheetPageAdapter editorAdapter) {
        this.widgetSelected(widgetSelected, editorAdapter, false);
    }

    public void refreshWidgetControl() {
        this.widgetSelected(this._widgetSelected, this._editorAdapter, true);
    }

    public void widgetSelected(final WidgetPart widgetSelected, final IEvPropertySheetPageAdapter editorAdapter, final boolean bRefreshRequired) {
        if (this._labelWidgetTypeLabel == null || this._labelWidgetTypeLabel.isDisposed()) {
            return;
        }
        this.getControl().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                PropertySheetPage.this.widgetSelectedOperation(widgetSelected, editorAdapter, bRefreshRequired);
            }
        });
    }

    private void widgetSelectedOperation(WidgetPart widgetSelected, IEvPropertySheetPageAdapter editorAdapter, boolean bRefreshRequired) {
        WidgetDescriptor descriptor;
        if (this._labelWidgetTypeLabel == null || this._labelWidgetTypeLabel.isDisposed()) {
            return;
        }
        if (this._propertyPage != null && this._propertyPage._propertyChangedFromPropertiesView) {
            this._propertyPage._propertyChangedFromPropertiesView = false;
            this._widgetSelected = widgetSelected;
            return;
        }
        this._editorAdapter = editorAdapter;
        EvEditor editor = (EvEditor)editorAdapter;
        if (widgetSelected != null && (widgetSelected.getStatementOffset() < 0 || widgetSelected.getStatementLength() <= 0)) {
            widgetSelected = null;
        }
        if (this._propertyPage != null && this._propertyPage.isDisposed()) {
            this._propertyPage = null;
        }
        WidgetDescriptorRegistry registry = WidgetDescriptorRegistry.getInstance(editor.getProject());
        if (this._propertyPage != null && widgetSelected != null && widgetSelected.isSameWith(this._widgetSelected) && !bRefreshRequired) {
            if (this.layoutChanged) {
                this._propertyPage.recreateControlsForLayout(widgetSelected, registry);
                this._propertyPage.setTabFolderPageName(this._selectedTabName);
                this.layoutChanged = false;
                this._composite.layout();
                this._composite.getParent().layout();
            }
            return;
        }
        String strTypeOld = null;
        String strTypeNew = null;
        if (this._widgetSelected != null) {
            strTypeOld = this._widgetSelected.getTypeID();
        }
        if (widgetSelected != null) {
            strTypeNew = widgetSelected.getTypeID();
        }
        boolean bTypeChanged = false;
        if (strTypeOld != null && strTypeNew != null) {
            if (!strTypeOld.equals(strTypeNew) || bRefreshRequired) {
                bTypeChanged = true;
            }
        } else if (widgetSelected == null && this._widgetSelected != null || this._widgetSelected == null && widgetSelected != null) {
            bTypeChanged = true;
        }
        this._widgetSelected = widgetSelected;
        if (this._propertyPage != null) {
            this._selectedTabName = this._propertyPage.getTabFolderPageName();
            if (bTypeChanged) {
                this._propertyPage.dispose();
                this._propertyPage = null;
            }
        }
        if (this._widgetSelected == null) {
            this._labelWidgetTypeImage.setImage(null);
            this._labelWidgetTypeLabel.setText("");
            this._labelWidgetTypeLabel.setToolTipText("");
            return;
        }
        this._labelWidgetTypeImage.setImage(Activator.getDefault().getWidgetImage(widgetSelected));
        this._labelWidgetTypeLabel.setText(widgetSelected.getLabel());
        String strStatement = editorAdapter.getDocumentStatement(this._widgetSelected);
        if (strStatement != null) {
            String strStatement1 = strStatement.replaceAll("\r", "");
            this._labelWidgetTypeLabel.setToolTipText(strStatement1);
        }
        if ((descriptor = registry.getDescriptor(strTypeNew)) == null) {
            return;
        }
        WidgetPropertyDescriptor[] propertyDescriptors = descriptor.getPropertyDescriptors(filter_Type);
        WidgetEventDescriptor[] eventDescriptors = descriptor.getEventDescriptors(filter_Type);
        if (propertyDescriptors == null || eventDescriptors == null) {
            return;
        }
        if (propertyDescriptors.length == 0 && eventDescriptors.length == 0) {
            return;
        }
        String[] straFunctionNames = this._editorAdapter.getEventHandlingFunctionNames();
        if (this._propertyPage == null) {
            this._propertyPage = new PropertyPage(this._composite, this, this._widgetSelected, straFunctionNames, editor);
        } else {
            if (bRefreshRequired) {
                this._propertyPage.createControlsForProperties(descriptor, widgetSelected, registry);
            }
            this._propertyPage.reloadValues(this._widgetSelected, straFunctionNames);
            this._propertyPage.recreateControlsForLayout(widgetSelected, registry);
        }
        this._composite.layout();
        this._composite.getParent().layout();
        this._propertyPage.setTabFolderPageName(this._selectedTabName);
    }

    private void registerActions() {
        IActionBars actionBars = this.getSite().getActionBars();
        IMenuManager menu = actionBars.getMenuManager();
        this.submenu = new MenuManager(Messages.NL_Menu_Filter);
        menu.add((IContributionItem)this.submenu);
        this.filter_ShowAll = new EvActionPropertyViewFilter(this, 1);
        this.filter_ShowAll.setText(Messages.NL_Menu_Filter_show_all);
        this.submenu.add((IAction)this.filter_ShowAll);
        this.filter_HideExcluded = new EvActionPropertyViewFilter(this, 2);
        this.filter_HideExcluded.setText(Messages.NL_Menu_Filter_hide_excluded);
        this.submenu.add((IAction)this.filter_HideExcluded);
        menu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                PropertySheetPage.this.filter_ShowAll.setChecked(false);
                PropertySheetPage.this.filter_HideExcluded.setChecked(false);
                switch (filter_Type) {
                    case 1: {
                        PropertySheetPage.this.filter_ShowAll.setChecked(true);
                        break;
                    }
                    case 2: {
                        PropertySheetPage.this.filter_HideExcluded.setChecked(true);
                    }
                }
                if (PropertySheetPage.this.submenu != null) {
                    PropertySheetPage.this.submenu.updateAll(true);
                }
            }
        });
    }
}

