/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.model.IPackageFragment;
import org.eclipse.edt.ide.core.model.IPackageFragmentRoot;
import org.eclipse.edt.ide.core.utils.ProjectSettingsUtility;
import org.eclipse.edt.ide.ui.wizards.EGLPackageConfiguration;
import org.eclipse.edt.ide.ui.wizards.ProjectConfiguration;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.osgi.service.prefs.BackingStoreException;

public class ProjectGeneratorOperation
extends WorkspaceModifyOperation {
    private ProjectConfiguration configuration;
    private String compilerId;
    private String[] generatorIds;
    private String resourceName;

    public ProjectGeneratorOperation(ProjectConfiguration configuration, ISchedulingRule rule) {
        this(configuration, null, configuration.getSelectedGenerators(), rule);
    }

    public ProjectGeneratorOperation(ProjectConfiguration configuration, String resourceName, String[] generatorIds, ISchedulingRule rule) {
        super(rule);
        this.configuration = configuration;
        this.compilerId = configuration.getSelectedCompiler();
        this.generatorIds = generatorIds;
        this.resourceName = resourceName;
    }

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        IWorkspaceRoot fWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = fWorkspaceRoot.getProject(this.configuration.getProjectName());
        try {
            IProject resource;
            if (this.resourceName == null || this.resourceName.isEmpty()) {
                resource = project;
                ProjectSettingsUtility.setCompiler((IProject)project, (String)this.compilerId);
                ProjectSettingsUtility.clearAllGeneratorIds((IProject)project);
            } else {
                EGLPackageConfiguration packageConfiguration = new EGLPackageConfiguration();
                packageConfiguration.setProjectName(this.configuration.getProjectName());
                IEGLProject eproject = EGLCore.create((IProject)project);
                IPackageFragmentRoot root = eproject.getPackageFragmentRoot((IPath)new Path(packageConfiguration.getSourceFolderName()));
                IPackageFragment newPackageFragment = root.createPackageFragment(this.resourceName, true, monitor);
                resource = newPackageFragment.getResource();
            }
            if (this.generatorIds != null && this.generatorIds.length > 0) {
                ProjectSettingsUtility.setGeneratorIds((IResource)resource, (String[])this.generatorIds);
            }
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
    }
}

