/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.wizards;

import org.eclipse.edt.ide.ui.internal.templates.TemplateEngine;
import org.eclipse.edt.ide.ui.wizards.DataTableConfiguration;
import org.eclipse.edt.ide.ui.wizards.EGLFileConfiguration;
import org.eclipse.edt.ide.ui.wizards.EGLFileOperation;
import org.eclipse.edt.ide.ui.wizards.PartTemplateException;

public class DataTableOperation
extends EGLFileOperation {
    private DataTableConfiguration configuration;

    public DataTableOperation(DataTableConfiguration configuration) {
        super(configuration);
        this.configuration = configuration;
    }

    @Override
    protected String getFileContents() throws PartTemplateException {
        String dataTableOutputString = "";
        String templateName = "dataTable";
        String templateid = "org.eclipse.edt.ide.ui.templates.basic_table";
        String templateVariableProgramName = "${dataTableName}";
        if (this.configuration.getDataTableType() == 0) {
            templateid = "org.eclipse.edt.ide.ui.templates.basic_table";
        } else if (this.configuration.getDataTableType() == 3) {
            templateid = "org.eclipse.edt.ide.ui.templates.match_invalid_table";
        } else if (this.configuration.getDataTableType() == 2) {
            templateid = "org.eclipse.edt.ide.ui.templates.match_valid_table";
        } else if (this.configuration.getDataTableType() == 1) {
            templateid = "org.eclipse.edt.ide.ui.templates.message_table";
        } else if (this.configuration.getDataTableType() == 4) {
            templateid = "org.eclipse.edt.ide.ui.templates.range_check_table";
        }
        if (this.configuration.getChosenTemplateSelection() == 1) {
            dataTableOutputString = TemplateEngine.getCustomizedTemplateString(templateName, templateid);
        } else if (this.configuration.getChosenTemplateSelection() == 0) {
            dataTableOutputString = TemplateEngine.getDefaultTemplateString(templateName, templateid);
        }
        if (dataTableOutputString.compareTo("") != 0) {
            String newVariableValue = this.configuration.getDataTableName();
            int variableBegin = dataTableOutputString.indexOf(templateVariableProgramName);
            if (variableBegin == -1) {
                throw new PartTemplateException(templateName, templateid, EGLFileConfiguration.TEMPLATE_CORRUPTED);
            }
            String firstHalfOutputString = dataTableOutputString.substring(0, variableBegin);
            String secondHalfOutputString = dataTableOutputString.substring(variableBegin + templateVariableProgramName.length(), dataTableOutputString.length());
            dataTableOutputString = String.valueOf(firstHalfOutputString) + newVariableValue + secondHalfOutputString;
            while (dataTableOutputString.indexOf("${") != -1) {
                int tagStart = dataTableOutputString.indexOf("${");
                int tagEnd = dataTableOutputString.indexOf("}", tagStart);
                firstHalfOutputString = dataTableOutputString.substring(0, tagStart);
                secondHalfOutputString = dataTableOutputString.substring(tagStart + 2, dataTableOutputString.length());
                dataTableOutputString = String.valueOf(firstHalfOutputString) + secondHalfOutputString;
                firstHalfOutputString = dataTableOutputString.substring(0, tagEnd - 2);
                secondHalfOutputString = dataTableOutputString.substring(tagEnd - 1, dataTableOutputString.length());
                if (firstHalfOutputString.endsWith("cursor")) {
                    firstHalfOutputString = firstHalfOutputString.substring(0, firstHalfOutputString.length() - 6);
                }
                dataTableOutputString = String.valueOf(firstHalfOutputString) + secondHalfOutputString;
            }
            return dataTableOutputString;
        }
        throw new PartTemplateException(templateName, templateid, EGLFileConfiguration.TEMPLATE_NOT_FOUND);
    }
}

