/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.templates.parts;

import java.util.LinkedHashMap;
import org.eclipse.edt.ide.ui.templates.parts.Element;
import org.eclipse.edt.ide.ui.templates.parts.Field;

public abstract class Part
extends Element {
    private String name;
    private String subType;
    private LinkedHashMap<String, Field> fields = new LinkedHashMap();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSubType() {
        return this.subType;
    }

    public void setSubType(String subType) {
        this.subType = subType;
    }

    public abstract String getPartKind();

    public String getHeader() {
        if (this.subType == null) {
            return String.valueOf(this.getPartKind()) + " " + this.getName() + this.getAnnotationString();
        }
        return String.valueOf(this.getPartKind()) + " " + this.getName() + " type " + this.getSubType() + this.getAnnotationString();
    }

    public void addField(Field field) {
        String fName = field.getName().toUpperCase().toLowerCase();
        Field oldField = this.fields.get(fName);
        if (oldField == null) {
            this.fields.put(field.getName().toUpperCase().toLowerCase(), field);
        } else {
            oldField.setType(oldField.getType().compareTo(field.getType()));
        }
    }

    public Field[] getFields() {
        return this.fields.values().toArray(new Field[this.fields.size()]);
    }

    public Field getField(String name) {
        return this.fields.get(name.toUpperCase().toLowerCase());
    }
}

