/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.project.templates;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.edt.ide.core.EDTCoreIDEPlugin;
import org.eclipse.edt.ide.ui.internal.project.features.operations.EGLFeatureOperationsUtilities;
import org.eclipse.edt.ide.ui.project.templates.IProjectTemplateClass;
import org.eclipse.edt.ide.ui.wizards.EGLPackageConfiguration;
import org.eclipse.edt.ide.ui.wizards.EGLPackageOperation;
import org.eclipse.edt.ide.ui.wizards.ProjectConfiguration;
import org.eclipse.edt.ide.ui.wizards.ProjectConfigurationOperation;
import org.eclipse.edt.ide.ui.wizards.ProjectCreationOperation;
import org.eclipse.edt.ide.ui.wizards.ProjectGeneratorOperation;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public abstract class AbstractProjectTemplateClass
implements IProjectTemplateClass {
    private String[] defaultPackages;

    @Override
    public List<WorkspaceModifyOperation> getOperations(ProjectConfiguration eglProjConfiguration, int eglFeatureMask, ISchedulingRule rule) {
        ArrayList<WorkspaceModifyOperation> listOps = new ArrayList<WorkspaceModifyOperation>();
        this.setTargetRuntime(eglProjConfiguration);
        ProjectCreationOperation creationOperation = new ProjectCreationOperation(eglProjConfiguration, rule);
        listOps.add(creationOperation);
        ProjectConfigurationOperation configureOperation = new ProjectConfigurationOperation(eglProjConfiguration, rule);
        listOps.add(configureOperation);
        this.setDefaultPackages();
        String basePackage = eglProjConfiguration.getBasePackageName();
        if (this.defaultPackages.length > 0) {
            String[] stringArray = this.defaultPackages;
            int n = this.defaultPackages.length;
            int n2 = 0;
            while (n2 < n) {
                String packageName = stringArray[n2];
                this.createPackage(eglProjConfiguration, listOps, basePackage, packageName);
                ++n2;
            }
        } else {
            this.createPackage(eglProjConfiguration, listOps, basePackage, null);
        }
        this.addGeneratorOperation(eglProjConfiguration, rule, listOps);
        EGLFeatureOperationsUtilities.getEGLFeatureOperations(eglProjConfiguration.getProjectName(), listOps, rule, 0, eglFeatureMask, false, false);
        return listOps;
    }

    protected void addGeneratorOperation(ProjectConfiguration eglProjConfiguration, ISchedulingRule rule, List listOps) {
        this.setProjectCompilerAndGenerator(eglProjConfiguration);
        ProjectGeneratorOperation op = new ProjectGeneratorOperation(eglProjConfiguration, rule);
        listOps.add(op);
    }

    protected void createPackage(ProjectConfiguration eglProjConfiguration, List listOps, String basePackage, String packageName) {
        EGLPackageConfiguration packageConfiguration = new EGLPackageConfiguration();
        packageConfiguration.init(null, null);
        packageConfiguration.setProjectName(eglProjConfiguration.getProjectName());
        IPreferenceStore store = EDTCoreIDEPlugin.getPlugin().getPreferenceStore();
        String sourceFolderPath = store.getString("eglSourceFolder");
        packageConfiguration.setSourceFolderName(sourceFolderPath);
        if (packageName == null || packageName.length() <= 0) {
            return;
        }
        packageConfiguration.setFPackage(packageName);
        listOps.add(new EGLPackageOperation(packageConfiguration));
    }

    @Override
    public boolean canFinish() {
        return false;
    }

    @Override
    public boolean needPreserveBasePackage() {
        return true;
    }

    public void setDefaultPackages(String[] defaultPackages) {
        this.defaultPackages = defaultPackages;
    }

    @Override
    public List<WorkspaceModifyOperation> getImportProjectOperations(ProjectConfiguration eglProjConfiguration, int eglFeatureMask, ISchedulingRule rule) {
        return Collections.EMPTY_LIST;
    }

    protected abstract void setDefaultPackages();

    protected abstract void setTargetRuntime(ProjectConfiguration var1);

    protected abstract void setProjectCompilerAndGenerator(ProjectConfiguration var1);
}

