/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.wizards;

import java.util.List;
import org.eclipse.edt.compiler.core.ast.NestedFunction;
import org.eclipse.edt.ide.ui.internal.IUIHelpConstants;
import org.eclipse.edt.ide.ui.internal.wizards.EGLFileWizard;
import org.eclipse.edt.ide.ui.internal.wizards.NewWizardMessages;
import org.eclipse.edt.ide.ui.internal.wizards.WSDLInterfaceWizardPage;
import org.eclipse.edt.ide.ui.internal.wizards.WSDLWizardPage;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.CheckedListDialogField;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.StringDialogField;
import org.eclipse.edt.ide.ui.wizards.EGLFileConfiguration;
import org.eclipse.edt.ide.ui.wizards.ExtractInterfaceConfiguration;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class ExtractInterfaceWizardPage
extends WSDLInterfaceWizardPage {
    public static final String WIZPAGENAME_ExtractInterfaceWizardPage = "WIZPAGENAME_ExtractInterfaceWizardPage";
    private int nColumns = 5;

    public ExtractInterfaceWizardPage(String pageName) {
        super(pageName);
        this.setTitle(NewWizardMessages.NewEGLExtractInterfaceWizardPageTitle);
        this.setDescription(NewWizardMessages.NewEGLExtractInterfaceWizardPageDescription);
    }

    @Override
    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, IUIHelpConstants.EGL_EXTRACT_INTERFACE);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = this.nColumns;
        composite.setLayout((Layout)layout);
        this.createContainerControls(composite, this.nColumns);
        this.createPackageControls(composite);
        this.createSeparator(composite, this.nColumns);
        this.createEGLFileControls(composite);
        this.modifyFileListeners();
        this.createInterfaceEGLNameControls(composite, this.getConfiguration().getInterfaceName(), 0);
        this.fInterfaceDialogField.getTextControl(composite).setEditable(false);
        this.createFunctionListControls(composite, (ILabelProvider)new ExtractFunctionsListLabelProvider(this.getConfiguration()), 0);
        this.createCheckBoxOverwriteFileControl(composite);
        this.createUpdateEGLPathControls(composite);
        this.setControl((Control)composite);
        this.validatePage();
        Dialog.applyDialogFont((Control)parent);
    }

    @Override
    public void updateControlValues() {
        super.updateControlValues();
        this.populateFuncList(0, this.fFunctionListField);
    }

    private ExtractInterfaceConfiguration getConfiguration() {
        return (ExtractInterfaceConfiguration)((EGLFileWizard)this.getWizard()).getConfiguration(this.getName());
    }

    @Override
    protected EGLFileConfiguration getFileConfiguration() {
        return this.getConfiguration();
    }

    private void modifyFileListeners() {
        this.fEGLFileDialogField.getTextControl(null).addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExtractInterfaceWizardPage.this.fInterfaceDialogField.setText(ExtractInterfaceWizardPage.this.fEGLFileDialogField.getText());
            }
        });
    }

    @Override
    protected void populateFuncList(int indexInWSDLConfig, CheckedListDialogField funcListField) {
        funcListField.removeAllElements();
        List funcs = this.getConfiguration().getFFunctions();
        int i = 0;
        while (i < funcs.size()) {
            boolean isChecked = this.getConfiguration().getFunctionSelectionState(i);
            funcListField.addElement(funcs.get(i));
            funcListField.setChecked(funcs.get(i), isChecked);
            ++i;
        }
    }

    @Override
    protected void handleInterfaceNameDialogFieldChanged(int indexInWSDLConfig, StringDialogField field) {
        this.getConfiguration().setInterfaceName(field.getText());
        this.validatePage();
    }

    @Override
    protected void handleFunctionListFieldChanged(int indexInWSDLConfig, CheckedListDialogField funcListField) {
        int size = funcListField.getSize();
        int i = 0;
        while (i < size) {
            boolean isChecked = funcListField.isChecked(funcListField.getElement(i));
            this.getConfiguration().setFunctionsSelectionState(i, isChecked);
            ++i;
        }
    }

    @Override
    protected void updateOtherConfiguration() {
    }

    protected class ExtractFunctionsListLabelProvider
    extends WSDLWizardPage.FunctionsListLabelProvider {
        ExtractInterfaceConfiguration config;

        public ExtractFunctionsListLabelProvider(ExtractInterfaceConfiguration config) {
            super(ExtractInterfaceWizardPage.this);
            this.config = config;
        }

        @Override
        public String getText(Object element) {
            if (element instanceof NestedFunction) {
                return ExtractInterfaceConfiguration.getFunctionSimpleSignature((NestedFunction)element, false, this.config.getFPackage());
            }
            return element == null ? "" : element.toString();
        }
    }
}

