/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.wizards;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.model.IPackageFragment;
import org.eclipse.edt.ide.core.model.IPackageFragmentRoot;
import org.eclipse.edt.ide.ui.internal.EGLLogger;
import org.eclipse.edt.ide.ui.internal.IUIHelpConstants;
import org.eclipse.edt.ide.ui.internal.dialogs.StatusInfo;
import org.eclipse.edt.ide.ui.internal.packageexplorer.EGLElementLabelProvider;
import org.eclipse.edt.ide.ui.internal.wizards.EGLFileWizard;
import org.eclipse.edt.ide.ui.internal.wizards.EGLPackageWizardPage;
import org.eclipse.edt.ide.ui.internal.wizards.NewWizardMessages;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.DialogField;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.LayoutUtil;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.StringButtonStatusDialogField;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.StringDialogField;
import org.eclipse.edt.ide.ui.wizards.EGLFileConfiguration;
import org.eclipse.edt.ide.ui.wizards.EGLPackageConfiguration;
import org.eclipse.edt.ide.ui.wizards.EGLWizardUtilities;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class EGLFileWizardPage
extends EGLPackageWizardPage {
    private static final boolean isWindows = SWT.getPlatform().toLowerCase().startsWith("win");
    private int nColumns = 5;
    protected StringButtonStatusDialogField fPackageDialogField;
    protected StringDialogField fEGLFileDialogField;
    protected StatusInfo fEGLFileStatus;
    private PackageFieldAdapter adapter = new PackageFieldAdapter();
    private Button bFileOverWriteCheckBox;
    protected Composite advancedComposite;
    protected boolean showAdvanced = false;
    protected boolean advancedControlsBuilt = false;
    protected AdvancedSizeController advancedController;
    protected boolean isFirstTimeToPage = true;
    protected Button advancedButton;

    protected void enter() {
        if (this.advancedControlsBuilt) {
            if (this.isFirstTimeToPage) {
                this.initializeAdvancedController();
            }
            if (isWindows) {
                this.advancedController.setShellSizeForAdvanced();
            }
        }
    }

    private void initializeAdvancedController() {
        this.advancedController = new AdvancedSizeController(this.getShell());
    }

    protected void exit() {
        if (this.advancedControlsBuilt && isWindows) {
            this.advancedController.resetOriginalShellSize();
        }
    }

    protected void toggleAdvanced(boolean setSize) {
        if (this.advancedControlsBuilt) {
            this.advancedComposite.setVisible(this.showAdvanced);
            if (setSize && isWindows) {
                this.advancedController.setShellSizeForAdvanced();
            }
        }
    }

    protected Composite createAdvancedComposite(Composite parent, int cols) {
        this.advancedControlsBuilt = true;
        this.advancedButton = new Button(parent, 2);
        this.setAdvancedLabelText();
        final Cursor hand = new Cursor((Device)this.advancedButton.getDisplay(), 21);
        this.advancedButton.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                hand.dispose();
            }
        });
        this.advancedComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = cols;
        this.advancedComposite.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = cols;
        this.advancedComposite.setLayoutData((Object)gd);
        this.advancedButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EGLFileWizardPage.this.showAdvanced = !EGLFileWizardPage.this.showAdvanced;
                EGLFileWizardPage.this.setAdvancedLabelText();
                EGLFileWizardPage.this.toggleAdvanced(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.advancedButton.addListener(32, new Listener(){

            public void handleEvent(Event event) {
                if (event.type == 32) {
                    EGLFileWizardPage.this.advancedButton.setCursor(hand);
                }
            }
        });
        this.addToAdvancedComposite(this.advancedComposite);
        this.enter();
        this.toggleAdvanced(true);
        return this.advancedComposite;
    }

    protected void addToAdvancedComposite(Composite parent) {
    }

    private void setAdvancedLabelText() {
        if (this.advancedControlsBuilt) {
            if (this.showAdvanced) {
                this.advancedButton.setText(NewWizardMessages.HideAdvance);
            } else {
                this.advancedButton.setText(NewWizardMessages.ShowAdvance);
            }
        }
    }

    public EGLFileWizardPage(String pageName) {
        super(pageName);
        this.setTitle(NewWizardMessages.NewEGLFileWizardPageTitle);
        this.setDescription(NewWizardMessages.NewEGLFileWizardPageDescription);
        this.fEGLFileStatus = new StatusInfo();
    }

    private EGLFileConfiguration getConfiguration() {
        return (EGLFileConfiguration)((EGLFileWizard)this.getWizard()).getConfiguration();
    }

    protected EGLFileConfiguration getFileConfiguration() {
        return this.getConfiguration();
    }

    @Override
    protected EGLPackageConfiguration getPackageConfiguration() {
        return this.getFileConfiguration();
    }

    @Override
    public void updateControlValues() {
        super.updateControlValues();
        if (this.fPackageDialogField != null && this.fPackageDialogField.getText() != null && !this.fPackageDialogField.getText().equals(this.getPackageConfiguration().getFPackage())) {
            this.fPackageDialogField.setText(this.getPackageConfiguration().getFPackage());
        }
        if (this.fEGLFileDialogField != null && this.fEGLFileDialogField.getText() != null && !this.fEGLFileDialogField.getText().equals(this.getFileConfiguration().getFileName())) {
            this.fEGLFileDialogField.setText(this.getFileConfiguration().getFileName());
        }
        if (this.bFileOverWriteCheckBox != null && this.bFileOverWriteCheckBox.getSelection() != this.getFileConfiguration().isOverwrite()) {
            this.bFileOverWriteCheckBox.setSelection(this.getFileConfiguration().isOverwrite());
        }
    }

    @Override
    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, IUIHelpConstants.EGL_EMPTY_FILE_DEFINITION);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = this.nColumns;
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = this.nColumns;
        composite.setLayoutData((Object)gd);
        this.createContainerControls(composite, this.nColumns);
        this.createPackageControls(composite);
        this.createSeparator(composite, this.nColumns);
        this.createEGLFileControls(composite);
        this.setControl((Control)composite);
        this.validatePage();
        Dialog.applyDialogFont((Control)parent);
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && this.fEGLFileDialogField != null) {
            this.fEGLFileDialogField.setFocus();
        }
    }

    @Override
    protected void createContainerControls(Composite parent, int nColumns, String textLabel) {
        super.createContainerControls(parent, nColumns, textLabel);
        this.fContainerDialogField.setDialogFieldListener(this.adapter);
    }

    @Override
    protected void createContainerControls(Composite parent, int nColumns) {
        this.createContainerControls(parent, nColumns, NewWizardMessages.NewContainerWizardPageContainerLabel);
    }

    protected void createPackageControls(Composite parent) {
        this.createPackageControls(parent, NewWizardMessages.NewTypeWizardPagePackageLabel);
    }

    protected void createPackageControls(Composite parent, String textLabel) {
        this.fPackageDialogField = new StringButtonStatusDialogField(this.adapter);
        this.fPackageDialogField.setLabelText(textLabel);
        this.fPackageDialogField.setButtonLabel(NewWizardMessages.NewTypeWizardPagePackageButton);
        this.fPackageDialogField.setStatusWidthHint(NewWizardMessages.NewTypeWizardPageDefault);
        this.fPackageDialogField.setText(this.getFileConfiguration().getFPackage());
        this.updatePackageStatusLabel();
        this.fPackageDialogField.setDialogFieldListener(this.adapter);
        this.fPackageDialogField.doFillIntoGrid(parent, this.nColumns - 1);
        DialogField.createEmptySpace(parent);
        LayoutUtil.setWidthHint((Control)this.fPackageDialogField.getTextControl(null), this.getMaxFieldWidth());
        LayoutUtil.setHorizontalGrabbing((Control)this.fPackageDialogField.getTextControl(null));
    }

    protected void createEGLFileControls(Composite parent, String labelText) {
        this.fEGLFileDialogField = new StringDialogField();
        this.fEGLFileDialogField.setLabelText(labelText);
        this.fEGLFileDialogField.setText(this.getFileConfiguration().getFileName());
        this.fEGLFileDialogField.setDialogFieldListener(this.adapter);
        this.fEGLFileDialogField.doFillIntoGrid(parent, this.nColumns - 1);
        DialogField.createEmptySpace(parent);
        LayoutUtil.setWidthHint((Control)this.fEGLFileDialogField.getTextControl(null), this.getMaxFieldWidth());
        LayoutUtil.setHorizontalGrabbing((Control)this.fEGLFileDialogField.getTextControl(null));
    }

    protected void createEGLFileControls(Composite parent) {
        this.createEGLFileControls(parent, NewWizardMessages.NewTypeWizardPageTypenameLabel);
    }

    protected void createEGLFileWithBrowseControls(Composite parent) {
        this.createEGLFileWithBrowseControls(parent, NewWizardMessages.NewTypeWizardPageTypenameLabel);
    }

    protected void createEGLFileWithBrowseControls(Composite parent, String labelText) {
        this.fEGLFileDialogField = new StringButtonDialogField(this.adapter);
        this.fEGLFileDialogField.setDialogFieldListener(this.adapter);
        this.fEGLFileDialogField.setLabelText(labelText);
        ((StringButtonDialogField)this.fEGLFileDialogField).setButtonLabel(NewWizardMessages.NewContainerWizardPageFileButton);
        this.fEGLFileDialogField.setText(this.getFileConfiguration().getFileName());
        this.fEGLFileDialogField.doFillIntoGrid(parent, this.nColumns - 1);
        DialogField.createEmptySpace(parent);
        LayoutUtil.setWidthHint((Control)this.fEGLFileDialogField.getTextControl(null), this.getMaxFieldWidth());
        LayoutUtil.setHorizontalGrabbing((Control)this.fEGLFileDialogField.getTextControl(null));
    }

    protected void handleFileBrowseButtonSelected() {
        this.getFileConfiguration().getFile();
    }

    protected void handlePackageBrowseButtonSelected() {
        ElementListSelectionDialog dialog = this.openPackageDialog();
        if (dialog != null && dialog.open() == 0) {
            Object element = dialog.getFirstResult();
            this.getFileConfiguration().setFPackage(((IPackageFragment)element).getElementName());
            this.fPackageDialogField.setText(this.getFileConfiguration().getFPackage());
            this.validatePage();
        }
    }

    @Override
    protected void handleContainerDialogFieldChanged() {
        super.handleContainerDialogFieldChanged();
        this.getPackageConfiguration().setContainerName(this.fContainerDialogField.getText());
        this.validatePage();
    }

    protected void handlePackageDialogFieldChanged() {
        this.getFileConfiguration().setFPackage(this.fPackageDialogField.getText());
        this.validatePage();
    }

    protected void handleEGLFileDialogFieldChanged() {
        this.getFileConfiguration().setFileName(this.fEGLFileDialogField.getText());
        this.validatePage();
    }

    private ElementListSelectionDialog openPackageDialog() {
        IPackageFragment pack;
        EGLElementLabelProvider lp = new EGLElementLabelProvider(EGLElementLabelProvider.SHOW_DEFAULT);
        IProject project = null;
        try {
            project = this.fWorkspaceRoot.getProject(this.getFileConfiguration().getProjectName());
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
        IEGLProject eproject = EGLCore.create((IProject)project);
        IPackageFragmentRoot froot = null;
        Object[] packages = null;
        try {
            Path sourcePath = new Path(this.getFileConfiguration().getContainerName());
            froot = eproject.findPackageFragmentRoot(sourcePath.makeAbsolute());
            if (froot != null && froot.exists()) {
                packages = froot.getChildren();
            }
        }
        catch (EGLModelException e) {
            EGLLogger.log((Object)this, e);
        }
        if (packages == null) {
            packages = new IEGLElement[]{};
        }
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)lp);
        dialog.setIgnoreCase(false);
        dialog.setTitle(NewWizardMessages.NewTypeWizardPageChoosePackageDialogTitle);
        dialog.setMessage(NewWizardMessages.NewTypeWizardPageChoosePackageDialogDescription);
        dialog.setEmptyListMessage(NewWizardMessages.NewTypeWizardPageChoosePackageDialogEmpty);
        dialog.setElements(packages);
        if (froot != null && (pack = froot.getPackageFragment(this.getFileConfiguration().getFPackage())) != null) {
            dialog.setInitialSelections(new Object[]{pack});
        }
        return dialog;
    }

    protected void updatePackageStatusLabel() {
        String packName = this.getFileConfiguration().getFPackage();
        if (packName.length() == 0) {
            this.fPackageDialogField.setStatus(NewWizardMessages.NewTypeWizardPageDefault);
        } else {
            this.fPackageDialogField.setStatus("");
        }
    }

    protected void createCheckBoxOverwriteFileControl(Composite parent) {
        this.createCheckBoxOverwriteFileControl(parent, NewWizardMessages.NewWSDL2EGLWizardPageOverwriteFile);
    }

    protected void createCheckBoxOverwriteFileControl(Composite parent, String labelText) {
        GridData gd = new GridData(256);
        gd.horizontalSpan = this.nColumns - 1;
        this.bFileOverWriteCheckBox = new Button(parent, 32);
        this.bFileOverWriteCheckBox.setLayoutData((Object)gd);
        this.bFileOverWriteCheckBox.setText(labelText);
        this.bFileOverWriteCheckBox.setSelection(this.getFileConfiguration().isOverwrite());
        this.bFileOverWriteCheckBox.addSelectionListener(new SelectionListener(){

            private void setOverwriteSelection(SelectionEvent e) {
                if (e.getSource() instanceof Button) {
                    Button btn = (Button)e.getSource();
                    EGLFileWizardPage.this.getFileConfiguration().setOverwrite(btn.getSelection());
                    EGLFileWizardPage.this.validatePage();
                }
            }

            public void widgetSelected(SelectionEvent e) {
                this.setOverwriteSelection(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.setOverwriteSelection(e);
            }
        });
    }

    @Override
    protected boolean validatePage() {
        return this.validatePage(!this.getFileConfiguration().isOverwrite());
    }

    protected boolean validatePage(boolean checkFileExistance) {
        boolean ret = false;
        if (super.validatePage()) {
            ret = this.isValidPage(checkFileExistance);
            this.updateStatus(new IStatus[]{this.fContainerStatus, this.fPackageStatus, this.fEGLFileStatus});
        }
        return ret;
    }

    protected boolean isValidPage() {
        return this.isValidPage(!this.getFileConfiguration().isOverwrite());
    }

    protected boolean isValidPage(boolean checkFileExistance) {
        this.fContainerStatus.setOK();
        this.fPackageStatus.setOK();
        this.fEGLFileStatus.setOK();
        String projectName = this.getFileConfiguration().getProjectName();
        String containerName = this.getFileConfiguration().getContainerName();
        String packageName = this.getFileConfiguration().getFPackage();
        String fileName = this.getFileConfiguration().getFileName();
        String fileExtensionName = this.getFileConfiguration().getFileExtension();
        String sourceFolderName = this.getFileConfiguration().getSourceFolderName();
        boolean isValidPackage = EGLWizardUtilities.validatePackage(projectName, containerName, sourceFolderName, packageName, this.fContainerStatus, this.fPackageStatus, (Object)this);
        if (!isValidPackage) {
            return false;
        }
        boolean isValidFile = EGLWizardUtilities.validateFile(projectName, containerName, packageName, fileName, fileExtensionName, this.fEGLFileStatus, (Object)this, checkFileExistance);
        return isValidPackage && isValidFile;
    }

    protected class AdvancedSizeController
    implements ControlListener {
        private int advancedHeight = -1;
        private Point originalSize;
        private boolean ignoreShellResize = false;

        protected AdvancedSizeController(Shell aShell) {
            this.originalSize = aShell.getSize();
            aShell.addControlListener((ControlListener)this);
        }

        public void controlMoved(ControlEvent e) {
        }

        public void controlResized(ControlEvent e) {
            Control control;
            if (!this.ignoreShellResize && (control = (Control)e.getSource()).isVisible()) {
                this.originalSize = control.getSize();
                if (this.advancedHeight == -1) {
                    this.setShellSizeForAdvanced();
                }
            }
        }

        protected void resetOriginalShellSize() {
            this.setShellSize(this.originalSize.x, this.originalSize.y);
        }

        private void setShellSize(int x, int y) {
            this.ignoreShellResize = true;
            try {
                EGLFileWizardPage.this.getShell().setSize(x, y);
            }
            finally {
                this.ignoreShellResize = false;
            }
        }

        protected void setShellSizeForAdvanced() {
            int height = this.calculateAdvancedShellHeight();
            if (height != -1) {
                this.setShellSize(EGLFileWizardPage.this.getShell().getSize().x, height);
            }
        }

        private int calculateAdvancedShellHeight() {
            Point advancedCompSize = EGLFileWizardPage.this.advancedComposite.getSize();
            if (advancedCompSize.x == 0) {
                return -1;
            }
            int height = this.computeAdvancedHeight();
            if (!EGLFileWizardPage.this.showAdvanced && height != -1) {
                height -= EGLFileWizardPage.this.advancedComposite.getSize().y;
            }
            return height;
        }

        private int computeAdvancedHeight() {
            if (this.advancedHeight == -1) {
                Point controlSize = EGLFileWizardPage.this.getControl().getSize();
                if (controlSize.x != 0) {
                    int minHeight = this.originalSize.y - controlSize.y;
                    Point pageSize = EGLFileWizardPage.this.getControl().computeSize(-1, -1);
                    this.advancedHeight = pageSize.y + minHeight;
                }
            }
            return this.advancedHeight;
        }
    }

    private class PackageFieldAdapter
    implements IStringButtonAdapter,
    IDialogFieldListener {
        private PackageFieldAdapter() {
        }

        @Override
        public void changeControlPressed(DialogField field) {
            if (field == EGLFileWizardPage.this.fEGLFileDialogField) {
                EGLFileWizardPage.this.handleFileBrowseButtonSelected();
            } else if (field == EGLFileWizardPage.this.fPackageDialogField) {
                EGLFileWizardPage.this.handlePackageBrowseButtonSelected();
            }
        }

        @Override
        public void dialogFieldChanged(DialogField field) {
            if (field == EGLFileWizardPage.this.fContainerDialogField) {
                EGLFileWizardPage.this.handleContainerDialogFieldChanged();
            }
            if (field == EGLFileWizardPage.this.fPackageDialogField) {
                EGLFileWizardPage.this.handlePackageDialogFieldChanged();
                EGLFileWizardPage.this.updatePackageStatusLabel();
            } else if (field == EGLFileWizardPage.this.fEGLFileDialogField) {
                EGLFileWizardPage.this.handleEGLFileDialogFieldChanged();
            }
        }
    }
}

