/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.wizards;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.edt.ide.ui.internal.IUIHelpConstants;
import org.eclipse.edt.ide.ui.internal.deployment.Bindings;
import org.eclipse.edt.ide.ui.internal.deployment.EGLDeploymentRoot;
import org.eclipse.edt.ide.ui.internal.deployment.Services;
import org.eclipse.edt.ide.ui.internal.deployment.ui.EGLDDRootHelper;
import org.eclipse.edt.ide.ui.internal.deployment.ui.FileBrowseDialog;
import org.eclipse.edt.ide.ui.internal.dialogs.StatusInfo;
import org.eclipse.edt.ide.ui.internal.wizards.CopyEGLDDWizard;
import org.eclipse.edt.ide.ui.internal.wizards.EGLPackageWizardPage;
import org.eclipse.edt.ide.ui.internal.wizards.NewWizardMessages;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.DialogField;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.edt.ide.ui.wizards.CopyEGLDDConfiguration;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;

public class CopyEGLDDWizardPage
extends EGLPackageWizardPage {
    public static final String WIZPAGENAME_CopyEGLDDWizardPage = "WIZPAGENAME_CopyEGLDDWizardPage";
    private int nColumns = 4;
    private StringButtonDialogField fEGLDDFileNameField;
    private ContainerCheckedTreeViewer fTreeViewer;
    private CopyEGLDDConfiguration.EGLDeploymentTreeContentProvider fTreeContentProvider;
    private CopyEGLDDConfiguration.EGLDeploymentTreeLabelProvider fTreeLabelProvider;
    private StatusInfo fFileStatus;

    public CopyEGLDDWizardPage(String pageName) {
        super(pageName);
        this.setTitle(NewWizardMessages.CopyEGLDDWizPageTitle);
        this.setDescription(NewWizardMessages.CopyEGLDDWizPageDescription);
        this.fFileStatus = new StatusInfo();
    }

    @Override
    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, IUIHelpConstants.EGLDDWIZ_COPYEGLDD);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = this.nColumns;
        composite.setLayout((Layout)layout);
        this.createFileNameControl(composite);
        this.createCopyElementSelectionControl(composite);
        this.setControl((Control)composite);
        this.validatePage();
        Dialog.applyDialogFont((Control)parent);
    }

    private CopyEGLDDConfiguration getConfiguration() {
        return (CopyEGLDDConfiguration)((CopyEGLDDWizard)this.getWizard()).getConfiguration(this.getName());
    }

    private void createCopyElementSelectionControl(Composite composite) {
        Tree tree = new Tree(composite, 2852);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = this.nColumns;
        tree.setLayoutData((Object)gd);
        this.fTreeViewer = new ContainerCheckedTreeViewer(tree);
        this.fTreeContentProvider = new CopyEGLDDConfiguration.EGLDeploymentTreeContentProvider();
        this.fTreeLabelProvider = new CopyEGLDDConfiguration.EGLDeploymentTreeLabelProvider();
        this.fTreeViewer.setContentProvider((IContentProvider)this.fTreeContentProvider);
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)this.fTreeLabelProvider);
        this.fTreeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (event.getChecked()) {
                    Object element = event.getElement();
                    if (element instanceof Bindings || element instanceof Services) {
                        Object[] children = CopyEGLDDWizardPage.this.fTreeContentProvider.getChildren(element);
                        int i = 0;
                        while (i < children.length) {
                            this.queryOverride(children[i], CopyEGLDDWizardPage.this.fTreeLabelProvider.getText(children[i]));
                            ++i;
                        }
                    } else {
                        this.queryOverride(element, CopyEGLDDWizardPage.this.fTreeLabelProvider.getText(element));
                    }
                }
                CopyEGLDDWizardPage.this.getConfiguration().updateSelectedElements(CopyEGLDDWizardPage.this.fTreeViewer.getCheckedElements());
            }

            private void queryOverride(Object element, String currLabel) {
                if (CopyEGLDDWizardPage.this.getConfiguration().getSameNameNodeInCurrentEGLDD(element, currLabel) != null) {
                    String msg = NewWizardMessages.bind((String)NewWizardMessages.QueryOverrideNodeMsg, (Object)currLabel);
                    if (!MessageDialog.openQuestion((Shell)CopyEGLDDWizardPage.this.getShell(), (String)NewWizardMessages.QueryOverrideNodeTitle, (String)msg)) {
                        CopyEGLDDWizardPage.this.fTreeViewer.setChecked(element, false);
                    }
                }
            }
        });
    }

    protected void createFileNameControl(Composite parent) {
        EGLPackageWizardPage.IStringBrowseButtonFieldAdapter adapter = new EGLPackageWizardPage.IStringBrowseButtonFieldAdapter(){

            @Override
            public void dialogFieldChanged(DialogField field) {
                if (field == CopyEGLDDWizardPage.this.fEGLDDFileNameField) {
                    CopyEGLDDWizardPage.this.HandleEGLDDFileNameChanged();
                }
            }

            @Override
            public void changeControlPressed(DialogField field) {
                if (field == CopyEGLDDWizardPage.this.fEGLDDFileNameField) {
                    CopyEGLDDWizardPage.this.HandleEGLDDFileNameBrowsePressed();
                }
            }
        };
        this.fEGLDDFileNameField = this.createStringBrowseButtonDialogField(parent, adapter, NewWizardMessages.BrowseEGLDDFileLabel, "", this.nColumns - 1);
    }

    protected void HandleEGLDDFileNameBrowsePressed() {
        Object obj;
        ElementTreeSelectionDialog dialog = FileBrowseDialog.openBrowseFileDialog(this.getShell(), this.getConfiguration().getCurrentProject(), null, true, true, null, "egldd", NewWizardMessages.CopyEGLDDDialogTitle, NewWizardMessages.CopyEGLDDDialogDescription, NewWizardMessages.CopyEGLDDDialogMsg);
        if (dialog.open() == 0 && (obj = dialog.getFirstResult()) instanceof IFile) {
            IFile file = (IFile)obj;
            this.fEGLDDFileNameField.setText(file.getFullPath().toString());
        }
    }

    protected void HandleEGLDDFileNameChanged() {
        IFile copyfrFile;
        if (this.validatePage() && (copyfrFile = this.getConfiguration().getCopyFromEGLDDFile(this.fEGLDDFileNameField.getText())) != null) {
            EGLDeploymentRoot deploymentRoot = null;
            try {
                deploymentRoot = EGLDDRootHelper.getEGLDDFileSharedWorkingModel(copyfrFile, false);
                if (deploymentRoot != null) {
                    this.fTreeViewer.setInput((Object)deploymentRoot);
                    this.fTreeViewer.expandAll();
                }
            }
            finally {
                if (deploymentRoot != null) {
                    EGLDDRootHelper.releaseSharedWorkingModel(copyfrFile, false);
                }
            }
        }
    }

    @Override
    protected boolean validatePage() {
        this.fFileStatus.setOK();
        String copyFrFilePath = this.fEGLDDFileNameField.getText();
        if (copyFrFilePath == null || copyFrFilePath.trim().length() == 0) {
            this.fFileStatus.setError(NewWizardMessages.CopyEGLDDWizPageValidationSetEGLDD);
        } else {
            IFile copyfrFile = this.getConfiguration().getCopyFromEGLDDFile(copyFrFilePath);
            if (!copyfrFile.exists()) {
                String errMsg = NewWizardMessages.bind((String)NewWizardMessages.CopyEGLDDWizPageValidationFileNotExist, (Object)copyFrFilePath);
                this.fFileStatus.setError(errMsg);
            } else if (copyfrFile.equals((Object)this.getConfiguration().getCurrentEGLDDFile())) {
                this.fFileStatus.setError(NewWizardMessages.CopyEGLDDWizPageValidationCopySelf);
            }
        }
        this.updateStatus(new IStatus[]{this.fFileStatus});
        return !this.fFileStatus.isError();
    }
}

