/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.search;

import org.eclipse.edt.ide.core.internal.model.util.EGLModelUtil;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IFunction;
import org.eclipse.edt.ide.core.model.IPart;
import org.eclipse.edt.ide.core.model.Signature;

public class PrettySignature {
    public static String getSignature(IEGLElement element) {
        if (element == null) {
            return null;
        }
        switch (element.getElementType()) {
            case 10: {
                return PrettySignature.getFunctionSignature((IFunction)element);
            }
            case 8: {
                return EGLModelUtil.getFullyQualifiedName((IPart)((IPart)element));
            }
        }
        return element.getElementName();
    }

    public static String getFunctionSignature(IFunction method) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(EGLModelUtil.getFullyQualifiedName((IPart)method.getDeclaringPart()));
        buffer.append('.');
        buffer.append(PrettySignature.getUnqualifiedFunctionSignature(method));
        return buffer.toString();
    }

    public static String getUnqualifiedTypeSignature(IPart type) {
        return type.getElementName();
    }

    public static String getUnqualifiedFunctionSignature(IFunction method) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(method.getElementName());
        buffer.append('(');
        String[] types = method.getParameterTypes();
        if (types.length > 0) {
            buffer.append(Signature.toString((String)types[0]));
        }
        int i = 1;
        while (i < types.length) {
            buffer.append(", ");
            buffer.append(Signature.toString((String)types[i]));
            ++i;
        }
        buffer.append(')');
        return buffer.toString();
    }
}

